/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderFileVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.OrderDetailEntity;
import com.biz.crm.order.OrderEntity;
import com.biz.crm.order.mapper.OrderMapper;
import com.biz.crm.order.service.OrderDetailPromotionService;
import com.biz.crm.order.service.OrderDetailService;
import com.biz.crm.order.service.OrderFileService;
import com.biz.crm.order.service.OrderService;
import com.biz.crm.order.tools.excutor.CalOrderExcutor;
import com.biz.crm.order.tools.excutor.CompletionProductMsgExcutor;
import com.biz.crm.order.tools.excutor.OrderValidateParamExcutor;
import com.biz.crm.order.tools.excutor.ValidateRebateFeeExcutor;
import com.biz.crm.order.tools.handler.OrderBackFeeHandler;
import com.biz.crm.order.tools.handler.OrderCalPriceHandler;
import com.biz.crm.order.tools.handler.OrderMinBuyNumHandler;
import com.biz.crm.order.tools.handler.OrderPromotionHandler;
import com.biz.crm.order.tools.handler.OrderUseFeeHandler;
import com.biz.crm.order.tools.strategy.calorder.impl.FreeCalOrderStrategy;
import com.biz.crm.order.tools.strategy.calorder.impl.RebateCalOrderStrategy;
import com.biz.crm.order.tools.strategy.calorder.impl.StanderdCalOrderStrategy;
import com.biz.crm.order.tools.strategy.completionproductmsg.impl.FreeCompletionProductMsgStrategy;
import com.biz.crm.order.tools.strategy.completionproductmsg.impl.RebateCompletionProductMsgStrategy;
import com.biz.crm.order.tools.strategy.completionproductmsg.impl.StanderdCompletionProductMsgStrategy;
import com.biz.crm.order.tools.strategy.ordervalidateparam.impl.FreeOrderValidateParamStrategy;
import com.biz.crm.order.tools.strategy.ordervalidateparam.impl.RebateOrderValidateParamStrategy;
import com.biz.crm.order.tools.strategy.ordervalidateparam.impl.StanderdOrderValidateParamStrategy;
import com.biz.crm.order.tools.strategy.validaterebate.impl.RebateOrderValidateFeeStategy;
import com.biz.crm.order.tools.strategy.validaterebate.impl.StanderdOrderValidateFeeStategy;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderServiceExpandImpl"})
@Service(value="orderService")
public class OrderServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<OrderMapper, OrderEntity>
implements OrderService {
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private OrderDetailService orderDetailService;
    @Resource
    private OrderFileService orderFileService;
    @Resource
    private OrderUtil orderUtil;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private FreeOrderValidateParamStrategy freeOrderValidateParamStrategy;
    @Resource
    private RebateOrderValidateParamStrategy rebateOrderValidateParamStrategy;
    @Resource
    private StanderdOrderValidateParamStrategy standerdOrderValidateParamStrategy;
    @Resource
    private StanderdCompletionProductMsgStrategy standerdCompletionProductMsgStrategy;
    @Resource
    private RebateCompletionProductMsgStrategy rebateCompletionProductMsgStrategy;
    @Resource
    private FreeCompletionProductMsgStrategy freeCompletionProductMsgStrategy;
    @Resource
    private StanderdOrderValidateFeeStategy standerdOrderValidateFeeStategy;
    @Resource
    private RebateOrderValidateFeeStategy rebateOrderValidateFeeStategy;
    @Resource
    private StanderdCalOrderStrategy standerdCalOrderStrategy;
    @Resource
    private RebateCalOrderStrategy rebateCalOrderStrategy;
    @Resource
    private FreeCalOrderStrategy freeCalOrderStrategy;
    @Resource
    private OrderMinBuyNumHandler orderMinBuyNumHandler;
    @Resource
    private OrderPromotionHandler orderPromotionHandler;
    @Resource
    private OrderCalPriceHandler orderCalPriceHandler;
    @Resource
    private OrderUseFeeHandler orderUseFeeHandler;
    @Resource
    private OrderBackFeeHandler orderBackFeeHandler;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private OrderDetailPromotionService orderDetailPromotionService;

    @Override
    public OrderVo cal(OrderVo orderVo, boolean orderFalg) {
        OrderValidateParamExcutor.validate(this.standerdOrderValidateParamStrategy, orderVo, new Object[0]);
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
        String cusCode = orderVo.getCusCode();
        String orgCode = "";
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.query(null, cusCode), (boolean)true);
        orderVo.setCusOrgCode(mdmCustomerMsgRespVo.getOrgCode());
        orderVo.setCusOrgName(mdmCustomerMsgRespVo.getOrgName());
        orgCode = mdmCustomerMsgRespVo.getOrgCode();
        orderVo = this.orderUtil.createLineAndSort(orderVo);
        if (orderFalg && (orderVo = this.orderMinBuyNumHandler.handle(orderVo, cusCode, orgCode)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        if ((orderVo = CompletionProductMsgExcutor.completion(this.standerdCompletionProductMsgStrategy, orderVo, cusCode, orgCode, new Object[0])).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        orderVo = this.orderCalPriceHandler.cal(orderVo);
        if ((orderVo = this.orderPromotionHandler.handle(orderVo, cusCode, orgCode, new Object[0])).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        if ((orderVo = ValidateRebateFeeExcutor.validate(this.standerdOrderValidateFeeStategy, orderVo, cusCode, orgCode, new Object[0])).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        orderVo = CalOrderExcutor.cal(this.standerdCalOrderStrategy, orderVo, cusCode, orgCode, new Object[0]);
        return this.orderUtil.createLineAndSort(orderVo);
    }

    @Override
    public OrderVo calForRebate(OrderVo orderVo) {
        OrderValidateParamExcutor.validate(this.rebateOrderValidateParamStrategy, orderVo, new Object[0]);
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
        String cusCode = orderVo.getCusCode();
        String orgCode = "";
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.query(null, cusCode), (boolean)true);
        orderVo.setCusOrgCode(mdmCustomerMsgRespVo.getOrgCode());
        orderVo.setCusOrgName(mdmCustomerMsgRespVo.getOrgName());
        orgCode = mdmCustomerMsgRespVo.getOrgCode();
        orderVo = this.orderUtil.createLineAndSort(orderVo);
        orderVo = CompletionProductMsgExcutor.completion(this.rebateCompletionProductMsgStrategy, orderVo, cusCode, orgCode, new Object[0]);
        if (orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        orderVo = this.orderCalPriceHandler.cal(orderVo);
        if ((orderVo = ValidateRebateFeeExcutor.validate(this.rebateOrderValidateFeeStategy, orderVo, cusCode, orgCode, new Object[0])).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        orderVo = CalOrderExcutor.cal(this.rebateCalOrderStrategy, orderVo, cusCode, orgCode, new Object[0]);
        return this.orderUtil.createLineAndSort(orderVo);
    }

    @Override
    public OrderVo calForFree(OrderVo orderVo) {
        OrderValidateParamExcutor.validate(this.freeOrderValidateParamStrategy, orderVo, 1, "2", 5);
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
        String cusCode = orderVo.getCusCode();
        String orgCode = "";
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.query(null, cusCode), (boolean)true);
        orderVo.setCusOrgCode(mdmCustomerMsgRespVo.getOrgCode());
        orderVo.setCusOrgName(mdmCustomerMsgRespVo.getOrgName());
        orgCode = mdmCustomerMsgRespVo.getOrgCode();
        orderVo = this.orderUtil.createLineAndSort(orderVo);
        orderVo = CompletionProductMsgExcutor.completion(this.freeCompletionProductMsgStrategy, orderVo, cusCode, orgCode, new Object[0]);
        if (orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return this.orderUtil.createLineAndSort(orderVo);
        }
        orderVo = this.orderCalPriceHandler.cal(orderVo);
        orderVo = CalOrderExcutor.cal(this.freeCalOrderStrategy, orderVo, cusCode, orgCode, new Object[0]);
        return this.orderUtil.createLineAndSort(orderVo);
    }

    @Override
    @Transactional
    public void temporaryAdd(OrderVo orderVo) {
        this.cal(orderVo, true);
        if (orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u68c0\u67e5\uff01";
            }
            throw new BusinessException(msg);
        }
        orderVo.setState(OrderEunm.STATE.TOSUBMIT.getCode());
        OrderEntity orderEntity = this.orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.YES.getValue());
        this.save(orderEntity);
        this.orderDetailService.addBatch(orderVo, orderEntity, true);
        this.orderFileService.replace(orderEntity.getOrderCode(), orderVo.getFiles());
        this.orderDetailPromotionService.rePlace(orderEntity, OrderUtil.extractPromotion(orderVo));
    }

    @Override
    public void edit(OrderVo orderVo) {
        if (StringUtils.isEmpty((String)orderVo.getId())) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)orderVo.getId()));
        OrderVo oldObject = this.findDetailsById(orderVo.getId());
        String type = orderVo.getType();
        if ((orderVo = type.equals(OrderEunm.TYPE.STANDERD.getCode()) ? this.cal(orderVo, true) : (type.equals(OrderEunm.TYPE.FREE.getCode()) ? this.calForFree(orderVo) : this.calForRebate(orderVo))).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u68c0\u67e5\uff01";
            }
            throw new BusinessException(msg);
        }
        orderEntity = this.orderUtil.packageOrderHeadForEndit(orderVo, orderEntity);
        this.updateById(orderEntity);
        this.orderDetailService.editBatch(orderVo, orderEntity, !orderVo.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.YES.getValue()));
        this.orderFileService.replace(orderEntity.getOrderCode(), orderVo.getFiles());
        this.orderDetailPromotionService.rePlace(orderEntity, OrderUtil.extractPromotion(orderVo));
        OrderVo newObject = this.findDetailsById(orderVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newObject.getId(), newObject.getId(), (Object)oldObject, (Object)newObject);
        }
    }

    @Override
    @Transactional
    public void add(OrderVo orderVo) {
        if (orderVo.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.YES.getValue())) {
            this.delByOrderCode(orderVo.getOrderCode());
        }
        if ((orderVo = this.cal(orderVo, true)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u8fd4\u56de\u68c0\u67e5\u8ba2\u5355\u884c\u9519\u8bef\u4fe1\u606f\uff01";
            }
            throw new BusinessException(msg);
        }
        orderVo.setState(OrderEunm.STATE.TOAPPROVAL.getCode());
        orderVo.setId("");
        OrderEntity orderEntity = this.orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.NO.getValue());
        this.save(orderEntity);
        List<OrderDetailEntity> detailEntities = this.orderDetailService.addBatch(orderVo, orderEntity, true);
        this.orderFileService.replace(orderEntity.getOrderCode(), orderVo.getFiles());
        this.orderUseFeeHandler.hand(orderEntity, detailEntities);
        this.orderDetailPromotionService.rePlace(orderEntity, OrderUtil.extractPromotion(orderVo));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        OrderVo detailsById = this.findDetailsById(orderEntity.getId());
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), detailsById.getId(), detailsById.getId(), (Object)detailsById);
        }
    }

    @Override
    public void addForRebate(OrderVo orderVo) {
        if ((orderVo = this.calForRebate(orderVo)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u8fd4\u56de\u68c0\u67e5\u8ba2\u5355\u884c\u9519\u8bef\u4fe1\u606f\uff01";
            }
            throw new BusinessException(msg);
        }
        orderVo.setState(OrderEunm.STATE.TOAPPROVAL.getCode());
        orderVo.setId("");
        OrderEntity orderEntity = this.orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.NO.getValue());
        this.save(orderEntity);
        List<OrderDetailEntity> detailEntities = this.orderDetailService.addBatch(orderVo, orderEntity, true);
        this.orderFileService.replace(orderEntity.getOrderCode(), orderVo.getFiles());
        this.orderUseFeeHandler.hand(orderEntity, detailEntities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        OrderVo detailsById = this.findDetailsById(orderEntity.getId());
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), detailsById.getId(), detailsById.getId(), (Object)detailsById);
        }
    }

    @Override
    public void addForFree(OrderVo orderVo) {
        if ((orderVo = this.calForFree(orderVo)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u8fd4\u56de\u68c0\u67e5\u8ba2\u5355\u884c\u9519\u8bef\u4fe1\u606f\uff01";
            }
            throw new BusinessException(msg);
        }
        orderVo.setState(OrderEunm.STATE.TOAPPROVAL.getCode());
        orderVo.setId("");
        OrderEntity orderEntity = this.orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.NO.getValue());
        this.save(orderEntity);
        this.orderDetailService.addBatch(orderVo, orderEntity, true);
        this.orderFileService.replace(orderEntity.getOrderCode(), orderVo.getFiles());
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        OrderVo detailsById = this.findDetailsById(orderEntity.getId());
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), detailsById.getId(), detailsById.getId(), (Object)detailsById);
        }
    }

    @Override
    public void delByOrderCode(String orderCode) {
        if (StringUtils.isEmpty((String)orderCode)) {
            return;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderCode);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        OrderEntity entity = (OrderEntity)this.orderMapper.selectOne((Wrapper)wrapper);
        OrderVo detailsById = this.findDetailsById(entity.getId());
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), detailsById.getId(), detailsById.getId(), (Object)detailsById);
        }
        this.orderMapper.delete((Wrapper)wrapper);
        this.orderDetailService.deleteByOrderCode(orderCode);
        this.orderFileService.deleteByOrderCode(orderCode);
        this.orderDetailPromotionService.delByOrderCode(orderCode);
    }

    @Override
    public void cancel(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.updateStateByIds(ids, OrderEunm.STATE.CANCEL);
        List orderEntities = this.orderMapper.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)orderEntities)) {
            return;
        }
        this.orderBackFeeHandler.hand(orderEntities);
    }

    @Override
    @Transactional
    public void updateStateByIds(List<String> ids, OrderEunm.STATE state) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.orderMapper.updateStateByIds(state.getCode(), ids);
    }

    @Override
    public OrderVo findDetailsById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        OrderEntity entity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)id));
        OrderVo vo = (OrderVo)CrmBeanUtil.copy((Object)entity, OrderVo.class);
        if (vo == null) {
            return null;
        }
        List<OrderFileVo> files = this.orderFileService.findByOrderCode(vo.getOrderCode());
        vo.setFiles(files);
        List<OrderGroupItemVo> groupItemVos = this.orderDetailService.findGroupByOrderCode(vo.getOrderCode());
        vo.setGroupItemVos(groupItemVos);
        List<OrderDetailPromotionVo> promotionVos = this.orderDetailPromotionService.findPromotionByOrderCode(vo.getOrderCode());
        OrderUtil.packagePromotionToVo(vo, promotionVos);
        String type = entity.getType();
        if (type.equals(OrderEunm.TYPE.STANDERD.getCode())) {
            return this.cal(vo, false);
        }
        if (type.equals(OrderEunm.TYPE.FREE.getCode())) {
            return this.calForFree(vo);
        }
        return this.calForRebate(vo);
    }

    @Override
    public OrderVo findDetailByCode(String orderCode) {
        if (StringUtils.isEmpty((String)orderCode)) {
            return null;
        }
        OrderEntity entity = (OrderEntity)this.orderMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"order_code", (Object)orderCode));
        OrderVo vo = (OrderVo)CrmBeanUtil.copy((Object)entity, OrderVo.class);
        if (vo == null) {
            return null;
        }
        List<OrderFileVo> files = this.orderFileService.findByOrderCode(vo.getOrderCode());
        vo.setFiles(files);
        List<OrderGroupItemVo> groupItemVos = this.orderDetailService.findGroupByOrderCode(vo.getOrderCode());
        vo.setGroupItemVos(groupItemVos);
        List<OrderDetailPromotionVo> promotionVos = this.orderDetailPromotionService.findPromotionByOrderCode(vo.getOrderCode());
        OrderUtil.packagePromotionToVo(vo, promotionVos);
        return vo;
    }

    @Override
    public OrderVo findSimpleDetailsById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        OrderEntity entity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)id));
        OrderVo vo = (OrderVo)CrmBeanUtil.copy((Object)entity, OrderVo.class);
        if (vo == null) {
            return null;
        }
        List<OrderFileVo> files = this.orderFileService.findByOrderCode(vo.getOrderCode());
        vo.setFiles(files);
        List<OrderGroupItemVo> groupItemVos = this.orderDetailService.findGroupByOrderCode(vo.getOrderCode());
        vo.setGroupItemVos(groupItemVos);
        List<OrderDetailPromotionVo> promotionVos = this.orderDetailPromotionService.findPromotionByOrderCode(vo.getOrderCode());
        OrderUtil.packagePromotionToVo(vo, promotionVos);
        return vo;
    }

    @Override
    public OrderVo collect(OrderVo orderVo) {
        if ((orderVo = this.cal(orderVo, false)).getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            String msg = orderVo.getCalSucessMsg();
            if (StringUtils.isEmpty((String)orderVo.getCalSucessMsg())) {
                msg = "\u8ba2\u5355\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u8fd4\u56de\u68c0\u67e5\u8ba2\u5355\u884c\u9519\u8bef\u4fe1\u606f\uff01";
            }
            throw new BusinessException(msg);
        }
        OrderUtil.collect(orderVo);
        return orderVo;
    }

    @Override
    public PageResult<OrderVo> listByConditions(OrderVo orderVo) {
        Page page = new Page((long)orderVo.getPageNum().intValue(), (long)orderVo.getPageSize().intValue());
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(StringUtils.isNotEmpty((String)orderVo.getOrderCode()), (Object)"order_code", (Object)orderVo.getOrderCode())).eq(StringUtils.isNotEmpty((String)orderVo.getState()), (Object)"state", (Object)orderVo.getState())).eq(StringUtils.isNotEmpty((String)orderVo.getFromType()), (Object)"from_type", (Object)orderVo.getFromType())).eq(StringUtils.isNotEmpty((String)orderVo.getCusCode()), (Object)"cus_code", (Object)orderVo.getCusCode())).like(StringUtils.isNotEmpty((String)orderVo.getCusName()), (Object)"cus_name", (Object)orderVo.getCusName())).eq(orderVo.getTemporaryFlag() != null, (Object)"temporary_flag", (Object)orderVo.getTemporaryFlag())).ge(StringUtils.isNotEmpty((String)orderVo.getBeginDate()), (Object)"create_date", (Object)orderVo.getBeginDate())).le(StringUtils.isNotEmpty((String)orderVo.getEndDate()), (Object)"create_date", (Object)orderVo.getEndDate());
        queryWrapper.orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        List<OrderVo> list = this.orderMapper.list((Page<OrderVo>)page, (QueryWrapper<OrderVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        ValidateUtils.notEmpty(ids, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        UserRedis user = UserUtils.getUser();
        ValidateUtils.validate((Object)user, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ValidateUtils.validate((Object)user.getCustcode(), (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u5ba2\u6237\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\u64cd\u4f5c\u8005\u8eab\u4efd\u548c\u6743\u9650\u662f\u5426\u6b63\u786e");
        ArrayList orderCodes = Lists.newArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            OrderEntity entity = (OrderEntity)((OrderMapper)this.baseMapper).selectById((Serializable)((Object)ids.get(i)));
            ValidateUtils.validate((Object)entity, (String)"\u4f20\u5165\u7684\u7b2c%d\u4e2a\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{i});
            ValidateUtils.isTrue((boolean)Objects.equals(user.getCustcode(), entity.getCusCode()), (String)"\u4f20\u5165\u7684\u7b2c%d\u4e2a\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u7528\u6237\u3010%s\u3011\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{i, user.getCustcode()});
            ValidateUtils.isTrue((boolean)Objects.equals(YesNoEnum.yesNoEnum.YES.getValue(), entity.getTemporaryFlag()), (String)"\u4f20\u5165\u7684\u7b2c%d\u4e2a\u8ba2\u5355\u3010\u8ba2\u5355\u53f7\uff1a%s\u3011\u4e0d\u662f\u6682\u5b58\u5355\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{i, entity.getOrderCode()});
            orderCodes.add(entity.getOrderCode());
        }
        this.orderDetailService.deleteByOrderCodes(orderCodes);
        this.orderFileService.deleteByOrderCodes(orderCodes);
        this.orderMapper.deleteBatchIds(ids);
    }
}

