/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.OrderDetailEntity;
import com.biz.crm.order.OrderEntity;
import com.biz.crm.order.mapper.OrderDetailMapper;
import com.biz.crm.order.mapper.OrderDetailPromotionMapper;
import com.biz.crm.order.service.OrderDetailService;
import com.biz.crm.order.utils.OrderDetailUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"orderDetailServiceExpandImpl"})
@Service(value="orderDetailService")
public class OrderDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<OrderDetailMapper, OrderDetailEntity>
implements OrderDetailService {
    @Resource
    private OrderDetailPromotionMapper orderDetailPromotionMapper;
    @Resource
    private OrderDetailMapper orderDetailMapper;

    @Override
    @Transactional
    public List<OrderDetailEntity> addBatch(OrderVo orderVo, OrderEntity orderEntity, boolean removeZreoFlag) {
        List<OrderDetailEntity> orderDetailEntities = OrderDetailUtil.packageOrderDetails(orderVo, orderEntity, removeZreoFlag);
        this.saveBatch(orderDetailEntities);
        return orderDetailEntities;
    }

    @Override
    public List<OrderDetailEntity> editBatch(OrderVo orderVo, OrderEntity orderEntity, boolean removeZreoFlag) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderEntity.getOrderCode());
        this.orderDetailMapper.delete((Wrapper)wrapper);
        return this.addBatch(orderVo, orderEntity, removeZreoFlag);
    }

    @Override
    @Transactional
    public void deleteByOrderCode(String orderCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderCode);
        this.orderDetailMapper.delete((Wrapper)wrapper);
    }

    @Override
    public List<OrderGroupItemVo> findGroupByOrderCode(String orderCode) {
        if (StringUtils.isEmpty((String)orderCode)) {
            return Lists.newArrayList();
        }
        List<OrderDetailVo> detailVos = this.findByOrderCode(orderCode);
        if (CollectionUtil.listEmpty(detailVos)) {
            return Lists.newArrayList();
        }
        return this.groupOrderDetails(detailVos);
    }

    private List<OrderGroupItemVo> groupOrderDetails(List<OrderDetailVo> detailVos) {
        if (CollectionUtil.listEmpty(detailVos)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        Map<String, List<OrderDetailVo>> groupItemMap = detailVos.stream().collect(Collectors.groupingBy(OrderDetailVo::getGroupCode));
        groupItemMap.forEach((k, details) -> {
            List normalList = details.stream().filter(detail -> OrderEunm.LineTypeEnum.SOURCE_PRODUCT.getCode().equals(detail.getLineType())).sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
            List giftList = details.stream().filter(detail -> OrderEunm.LineTypeEnum.GIFT_PRODUCT.getCode().equals(detail.getLineType())).sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
            List backList = details.stream().filter(detail -> OrderEunm.LineTypeEnum.REP_PRODUCT.getCode().equals(detail.getLineType())).sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
            List reissueList = details.stream().filter(detail -> OrderEunm.LineTypeEnum.REISSUE_PRODUCT.getCode().equals(detail.getLineType())).sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
            OrderGroupItemVo groupItemVo = new OrderGroupItemVo();
            groupItemVo.setGroupCode(k);
            groupItemVo.setNormalList(normalList);
            groupItemVo.setGiftList(giftList);
            groupItemVo.setBackList(backList);
            groupItemVo.setReissueList(reissueList);
            result.add(groupItemVo);
        });
        return result.stream().sorted(Comparator.comparing(OrderGroupItemVo::getGroupCode)).collect(Collectors.toList());
    }

    @Override
    public List<OrderDetailVo> findByOrderCode(String orderCode) {
        if (StringUtils.isEmpty((String)orderCode)) {
            return Lists.newArrayList();
        }
        List entities = this.orderDetailMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"order_code", (Object)orderCode)).orderByAsc((Object)"line_no"));
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList((List)entities, OrderDetailVo.class);
    }

    @Override
    @Transactional
    public void deleteByOrderCodes(List<String> orderCodes) {
        ValidateUtils.notEmpty(orderCodes, (String)"\u5220\u9664\u8ba2\u5355\u660e\u7ec6\u65f6\uff0c\u4f20\u5165\u8ba2\u5355\u7f16\u7801\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"order_code", orderCodes);
        this.orderDetailMapper.delete((Wrapper)wrapper);
    }
}

