/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.completionproductmsg.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceRespVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.completionproductmsg.CompletionProductMsgStrategy;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"rebateCompletionProductMsgStrategyExpand"})
@Component(value="rebateCompletionProductMsgStrategy")
public class RebateCompletionProductMsgStrategy
implements CompletionProductMsgStrategy {
    @Autowired
    private MdmProductFeign mdmProductFeign;

    @Override
    public OrderVo completion(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        List<String> productCode = this.extractProductCodes(orderVo);
        Result result = this.mdmProductFeign.queryByProductCodeAndCus(MdmProductAdviseAndPriceReqVo.newInstanceForSalePrice((String)cusCode, (String)orgCode, productCode));
        if (!result.isSuccess()) {
            throw new BusinessException("\u5546\u54c1\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Map productMap = (Map)result.getResult();
        orderVo = this.packageProductMsg(orderVo, productMap);
        return orderVo;
    }

    public OrderVo packageProductMsg(OrderVo orderVo, Map<String, MdmProductAdviseAndPriceRespVo> productMsp) {
        Map unitMap = DictUtil.getDictValueMapsByCodes((String)"product_sale_unit");
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            this.packageGroup(orderVo, groupItemVo, productMsp, unitMap);
        }
        return orderVo;
    }

    public void packageGroup(OrderVo orderVo, OrderGroupItemVo groupItemVo, Map<String, MdmProductAdviseAndPriceRespVo> productMsp, Map<String, String> unitMap) {
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) {
            ArrayList<OrderDetailVo> backList = new ArrayList<OrderDetailVo>();
            for (OrderDetailVo item : groupItemVo.getBackList()) {
                StringBuilder stb;
                MdmProductAdviseAndPriceRespVo product = productMsp.get(item.getProductCode());
                if (null == product) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u5546\u54c1\u3010").append(item.getProductName()).append("\u3011\u5df2\u7ecf\u4e0b\u67b6\uff01");
                    item.setCalSucessMsg(stb.toString());
                } else {
                    if (null == product.getSalePrice()) {
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        stb = new StringBuilder("\u63d0\u793a\uff1a\u5546\u54c1\u3010").append(item.getProductName()).append("\u3011\u672a\u7ef4\u62a4\u4ef7\u683c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                        item.setCalSucessMsg(stb.toString());
                    }
                    this.packageItemVo(item, product, unitMap);
                }
                backList.add(item);
            }
            groupItemVo.setBackList(backList);
        }
    }

    public OrderDetailVo packageItemVo(OrderDetailVo item, MdmProductAdviseAndPriceRespVo product, Map<String, String> unitMap) {
        item.setProductName(product.getProductName());
        item.setSpec(product.getSpec());
        item.setSalesUnit(product.getSaleUnit());
        item.setSalesUnitName(unitMap.get(product.getSaleUnit()));
        item.setPrice(product.getSalePrice());
        item.setImgUrl(product.getImgUrl());
        item.setProductLevelCode(product.getProductLevelCode());
        return item;
    }

    public List<String> extractProductCodes(OrderVo orderVo) {
        HashSet<String> set = new HashSet<String>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo item : groupItemVo.getBackList()) {
                set.add(item.getProductCode());
            }
        }
        return new ArrayList<String>(set);
    }
}

