/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.rebate.rebatedetail.RebateDetailAdjustLogVo;
import com.biz.crm.nebular.rebate.rebatedetail.RebateDetailVo;
import com.biz.crm.rebate.entity.RebateDetailEntity;
import com.biz.crm.rebate.mapper.RebateDetailMapper;
import com.biz.crm.rebate.service.RebateDetailAdjustLogService;
import com.biz.crm.rebate.service.RebateDetailService;
import com.biz.crm.rebate.util.CommonFieldUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateDetailService")
@ConditionalOnMissingBean(name={"rebateDetailServiceImpl"})
public class RebateDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateDetailMapper, RebateDetailEntity>
implements RebateDetailService {
    @Resource
    private RebateDetailMapper rebateDetailMapper;
    @Resource
    private RebateDetailAdjustLogService rebateDetailAdjustLogService;

    @Override
    @Transactional
    public List<RebateDetailVo> addBatch(List<RebateDetailVo> vos) {
        this.validateAddBatch(vos);
        CommonFieldUtil.initCreateFields(vos);
        vos.forEach(vo -> vo.setCode(CodeUtil.getCode()));
        List entities = CrmBeanUtil.copyList(vos, RebateDetailEntity.class);
        this.saveBatch(entities);
        return CrmBeanUtil.copyList((List)entities, RebateDetailVo.class);
    }

    @Override
    public RebateDetailVo adjust(RebateDetailAdjustLogVo logVo) {
        this.validateAdjust(logVo);
        RebateDetailEntity entity = (RebateDetailEntity)((Object)this.rebateDetailMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"code", (Object)logVo.getRebateDetailCode())));
        entity.setAdjustAmount(entity.getAdjustAmount().add(logVo.getAdjustAmount()));
        entity.setActualAmount(entity.getComputeAmount().add(entity.getAdjustAmount()));
        CommonFieldUtil.initUpdateFields((Object)entity);
        this.updateById((Object)entity);
        this.rebateDetailAdjustLogService.add(logVo, logVo.getRebateDetailCode());
        return (RebateDetailVo)CrmBeanUtil.copy((Object)((Object)entity), RebateDetailVo.class);
    }

    private void validateAdjust(RebateDetailAdjustLogVo logVo) {
        ValidateUtils.validate((Object)logVo, (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)logVo.getRebateDetailCode(), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)logVo.getAdjustAmount(), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)(logVo.getAdjustAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u91cf\u5fc5\u987b\u5927\u4e8e0");
    }

    private void validateAddBatch(List<RebateDetailVo> vos) {
        ValidateUtils.notEmpty(vos, (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u8fd4\u5229\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        for (int i = 0; i < vos.size(); ++i) {
            RebateDetailVo vo = vos.get(0);
            ValidateUtils.validate((Object)vo.getCode(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getCusName(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getName(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u8fd4\u5229\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[]{i});
        }
    }
}

