/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.product.RebateProductVo;
import com.biz.crm.rebate.entity.RebateProductEntity;
import com.biz.crm.rebate.mapper.RebateProductMapper;
import com.biz.crm.rebate.service.RebateProductService;
import com.biz.crm.rebate.util.RebateProductUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"rebateProductServiceExpandImpl"})
@Service(value="rebateProductService")
public class RebateProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateProductMapper, RebateProductEntity>
implements RebateProductService {
    @Resource
    private RebateProductMapper rebateProductMapper;

    @Override
    @Transactional
    public void add(List<RebateProductVo> productVos, String rebateCode) {
        if (CollectionUtil.listEmpty(productVos)) {
            return;
        }
        RebateProductUtil.validateProduct(productVos);
        List collect = productVos.stream().map(product -> product.setRebateCode(rebateCode)).collect(Collectors.toList());
        this.saveBatch(CrmBeanUtil.copyList(collect, RebateProductEntity.class));
    }

    @Override
    @Transactional
    public void delByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.rebateProductMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional
    public void delByRebateCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            throw new BusinessException("\u5220\u9664\u4ea7\u54c1\u65f6\uff0c\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.rebateProductMapper.delete((Wrapper)new QueryWrapper().in((Object)"rebate_code", codes));
    }

    @Override
    public Map<String, List<RebateProductVo>> listByRebateCodes(List<String> rebateCodes) {
        HashMap<String, List<RebateProductVo>> result = new HashMap<String, List<RebateProductVo>>();
        if (CollectionUtil.listEmpty(rebateCodes)) {
            return result;
        }
        List productEntities = this.rebateProductMapper.selectList((Wrapper)new QueryWrapper().in((Object)"rebate_code", rebateCodes));
        if (CollectionUtils.isEmpty((Collection)productEntities)) {
            return result;
        }
        List productVos = CrmBeanUtil.copyList((List)productEntities, RebateProductVo.class);
        for (String code : rebateCodes) {
            if (!CollectionUtils.isEmpty((Collection)productVos)) {
                result.put(code, productVos.stream().filter(o -> o.getRebateCode().equals(code)).collect(Collectors.toList()));
                continue;
            }
            result.put(code, new ArrayList());
        }
        return result;
    }

    @Override
    @Transactional
    public void replace(List<RebateProductVo> productVos, final String rebateCode) {
        ValidateUtils.validate((Object)rebateCode, (String)"\u8bf7\u6307\u5b9a\u653f\u7b56\u7f16\u7801\uff01");
        if (CollectionUtil.listEmpty(productVos)) {
            return;
        }
        RebateProductUtil.validateProduct(productVos);
        List rebateProductVos = productVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<RebateProductVo>(Comparator.comparing(o -> o.getProductCode() + ";" + o.getAssessFlag() + ";" + o.getAssessFlag()))), ArrayList::new));
        List existEntities = this.rebateProductMapper.selectList((Wrapper)Wrappers.lambdaQuery(RebateProductEntity.class).eq(RebateProductEntity::getRebateCode, (Object)rebateCode));
        List existVos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)existEntities)) {
            existVos = CrmBeanUtil.copyList((List)existEntities, RebateProductVo.class);
        }
        if (CollectionUtils.isEmpty((Collection)rebateProductVos)) {
            this.delByRebateCodes((List<String>)new ArrayList<String>(){
                {
                    this.add(rebateCode);
                }
            });
        }
        ArrayList delProductVo = Lists.newArrayList();
        ArrayList<RebateProductVo> haveId = new ArrayList<RebateProductVo>();
        ArrayList<RebateProductVo> nonId = new ArrayList<RebateProductVo>();
        for (RebateProductVo productVo : rebateProductVos) {
            if (StringUtils.isEmpty((String)productVo.getId())) {
                nonId.add(productVo);
                continue;
            }
            haveId.add(productVo);
        }
        for (RebateProductVo rebateProductVo : existVos) {
            for (RebateProductVo haveIdRebateProductVo : haveId) {
                if (rebateProductVo.getId().equals(haveIdRebateProductVo.getId())) continue;
                delProductVo.add(rebateProductVo);
            }
        }
        this.add(rebateProductVos, rebateCode);
        List<String> delProductCode = delProductVo.stream().map(o -> o.getProductCode()).collect(Collectors.toList());
        List<String> delProductLevelCode = delProductVo.stream().map(o -> o.getProductLevelCode()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(delProductCode)) {
            this.rebateProductMapper.delByProCode(delProductCode, rebateCode);
        }
        if (CollectionUtils.isEmpty(delProductLevelCode)) {
            this.rebateProductMapper.delByProLevelCode(delProductLevelCode, rebateCode);
        }
    }

    @Override
    public Map<String, Map<String, List<RebateProductVo>>> MapByRebateCodes(List<String> rebateCodes) {
        HashMap<String, Map<String, List<RebateProductVo>>> result = new HashMap<String, Map<String, List<RebateProductVo>>>();
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        if (CollectionUtils.isEmpty(rebateCodes)) {
            return result;
        }
        List productVos = CrmBeanUtil.copyList((List)this.rebateProductMapper.selectList((Wrapper)new QueryWrapper().in((Object)"rebate_code", rebateCodes)), RebateProductVo.class);
        for (String code : rebateCodes) {
            if (CollectionUtils.isEmpty((Collection)productVos)) {
                result.put(code, map);
                continue;
            }
            List assassProduct = productVos.stream().filter(o -> o.getRebateCode().equals(code) && o.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && o.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(assassProduct)) {
                map.put("assassProduct", new ArrayList());
            } else {
                map.put("assassProduct", assassProduct);
            }
            List nonAssassProduct = productVos.stream().filter(o -> o.getRebateCode().equals(code) && o.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && o.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(assassProduct)) {
                map.put("nonAssassProduct", new ArrayList());
            } else {
                map.put("nonAssassProduct", nonAssassProduct);
            }
            List assassProductLevel = productVos.stream().filter(o -> o.getRebateCode().equals(code) && o.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && o.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(assassProduct)) {
                map.put("assassProductLevel", new ArrayList());
            } else {
                map.put("assassProductLevel", assassProductLevel);
            }
            List nonAssassProductLevel = productVos.stream().filter(o -> o.getRebateCode().equals(code) && o.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && o.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(assassProduct)) {
                map.put("nonAssassProductLevel", new ArrayList());
            } else {
                map.put("nonAssassProductLevel", nonAssassProductLevel);
            }
            result.put(code, map);
        }
        return result;
    }
}

