/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.nebular.rebate.expression.RebateExpressionVo;
import com.biz.crm.nebular.rebate.product.RebateProductVo;
import com.biz.crm.nebular.rebate.rebatedetail.RebateComputeParam;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.rebate.entity.RebateEntity;
import com.biz.crm.rebate.mapper.RebateMapper;
import com.biz.crm.rebate.service.RebateAreaService;
import com.biz.crm.rebate.service.RebateExpressionService;
import com.biz.crm.rebate.service.RebateProductService;
import com.biz.crm.rebate.service.RebateService;
import com.biz.crm.rebate.util.RebateUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"rebateServiceExpandImpl"})
@Service(value="rebateService")
public class RebateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateMapper, RebateEntity>
implements RebateService {
    @Resource
    private RebateMapper rebateMapper;
    @Resource
    private RebateAreaService rebateAreaService;
    @Resource
    private RebateProductService rebateProductService;
    @Resource
    private RebateExpressionService rebateExpressionService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;

    @Override
    @Transactional
    public void add(RebateVo rebateVo) {
        RebateUtil.validateForAddOrEdit(rebateVo);
        final String code = rebateVo.getCode();
        List rebateEntities = this.rebateMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("code", code);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)rebateEntities)) {
            throw new BusinessException("\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        RebateEntity rebateEntity = (RebateEntity)((Object)CrmBeanUtil.copy((Object)rebateVo, RebateEntity.class));
        this.rebateMapper.insert((Object)rebateEntity);
        List<RebateProductVo> rebateProductVoList = RebateUtil.assembleProductList(rebateVo);
        this.rebateProductService.replace(rebateProductVoList, code);
        List<RebateAreaVo> rebateAreaVoList = RebateUtil.assembleAreaList(rebateVo);
        this.rebateAreaService.replace(rebateAreaVoList, code);
        this.rebateExpressionService.replace(rebateVo.getRebateExpressionVos(), rebateVo.getCode());
    }

    @Override
    @Transactional
    public void update(RebateVo rebateVo) {
        RebateUtil.validateForAddOrEdit(rebateVo);
        RebateEntity rebateEntity = (RebateEntity)((Object)this.rebateMapper.selectById((Serializable)((Object)rebateVo.getId())));
        if (rebateEntity == null) {
            throw new BusinessException("\u8981\u4fee\u6539\u7684\u8fd4\u5229\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01");
        }
        rebateEntity = (RebateEntity)((Object)CrmBeanUtil.copy((Object)rebateVo, RebateEntity.class));
        this.rebateMapper.updateById((Object)rebateEntity);
        List<RebateProductVo> rebateProductVoList = RebateUtil.assembleProductList(rebateVo);
        this.rebateProductService.replace(rebateProductVoList, rebateEntity.getCode());
        List<RebateAreaVo> rebateAreaVoList = RebateUtil.assembleAreaList(rebateVo);
        this.rebateAreaService.replace(rebateAreaVoList, rebateEntity.getCode());
        this.rebateExpressionService.replace(rebateVo.getRebateExpressionVos(), rebateEntity.getCode());
    }

    @Override
    public RebateVo findById(String id) {
        RebateUtil.validate(id, "\u8bf7\u8f93\u5165\u8981\u67e5\u8be2\u7684\u8fd4\u5229\u653f\u7b56\u7684id\uff01");
        RebateEntity rebateEntity = (RebateEntity)((Object)this.rebateMapper.selectById((Serializable)((Object)id)));
        RebateVo rebateVo = (RebateVo)CrmBeanUtil.copy((Object)((Object)rebateEntity), RebateVo.class);
        final String code = rebateVo.getCode();
        Map<String, List<RebateProductVo>> productMap = this.rebateProductService.listByRebateCodes((List<String>)new ArrayList<String>(){
            {
                this.add(code);
            }
        });
        RebateUtil.disAssembleProductList(rebateVo, productMap);
        Map<String, Map<String, List<RebateAreaVo>>> areaMap = this.rebateAreaService.mapByRebateCodes((List<String>)new ArrayList<String>(){
            {
                this.add(code);
            }
        });
        RebateUtil.disAssembleAreaList(rebateVo, areaMap);
        List<RebateExpressionVo> rebateExpressionVos = this.rebateExpressionService.findByRebateCode(code);
        rebateVo.setRebateExpressionVos(rebateExpressionVos);
        return rebateVo;
    }

    @Override
    @Transactional
    public void delByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8981\u5220\u9664\u7684\u8fd4\u5229\u653f\u7b56\uff01");
        }
        List<String> codes = this.rebateMapper.selectCodesByIds(ids);
        this.rebateMapper.deleteBatchIds(ids);
        this.rebateProductService.delByRebateCodes(codes);
        this.rebateAreaService.delByRebateCodes(codes);
        codes.stream().forEach(code -> this.rebateExpressionService.deleteByRebateCode((String)code));
    }

    @Override
    public PageResult<RebateVo> list(RebateVo rebateVo) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.like(!StringUtils.isEmpty((String)rebateVo.getName()), (Object)"name", (Object)rebateVo.getName());
        queryWrapper.like(!StringUtils.isEmpty((String)rebateVo.getCode()), (Object)"code", (Object)rebateVo.getCode());
        queryWrapper.ge(!StringUtils.isEmpty((String)rebateVo.getRebateStartDate()), (Object)"rebate_start_date", (Object)rebateVo.getRebateStartDate());
        queryWrapper.le(!StringUtils.isEmpty((String)rebateVo.getRebateEndDate()), (Object)"rebate_end_date", (Object)rebateVo.getRebateEndDate());
        queryWrapper.ge(!StringUtils.isEmpty((String)rebateVo.getApplyStartDate()), (Object)"apply_start_date", (Object)rebateVo.getApplyStartDate());
        queryWrapper.le(!StringUtils.isEmpty((String)rebateVo.getApplyEndDate()), (Object)"apply_end_date", (Object)rebateVo.getApplyEndDate());
        Page page = PageUtil.buildPage((Integer)rebateVo.getPageNum(), (Integer)rebateVo.getPageSize());
        List<RebateVo> list = this.rebateMapper.list((Page<RebateVo>)page, (QueryWrapper<RebateVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void calByCodes(List codes, Date computeTime) {
        ValidateUtils.notEmpty((Collection)codes, (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u653f\u7b56\u7f16\u7801\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        if (computeTime == null) {
            computeTime = new Date();
        }
        String computeDateStr = DateUtil.getFormatDateStr((Date)computeTime, (String)"yyyy-MM-dd HH:mm:ss");
        List entities = this.rebateMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().in((Object)"code", (Collection)codes)).lt((Object)"create_date", (Object)computeDateStr));
        ValidateUtils.validate((Object)entities, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u4efb\u4f55%s\u4e4b\u524d\u7684\u653f\u7b56\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u653f\u7b56\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165", (Object[])new Object[]{computeDateStr});
        Map<String, List<RebateAreaVo>> cusMap = this.rebateAreaService.listByRebateCodes(codes);
        cusMap = this.buildCuss(cusMap);
        Map<String, List<RebateProductVo>> rebateProductMap = this.rebateProductService.listByRebateCodes(codes);
        rebateProductMap = this.buildRebateProducts(rebateProductMap);
        Map<String, List<RebateExpressionVo>> expressionMap = this.rebateExpressionService.listByRebateCodes(codes);
        List<RebateComputeParam> params = this.buildParam(entities, cusMap, rebateProductMap, expressionMap);
        String speedNo = CodeUtil.getCode();
        params.forEach(param -> param.setSpeedNo(speedNo));
    }

    private List<RebateComputeParam> buildParam(List<RebateEntity> entities, Map<String, List<RebateAreaVo>> cusMap, Map<String, List<RebateProductVo>> rebateProductMap, Map<String, List<RebateExpressionVo>> expressionMap) {
        ArrayList params = Lists.newArrayList();
        entities.forEach(en -> {
            List cuss = (List)cusMap.get(en.getCode());
            List productVos = (List)rebateProductMap.get(en.getCode());
            List expressionVos = (List)expressionMap.get(en.getCode());
            this.buildParam((RebateEntity)((Object)en), cuss, productVos, expressionVos, params);
        });
        return params;
    }

    private void buildParam(RebateEntity en, List<RebateAreaVo> cuss, List<RebateProductVo> productVos, List<RebateExpressionVo> expressionVos, List<RebateComputeParam> params) {
        if (CollectionUtil.listEmpty(cuss)) {
            cuss.add(new RebateAreaVo());
        }
        if (CollectionUtil.listEmpty(productVos)) {
            productVos.add(new RebateProductVo());
        }
        if (CollectionUtil.listEmpty(expressionVos)) {
            expressionVos.add(new RebateExpressionVo());
        }
        cuss.forEach(cus -> productVos.forEach(product -> expressionVos.forEach(express -> {
            RebateComputeParam param = new RebateComputeParam();
            param.setCusCode(cus.getCusCode());
            param.setRebateProductCode(product.getProductCode());
            param.setExpressionCode(express.getCode());
            param.setRebateCode(en.getCode());
            params.add(param);
        })));
    }

    private Map<String, List<RebateAreaVo>> buildCuss(Map<String, List<RebateAreaVo>> cusMap) {
        cusMap.forEach((k, v) -> {
            List cuss = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getOrgFlag())).collect(Collectors.toList());
            List<RebateAreaVo> cusOrgs = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(f.getOrgFlag())).collect(Collectors.toList());
            v.clear();
            v.addAll(cuss);
            v.addAll(this.buildCussByOrg(cusOrgs));
        });
        return cusMap;
    }

    private List<RebateAreaVo> buildCussByOrg(List<RebateAreaVo> cusOrgs) {
        ArrayList rebateAreaVos = Lists.newArrayList();
        cusOrgs.forEach(org -> {
            MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
            mdmCustomerMsgReqVo.setCustomerOrgCode(org.getOrgCode());
            List cusRel = (List)this.mdmCustomerMsgFeign.findCustomerSelectList(mdmCustomerMsgReqVo).getResult();
            this.buildCussByFeignRel(cusRel, rebateAreaVos);
        });
        return rebateAreaVos;
    }

    private void buildCussByFeignRel(List<MdmCustomerMsgSelectRespVo> cusRel, List<RebateAreaVo> rebateAreaVos) {
        if (CollectionUtil.listEmpty(cusRel)) {
            return;
        }
        cusRel.forEach(cus -> {
            RebateAreaVo vo = new RebateAreaVo();
            vo.setCusCode(cus.getCustomerCode());
            rebateAreaVos.add(vo);
        });
    }

    private Map<String, List<RebateProductVo>> buildRebateProducts(Map<String, List<RebateProductVo>> productMap) {
        productMap.forEach((k, v) -> {
            List productVos = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getProductLevelFlag()) && YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getAssessFlag())).collect(Collectors.toList());
            List<RebateProductVo> productLevelVos = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(f.getProductLevelFlag()) && YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getAssessFlag())).collect(Collectors.toList());
            v.clear();
            v.addAll(productVos);
            v.addAll(this.buildProductsByLevel(productLevelVos));
        });
        return productMap;
    }

    private List<RebateProductVo> buildProductsByLevel(List<RebateProductVo> productLevelVos) {
        ArrayList vos = Lists.newArrayList();
        productLevelVos.forEach(level -> {
            MdmProductReqVo mdmProductReqVo = new MdmProductReqVo();
            mdmProductReqVo.setProductLevelCode(level.getProductLevelCode());
            List mdmProductRespVos = (List)this.mdmProductFeign.listCondition(mdmProductReqVo).getResult();
            this.buildProductsByFeignRel(mdmProductRespVos, vos);
        });
        return vos;
    }

    private void buildProductsByFeignRel(List<MdmProductRespVo> mdmProductRespVos, List<RebateProductVo> vos) {
        if (CollectionUtil.listEmpty(mdmProductRespVos)) {
            return;
        }
        mdmProductRespVos.forEach(product -> {
            RebateProductVo productVo = new RebateProductVo();
            productVo.setProductCode(product.getProductCode());
            vos.add(productVo);
        });
    }
}

