/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RebateAreaUtil {
    public static void checkParam(List<RebateAreaVo> rebateAreaVos) {
        List<String> organizations = rebateAreaVos.stream().filter(rebateAreaVo -> {
            if (rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateAreaVo.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && !StringUtils.isEmpty((String)rebateAreaVo.getOrgCode()) && !StringUtils.isEmpty((String)rebateAreaVo.getOrgName())) {
                return true;
            }
            throw new BusinessException("\u7ec4\u7ec7\u540d\u548c\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }).map(rebateAreaVo -> rebateAreaVo.getOrgCode()).collect(Collectors.toList());
        RebateAreaUtil.validateRepetition(organizations);
        List<String> nonOrganizations = rebateAreaVos.stream().filter(rebateAreaVo -> {
            if (rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateAreaVo.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && !StringUtils.isEmpty((String)rebateAreaVo.getOrgCode()) && !StringUtils.isEmpty((String)rebateAreaVo.getOrgName())) {
                return true;
            }
            throw new BusinessException("\u7ec4\u7ec7\u540d\u548c\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }).map(rebateAreaVo -> rebateAreaVo.getOrgCode()).collect(Collectors.toList());
        RebateAreaUtil.validateRepetition(nonOrganizations);
        List<String> customers = rebateAreaVos.stream().filter(rebateAreaVo -> {
            if (rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateAreaVo.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && !StringUtils.isEmpty((String)rebateAreaVo.getCusCode()) && !StringUtils.isEmpty((String)rebateAreaVo.getCusName())) {
                return true;
            }
            throw new BusinessException("\u5ba2\u6237\u540d\u548c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }).map(rebateAreaVo -> rebateAreaVo.getCusCode()).collect(Collectors.toList());
        RebateAreaUtil.validateRepetition(customers);
        List<String> nonCustomers = rebateAreaVos.stream().filter(rebateAreaVo -> {
            if (rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateAreaVo.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && !StringUtils.isEmpty((String)rebateAreaVo.getCusCode()) && !StringUtils.isEmpty((String)rebateAreaVo.getCusName())) {
                return true;
            }
            throw new BusinessException("\u5ba2\u6237\u540d\u548c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }).map(rebateAreaVo -> rebateAreaVo.getCusCode()).collect(Collectors.toList());
        RebateAreaUtil.validateRepetition(nonCustomers);
    }

    public static void validateRepetition(List<String> codes) {
        ArrayList<String> tempList = new ArrayList<String>();
        for (int i = 0; i < codes.size(); ++i) {
            String code = codes.get(i);
            if (tempList.contains(code)) {
                throw new BusinessException("\u7f16\u7801\u4e3a" + code + "\u7684\u533a\u57df\u91cd\u590d\uff01");
            }
            tempList.add(code);
        }
    }

    public static void assembleMap(Map<String, Map<String, List<RebateAreaVo>>> result, List<String> rebateCodes, List<RebateAreaVo> rebateAreaVos) {
        rebateCodes.stream().forEach(rebateCode -> {
            HashMap areaResult = new HashMap();
            List organizations = rebateAreaVos.stream().filter(rebateAreaEntity -> rebateAreaEntity.getRebateCode().equals(rebateCode) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
            List nonOrganizations = rebateAreaVos.stream().filter(rebateAreaEntity -> rebateAreaEntity.getRebateCode().equals(rebateCode) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
            List customers = rebateAreaVos.stream().filter(rebateAreaEntity -> rebateAreaEntity.getRebateCode().equals(rebateCode) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
            List nonCustomers = rebateAreaVos.stream().filter(rebateAreaEntity -> rebateAreaEntity.getRebateCode().equals(rebateCode) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
            areaResult.put("containOrg", organizations);
            areaResult.put("nonContainOrg", nonOrganizations);
            areaResult.put("containCus", customers);
            areaResult.put("nonContainCus", nonCustomers);
            result.put((String)rebateCode, areaResult);
        });
    }
}

