/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.nebular.rebate.product.RebateProductVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class RebateUtil {
    public static void validateForAddOrEdit(RebateVo rebateVo) {
        RebateUtil.validate(rebateVo.getName(), "\u8fd4\u5229\u653f\u7b56\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RebateUtil.validate(rebateVo.getCode(), "\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RebateUtil.validate(rebateVo.getRebateType(), "\u8fd4\u5229\u653f\u7b56\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    public static void validate(Object obj, String errMsg) {
        if (obj == null || obj.toString().equals("")) {
            throw new BusinessException(errMsg);
        }
    }

    public static List<RebateProductVo> assembleProductList(RebateVo rebateVo) {
        List assessProductList = rebateVo.getAssessProductList();
        List rebateProductList = rebateVo.getRebateProductList();
        ArrayList<RebateProductVo> productList = new ArrayList<RebateProductVo>();
        productList.addAll(assessProductList);
        productList.addAll(rebateProductList);
        return productList;
    }

    public static void disAssembleProductList(RebateVo rebateVo, Map<String, List<RebateProductVo>> productMap) {
        List<RebateProductVo> productVos = productMap.get(rebateVo.getCode());
        List<Object> assessProductVos = new ArrayList();
        List<Object> rebateProductVos = new ArrayList();
        if (CollectionUtils.isEmpty(productVos)) {
            rebateVo.setRebateProductList(rebateProductVos);
            rebateVo.setAssessProductList(assessProductVos);
            return;
        }
        assessProductVos = productVos.stream().filter(rebateProductVo -> rebateProductVo.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
        rebateVo.setAssessProductList(assessProductVos);
        rebateProductVos = productVos.stream().filter(rebateProductVo -> rebateProductVo.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
        rebateVo.setRebateProductList(rebateProductVos);
    }

    public static List<RebateAreaVo> assembleAreaList(RebateVo rebateVo) {
        List nonCustomers = rebateVo.getNonCustomers();
        List customers = rebateVo.getCustomers();
        List nonOrganizations = rebateVo.getNonOrganizations();
        List organizations = rebateVo.getOrganizations();
        ArrayList<RebateAreaVo> rebateAreaVos = new ArrayList<RebateAreaVo>();
        rebateAreaVos.addAll(nonCustomers);
        rebateAreaVos.addAll(customers);
        rebateAreaVos.addAll(nonOrganizations);
        rebateAreaVos.addAll(organizations);
        return rebateAreaVos;
    }

    public static void disAssembleAreaList(RebateVo rebateVo, Map<String, Map<String, List<RebateAreaVo>>> areaMap) {
        Map<String, List<RebateAreaVo>> stringListMap = areaMap.get(rebateVo.getCode());
        rebateVo.setOrganizations(stringListMap.get("containOrg"));
        rebateVo.setNonOrganizations(stringListMap.get("nonContainOrg"));
        rebateVo.setCustomers(stringListMap.get("containCus"));
        rebateVo.setNonCustomers(stringListMap.get("nonContainCus"));
    }
}

