/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.variable.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.variable.RebateVariableVo;
import com.biz.crm.rebate.entity.RebateEntity;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.variable.entity.RebateVariableEntity;
import com.biz.crm.variable.entity.ValidBeanTest;
import com.biz.crm.variable.mapper.RebateVariableMapper;
import com.biz.crm.variable.service.RebateVariableService;
import com.biz.crm.variable.utils.BeanUtil;
import com.biz.crm.variable.utils.RebateVariableUtil;
import com.biz.crm.variable.utils.VariableBasic;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"rebateVariableServiceExpandImpl"})
@Service(value="rebateVariableService")
public class RebateVariableServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateVariableMapper, RebateVariableEntity>
implements RebateVariableService {
    private static final Logger log = LoggerFactory.getLogger(RebateVariableServiceImpl.class);
    @Resource
    private RebateVariableMapper rebateVariableMapper;
    @Resource
    private ValidBeanTest validBeanTest;

    @Override
    public RebateVariableVo validateBean(String beanName) {
        Object obj = BeanUtil.getBeanByName(beanName);
        if (!(obj instanceof VariableBasic)) {
            throw new BusinessException("\u8be5bean\u7684\u7236\u7c7b\u4e0d\u662fVariableBasic\uff01");
        }
        RebateVariableVo rebateVariableVo = new RebateVariableVo();
        rebateVariableVo.setBeanPath(obj.getClass().getName());
        return rebateVariableVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(RebateVariableVo rebateVariableVo) {
        RebateVariableUtil.validateForAddOrUpdate(rebateVariableVo);
        final String code = rebateVariableVo.getCode();
        List rebateVariableEntities = this.rebateVariableMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("code", code);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)rebateVariableEntities)) {
            throw new BusinessException("\u8fd4\u5229\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        this.validateBean(rebateVariableVo.getBeanName());
        RebateVariableEntity rebateVariableEntity = (RebateVariableEntity)((Object)CrmBeanUtil.copy((Object)rebateVariableVo, RebateVariableEntity.class));
        this.rebateVariableMapper.insert((Object)rebateVariableEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(RebateVariableVo rebateVariableVo) {
        RebateVariableUtil.validateForAddOrUpdate(rebateVariableVo);
        RebateVariableEntity rebateVariableEntity = (RebateVariableEntity)((Object)this.rebateVariableMapper.selectById((Serializable)((Object)rebateVariableVo.getId())));
        if (rebateVariableEntity == null) {
            throw new BusinessException("\u8981\u7f16\u8f91\u7684\u8fd4\u5229\u53d8\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5220\u9664\uff01");
        }
        this.validateBean(rebateVariableVo.getBeanName());
        BeanUtils.copyProperties((Object)rebateVariableVo, (Object)((Object)rebateVariableEntity));
        this.rebateVariableMapper.updateById((Object)rebateVariableEntity);
    }

    @Override
    public PageResult<RebateVariableVo> list(Integer pageNum, Integer pageSize) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)pageNum, (Integer)pageSize);
        List<RebateVariableVo> list = this.rebateVariableMapper.list((Page<RebateVariableVo>)page, (QueryWrapper<RebateVariableVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<RebateVariableVo> show() {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"show_flag", (Object)YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        queryWrapper.orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        List rebateVariableEntities = this.rebateVariableMapper.selectList((Wrapper)queryWrapper);
        List<RebateVariableVo> rebateVariableVos = rebateVariableEntities.stream().map(rebateVariableEntity -> (RebateVariableVo)CrmBeanUtil.copy((Object)rebateVariableEntity, RebateVariableVo.class)).collect(Collectors.toList());
        return rebateVariableVos;
    }

    @Override
    public RebateVariableVo findById(String id) {
        RebateVariableUtil.validate(id, "\u8981\u67e5\u770b\u7684\u8fd4\u5229\u53d8\u91cf\u7684id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RebateVariableEntity rebateVariableEntity = (RebateVariableEntity)((Object)this.rebateVariableMapper.selectById((Serializable)((Object)id)));
        RebateVariableVo rebateVariableVo = (RebateVariableVo)CrmBeanUtil.copy((Object)((Object)rebateVariableEntity), RebateVariableVo.class);
        return rebateVariableVo;
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8fd4\u5229\u53d8\u91cf\u8fdb\u884c\u5220\u9664\uff01");
        }
        this.rebateVariableMapper.deleteBatchIds(ids);
    }

    @Override
    public List<RebateVariableVo> findAll() {
        List entities = this.rebateVariableMapper.selectList((Wrapper)Wrappers.query());
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        List vos = CrmBeanUtil.copyList((List)entities, RebateVariableVo.class);
        return vos;
    }

    @Override
    @Transactional
    public void updateEffectiveFlag(ArrayList<String> ids, Integer code) {
        RebateVariableUtil.validate(ids, "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8981\u64cd\u4f5c\u7684\u8fd4\u5229\u53d8\u91cf\uff01");
        this.validateIds(ids);
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", ids);
        RebateVariableEntity entity = new RebateVariableEntity();
        entity.setEffectiveFlag(code);
        this.rebateVariableMapper.update((Object)entity, (Wrapper)wrapper);
    }

    private void validateIds(ArrayList<String> ids) {
        String prefixMessage = "\u8981\u64cd\u4f5c\u7684\u8fd4\u5229\u53d8\u91cf";
        String suffixMessage = "\u7684\u539f\u59cb\u6570\u636e\u4e0d\u5b58\u5728\uff01";
        ids.stream().forEach(id -> {
            RebateVariableEntity rebateVariableEntity = (RebateVariableEntity)((Object)((Object)this.rebateVariableMapper.selectById((Serializable)((Object)id))));
            RebateVariableUtil.validate((Object)rebateVariableEntity, prefixMessage + id + suffixMessage);
        });
    }

    @Override
    public Map<String, BigDecimal> getValueByVariable(String number, RebateEntity rebateEntity, List<RebateVariableEntity> rebateVariableEntities, String time) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(rebateVariableEntities.size());
        rebateVariableEntities.stream().forEach(rebateVariableEntity -> {
            VariableBasic variableBasic = (VariableBasic)BeanUtil.getBeanByName(rebateVariableEntity.getBeanName());
            BigDecimal value = variableBasic.getValue(time, rebateEntity, (RebateVariableEntity)((Object)rebateVariableEntity));
            map.put(rebateVariableEntity.getCode(), value);
        });
        return map;
    }
}

