/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.dms.rebatefeepool.RebateFeePoolFeign;
import com.biz.crm.dms.repfeepool.RepFeePoolFeign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolVo;
import com.biz.crm.nebular.rebate.rebatedetail.RebateDetailAdjustLogVo;
import com.biz.crm.nebular.rebate.rebatedetail.RebateDetailVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.rebate.entity.RebateDetailEntity;
import com.biz.crm.rebate.enums.RebateDetailStateEnum;
import com.biz.crm.rebate.enums.RebateTypeEnum;
import com.biz.crm.rebate.mapper.RebateDetailMapper;
import com.biz.crm.rebate.service.RebateDetailAdjustLogService;
import com.biz.crm.rebate.service.RebateDetailService;
import com.biz.crm.rebate.service.RebateService;
import com.biz.crm.rebate.util.CommonFieldUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateDetailService")
@ConditionalOnMissingBean(name={"rebateDetailServiceImpl"})
public class RebateDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateDetailMapper, RebateDetailEntity>
implements RebateDetailService {
    @Resource
    private RebateDetailMapper rebateDetailMapper;
    @Resource
    private RebateDetailAdjustLogService rebateDetailAdjustLogService;
    @Resource
    private RebateService rebateService;
    @Resource
    private RebateFeePoolFeign rebateFeePoolFeign;
    @Resource
    private RepFeePoolFeign repFeePoolFeign;

    @Override
    @Transactional
    public List<RebateDetailVo> addBatch(List<RebateDetailVo> vos) {
        this.validateAddBatch(vos);
        CommonFieldUtil.initCreateFields(vos);
        vos.forEach(vo -> vo.setCode(CodeUtil.generateCode()));
        List entities = CrmBeanUtil.copyList(vos, RebateDetailEntity.class);
        this.saveBatch(entities);
        return CrmBeanUtil.copyList((List)entities, RebateDetailVo.class);
    }

    @Override
    @Transactional
    public RebateDetailVo adjust(RebateDetailAdjustLogVo logVo) {
        this.validateAdjust(logVo);
        RebateDetailEntity entity = (RebateDetailEntity)((Object)this.rebateDetailMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"code", (Object)logVo.getRebateDetailCode())));
        entity.setAdjustAmount(entity.getAdjustAmount().add(logVo.getAdjustAmount()));
        entity.setActualAmount(entity.getComputeAmount().add(entity.getAdjustAmount()));
        ValidateUtils.validate((Object)(entity.getActualAmount().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0), (String)"\u8c03\u6574\u540e\u7684\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
        CommonFieldUtil.initUpdateFields((Object)entity);
        this.updateById((Object)entity);
        this.rebateDetailAdjustLogService.add(logVo, logVo.getRebateDetailCode());
        return (RebateDetailVo)CrmBeanUtil.copy((Object)((Object)entity), RebateDetailVo.class);
    }

    @Override
    public PageResult<RebateDetailVo> list(RebateDetailVo rebateDetailVo) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq(rebateDetailVo.getOnAccountState() != null, (Object)"on_account_state", (Object)rebateDetailVo.getOnAccountState());
        queryWrapper.like(!StringUtils.isEmpty((String)rebateDetailVo.getCode()), (Object)"code", (Object)rebateDetailVo.getCode());
        queryWrapper.like(!StringUtils.isEmpty((String)rebateDetailVo.getName()), (Object)"name", (Object)rebateDetailVo.getName());
        queryWrapper.eq(!StringUtils.isEmpty((String)rebateDetailVo.getComputeYearMonth()), (Object)"compute_year_month", (Object)rebateDetailVo.getComputeYearMonth());
        queryWrapper.eq(rebateDetailVo.getIsTest() != null, (Object)"is_test", (Object)rebateDetailVo.getIsTest());
        Page page = PageUtil.buildPage((Integer)rebateDetailVo.getPageNum(), (Integer)rebateDetailVo.getPageSize());
        List<RebateDetailVo> list = this.rebateDetailMapper.list((Page<RebateDetailVo>)page, (QueryWrapper<RebateDetailVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void invalid(List<String> ids) {
        ValidateUtils.notEmpty(ids, (String)"\u6279\u91cf\u4f5c\u5e9f\u8fd4\u5229\u660e\u7ec6\u65f6\uff0cid\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        UpdateWrapper wrapper = Wrappers.update();
        wrapper.in((Object)"id", ids);
        wrapper.set((Object)"on_account_state", (Object)RebateDetailStateEnum.DISABLED.getCode());
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void onAccount(String detailCode) {
        ValidateUtils.validate((Object)detailCode, (String)"\u4e0a\u8d26\u65f6\uff0c\u8fd4\u5229\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        RebateDetailEntity detailEntity = (RebateDetailEntity)((Object)this.rebateDetailMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"code", (Object)detailCode)));
        ValidateUtils.validate((Object)((Object)detailEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8fd4\u5229\u660e\u7ec6\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u7684\u660e\u7ec6\u7f16\u7801\u662f\u5426\u6b63\u786e");
        RebateVo rebateVo = this.rebateService.findByCode(detailEntity.getRebateCode());
        ValidateUtils.validate((Object)rebateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8fd4\u5229\u653f\u7b56\u8bb0\u5f55");
        if (RebateTypeEnum.REBATE_ON_ACCOUNT.getCode().equals(rebateVo.getRebateType())) {
            this.rebateOnAccount(detailEntity);
        } else if (RebateTypeEnum.REP_ON_ACCOUNT.getCode().equals(rebateVo.getRebateType())) {
            this.repOnAccount(detailEntity);
        } else {
            throw new BusinessException("\u8fd4\u5229\u653f\u7b56\u3010%s(%s)\u3011\u6ca1\u6709\u7ef4\u62a4\u6b63\u786e\u7684\u4e0a\u8d26\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e0a\u8d26\uff0c\u8bf7\u5148\u7ef4\u62a4\u5176\u4e0a\u8d26\u7c7b\u578b\uff0c\u518d\u6765\u505a\u4e0a\u8d26\u64cd\u4f5c", new String[]{rebateVo.getName(), rebateVo.getCode()});
        }
    }

    @Override
    public void deleteByRebateCodeAndTest(String rebateCode, Integer isTest, String speedNo) {
        ValidateUtils.validate((Object)rebateCode, (String)"\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(isTest) || YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(isTest) ? 1 : 0) != 0, (String)"\u6d4b\u8bd5\u72b6\u6001\u53ea\u80fd\u4f20\u662f\uff081\uff09\uff0c\u5426\uff080\uff09", (Object[])new Object[0]);
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"rebate_code", (Object)rebateCode)).eq((Object)"is_test", (Object)isTest)).notIn(StringUtils.isNotEmpty((String)speedNo), (Object)"speed_no", new Object[]{speedNo});
        this.rebateDetailMapper.delete((Wrapper)wrapper);
    }

    private void repOnAccount(RebateDetailEntity detailEntity) {
        RepFeePoolVo feePoolVo = new RepFeePoolVo();
        RepFeePoolItemVo itemVo = new RepFeePoolItemVo();
        feePoolVo.setCusCode(detailEntity.getCusCode());
        feePoolVo.setCusName(detailEntity.getCusName());
        feePoolVo.setCusOrgCode(detailEntity.getCusOrgCode());
        feePoolVo.setCusOrgName(detailEntity.getCusOrgName());
        feePoolVo.setSaleCompanyCode(detailEntity.getCusOrgCode());
        feePoolVo.setSaleCompanyName(detailEntity.getCusOrgName());
        itemVo.setOnAccountCount(detailEntity.getActualAmount());
    }

    private void rebateOnAccount(RebateDetailEntity detailEntity) {
        RebateFeePoolVo feePoolVo = new RebateFeePoolVo();
        feePoolVo.setCusCode(detailEntity.getCusCode());
        feePoolVo.setCusName(detailEntity.getCusName());
        feePoolVo.setCusChannelCode(detailEntity.getCusChannelCode());
        feePoolVo.setCusChannelName(detailEntity.getCusChannelName());
        feePoolVo.setSaleCompanyCode(detailEntity.getCusOrgCode());
        feePoolVo.setSaleCompanyName(detailEntity.getCusOrgName());
        feePoolVo.setCusOrgCode(detailEntity.getCusOrgCode());
        feePoolVo.setCusOrgName(detailEntity.getCusOrgName());
        feePoolVo.setTotalFee(detailEntity.getActualAmount());
        feePoolVo.setRemarks("\u8fd4\u5229\u4e0a\u8d26");
        this.rebateFeePoolFeign.onAccount(feePoolVo);
    }

    private void validateAdjust(RebateDetailAdjustLogVo logVo) {
        ValidateUtils.validate((Object)logVo, (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)logVo.getRebateDetailCode(), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)logVo.getAdjustAmount(), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)(logVo.getAdjustAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u91cf\u5fc5\u987b\u5927\u4e8e0");
    }

    private void validateAddBatch(List<RebateDetailVo> vos) {
        ValidateUtils.notEmpty(vos, (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u8fd4\u5229\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        for (int i = 0; i < vos.size(); ++i) {
            RebateDetailVo vo = vos.get(0);
            ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getCusName(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getName(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u8fd4\u5229\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[]{i});
        }
    }
}

