/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.rebate.expression.RebateExpressionVo;
import com.biz.crm.nebular.rebate.variable.RebateVariableVo;
import com.biz.crm.rebate.entity.RebateExpressionEntity;
import com.biz.crm.rebate.mapper.RebateExpressionMapper;
import com.biz.crm.rebate.service.RebateExpressionService;
import com.biz.crm.rebate.util.CommonFieldUtil;
import com.biz.crm.rebate.util.MathUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.variable.service.RebateVariableService;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="rebateExpressionService")
@ConditionalOnMissingBean(name={"rebateExpressionServiceImpl"})
public class RebateExpressionServiceImpl<M extends BaseMapper<E>, E>
extends ServiceImpl<RebateExpressionMapper, RebateExpressionEntity>
implements RebateExpressionService {
    @Resource
    private RebateExpressionMapper rebateExpressionMapper;
    @Resource
    private RebateVariableService rebateVariableService;

    @Override
    @Transactional
    public void replace(List<RebateExpressionVo> vos, String rebateCode) {
        this.validateUpdateBatch(vos, rebateCode);
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"rebate_code", (Object)rebateCode);
        List dbEntities = this.rebateExpressionMapper.selectList((Wrapper)wrapper);
        List<RebateExpressionVo> createVos = vos.stream().filter(vo -> StringUtils.isEmpty((String)vo.getId())).collect(Collectors.toList());
        List<String> deleteIds = this.difference(CrmBeanUtil.copyList((List)dbEntities, RebateExpressionVo.class), vos);
        if (CollectionUtil.listNotEmpty(createVos)) {
            this.createBath(createVos, rebateCode);
        }
        if (CollectionUtil.listNotEmpty(deleteIds)) {
            this.deleteByIds(deleteIds);
        }
    }

    private List<String> difference(List<RebateExpressionVo> dbVos, List<RebateExpressionVo> vos) {
        Set<String> ids;
        Set<String> dbIds = dbVos.stream().collect(Collectors.groupingBy(UuidVo::getId)).keySet();
        Sets.SetView differenceIds = Sets.difference(dbIds, ids = vos.stream().filter(vo -> StringUtils.isNotEmpty((String)vo.getId())).collect(Collectors.groupingBy(UuidVo::getId)).keySet());
        if (!CollectionUtil.collectionNotEmpty((Collection)differenceIds)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)differenceIds);
    }

    @Override
    public <T> T validate(String expressStr, Class<T> cls) {
        ValidateUtils.validate((Object)expressStr, (String)"\u6821\u9a8c\u8868\u8fbe\u5f0f\u65f6\uff0c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate(cls, (String)"\u6821\u9a8c\u8868\u8fbe\u5f0f\u65f6\uff0c\u8fd4\u56de\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Pattern chinesePattern = Pattern.compile("[u4E00-u9FA5]+");
        Matcher chineseMatcher = chinesePattern.matcher(expressStr);
        ValidateUtils.validate((Object)(!chineseMatcher.find() ? 1 : 0), (String)"\u516c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u5b57\u7b26");
        Pattern pattern = Pattern.compile("\\d*[a-zA-Z]+\\d*");
        Matcher matcher = pattern.matcher(expressStr);
        ArrayList variables = Lists.newArrayList();
        while (matcher.find()) {
            variables.add(matcher.group());
        }
        List<RebateVariableVo> variableVos = this.rebateVariableService.findByCodes(variables);
        for (RebateVariableVo vo : variableVos) {
            expressStr = expressStr.replace(vo.getCode(), vo.getReplacementValue() == null ? "0" : vo.getReplacementValue().toString());
        }
        T computeResult = MathUtil.computeExpression(expressStr, cls);
        ValidateUtils.validate(computeResult, (String)"\u516c\u5f0f\u3010%s\u3011\u89e3\u6790\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8be5\u516c\u5f0f\u662f\u5426\u6b63\u786e", (Object[])new Object[]{expressStr});
        return computeResult;
    }

    @Override
    @Transactional
    public void createBath(List<RebateExpressionVo> vos, String rebateCode) {
        this.validateCreateBatch(vos);
        CommonFieldUtil.initCreateFields(vos);
        vos.forEach(vo -> {
            vo.setRebateCode(rebateCode);
            vo.setCode(CodeUtil.getCode());
        });
        List entities = CrmBeanUtil.copyList(vos, RebateExpressionEntity.class);
        this.saveBatch(entities);
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        ValidateUtils.notEmpty(ids, (String)"\u6279\u91cf\u5220\u9664\u516c\u5f0f\u65f6\uff0cid\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        this.removeByIds(ids);
    }

    @Override
    public List<RebateExpressionVo> findByRebateCode(String rebateCode) {
        if (StringUtils.isEmpty((String)rebateCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"rebate_code", (Object)rebateCode)).orderByAsc((Object)"create_date")).orderByAsc((Object)"create_date_second");
        List entities = this.rebateExpressionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList((List)entities, RebateExpressionVo.class);
    }

    @Override
    public Map<String, List<RebateExpressionVo>> listByRebateCodes(List<String> rebateCodes) {
        if (CollectionUtil.listEmpty(rebateCodes)) {
            return Maps.newHashMap();
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().in((Object)"rebate_code", rebateCodes);
        List entities = this.rebateExpressionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Maps.newHashMap();
        }
        List vos = CrmBeanUtil.copyList((List)entities, RebateExpressionVo.class);
        Map<String, List<RebateExpressionVo>> map = vos.stream().collect(Collectors.groupingBy(RebateExpressionVo::getRebateCode));
        return map;
    }

    @Override
    @Transactional
    public void deleteByRebateCode(String rebateCode) {
        ValidateUtils.validate((Object)rebateCode, (String)"\u6839\u636e\u8fd4\u5229\u653f\u7b56\u6279\u91cf\u5220\u9664\u516c\u5f0f\u65f6\uff0c\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"rebate_code", (Object)rebateCode);
        this.rebateExpressionMapper.delete((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void delByRebateCode(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            throw new BusinessException("\u6839\u636e\u8fd4\u5229\u653f\u7b56\u6279\u91cf\u5220\u9664\u516c\u5f0f\u65f6\uff0c\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.rebateExpressionMapper.delete((Wrapper)Wrappers.query().in((Object)"rebate_code", codes));
    }

    @Override
    public RebateExpressionVo findByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        RebateExpressionEntity entity = (RebateExpressionEntity)((Object)this.rebateExpressionMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"code", (Object)code)));
        return (RebateExpressionVo)CrmBeanUtil.copy((Object)((Object)entity), RebateExpressionVo.class);
    }

    private void validateCreateBatch(List<RebateExpressionVo> vos) {
        ValidateUtils.notEmpty(vos, (String)"\u6279\u91cf\u65b0\u589e\u516c\u5f0f\u65f6\uff0c\u516c\u5f0f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        for (int i = 0; i < vos.size(); ++i) {
            RebateExpressionVo vo = vos.get(i);
            ValidateUtils.validate((Object)vo.getRebateCode(), (String)"\u6279\u91cf\u65b0\u589e\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getConditionExpress(), (String)"\u6279\u91cf\u65b0\u589e\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u6761\u4ef6\u516c\u5f0f\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getComputeExpress(), (String)"\u6279\u91cf\u65b0\u589e\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u8ba1\u7b97\u516c\u5f0f\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.isTrue((boolean)StringUtils.isEmpty((String)vo.getId()), (String)"\u6279\u91cf\u65b0\u589e\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u5df2\u5b58\u5728", (Object[])new Object[]{i});
            this.validate(vo.getConditionExpress(), Boolean.class);
            this.validate(vo.getComputeExpress(), BigDecimal.class);
        }
    }

    private void validateUpdateBatch(List<RebateExpressionVo> vos, String rebateCode) {
        ValidateUtils.notEmpty(vos, (String)"\u6279\u91cf\u66f4\u65b0\u516c\u5f0f\u65f6\uff0c\u516c\u5f0f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        for (int i = 0; i < vos.size(); ++i) {
            RebateExpressionVo vo = vos.get(i);
            ValidateUtils.validate((Object)vo.getRebateCode(), (String)"\u6279\u91cf\u66f4\u65b0\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getConditionExpress(), (String)"\u6279\u91cf\u66f4\u65b0\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u6761\u4ef6\u516c\u5f0f\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getComputeExpress(), (String)"\u6279\u91cf\u66f4\u65b0\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u8ba1\u7b97\u516c\u5f0f\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)Objects.equals(vo.getRebateCode(), rebateCode), (String)"\u6279\u91cf\u66f4\u65b0\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u8fd4\u5229\u7f16\u7801\u3010%s\u3011\u4e0d\u6b63\u786e\uff0c\u5e94\u8be5\u4e3a\u3010%s\u3011", (Object[])new Object[]{i, vo.getRebateCode(), rebateCode});
        }
    }
}

