/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFieldUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonFieldUtil.class);

    public static void initCreateFields(Object vo) {
    }

    private static void setValue(Map<String, Object> attributes, Object vo) throws IllegalAccessException {
        List<Field> fields = CommonFieldUtil.getFields(vo.getClass());
        HashMap fieldMap = Maps.newHashMap();
        fields.forEach(f -> fieldMap.put(f.getName(), f));
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Field field = (Field)fieldMap.get(entry.getKey());
            if (field == null) continue;
            field.setAccessible(true);
            field.set(vo, entry.getValue());
        }
    }

    public static List<Field> getFields(Class c) {
        ArrayList fields = Lists.newArrayList();
        while (c != null) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
            c = c.getSuperclass();
        }
        return fields;
    }

    public static void initUpdateFields(Object vo) {
        if (vo instanceof Collection) {
            ((Collection)vo).forEach(v -> CommonFieldUtil.initUpdateFields(v));
        }
        if (vo == null || !(vo instanceof CrmBaseVo) && !(vo instanceof CrmBaseEntity)) {
            return;
        }
        try {
            String[] timeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).split(" ");
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            HashMap attributes = Maps.newHashMap();
            attributes.put("updateDate", timeStr[0]);
            attributes.put("updateDateSecond", timeStr[1]);
            attributes.put("updateCode", user.getCustcode());
            attributes.put("updateName", user.getCustname());
            attributes.put("updateOrgCode", user.getOrgcode());
            attributes.put("updateOrgName", user.getOrgname());
            attributes.put("updatePosCode", user.getPoscode());
            attributes.put("updatePosName", user.getPosname());
            CommonFieldUtil.setValue(attributes, vo);
        }
        catch (Exception e) {
            LOGGER.error("data:{}", vo);
            throw new BusinessException("\u5904\u7406\u516c\u5171\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
        }
    }

    public static Map<String, Object> fieldsValue(Object o, String ... fieldNames) {
        HashMap result = Maps.newHashMap();
        try {
            Class<?> c = o.getClass();
            for (String fieldName : fieldNames) {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                result.put(fieldName, field.get(o));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Maps.newHashMap();
        }
        return result;
    }

    public static String fieldHumpToLine(String sourceName) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(sourceName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String fieldLineToHump(String sourceName) {
        Pattern linePattern = Pattern.compile("_(\\w)");
        Matcher matcher = linePattern.matcher(sourceName.toLowerCase());
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void initDecimalZero(Object v) {
        Class<?> c = v.getClass();
        try {
            Field[] fields = c.getDeclaredFields();
            if (fields == null) {
                return;
            }
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.getType() != BigDecimal.class || field.get(v) != null) continue;
                field.set(v, BigDecimal.ZERO);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("data:{}", v);
            throw new BusinessException("\u5904\u7406\u7a7a\u6570\u5b57\u5b57\u6bb5\u5f02\u5e38", (Throwable)e);
        }
    }

    public static List<String> difference(Collection<Object> source, Collection<Object> target, String key) {
        ValidateUtils.validate(source, (String)"\u4f20\u5165\u6e90\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate(target, (String)"\u4f20\u5165\u76ee\u6807\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Set<String> sourceKeys = CommonFieldUtil.getKeyValues(source, key);
        Set<String> targetKeys = CommonFieldUtil.getKeyValues(target, key);
        Sets.SetView differenceIds = Sets.difference(sourceKeys, targetKeys);
        if (!CollectionUtil.collectionNotEmpty((Collection)differenceIds)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)differenceIds);
    }

    public static Set<String> getKeyValues(Collection<Object> collection, String key) {
        ValidateUtils.validate(collection, (String)"\u4f20\u5165\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet keys = Sets.newHashSet();
        for (Object s : collection) {
            Object value = FieldUtils.readDeclaredField((Object)s, (String)key, (boolean)true);
            keys.add(value.toString());
        }
        return keys.stream().filter(k -> Objects.nonNull(k)).collect(Collectors.toSet());
    }
}

