/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.variable.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.nebular.rebate.variable.RebateVariableVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.variable.entity.RebateVariableEntity;
import com.biz.crm.variable.mapper.RebateVariableMapper;
import com.biz.crm.variable.service.RebateVariableService;
import com.biz.crm.variable.utils.RebateVariableUtil;
import com.biz.crm.variable.utils.VariableBeanUtil;
import com.biz.crm.variable.variablebean.AbstractVariableBean;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"rebateVariableServiceExpandImpl"})
@Service(value="rebateVariableService")
public class RebateVariableServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateVariableMapper, RebateVariableEntity>
implements RebateVariableService {
    private static final Logger log = LoggerFactory.getLogger(RebateVariableServiceImpl.class);
    @Resource
    private RebateVariableMapper rebateVariableMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public RebateVariableVo getVariableBean(String beanName) {
        AbstractVariableBean obj = VariableBeanUtil.getBeanByName(beanName);
        RebateVariableVo rebateVariableVo = new RebateVariableVo();
        rebateVariableVo.setBeanPath(obj.getClass().getName());
        return rebateVariableVo;
    }

    @Override
    @Transactional
    public void add(RebateVariableVo rebateVariableVo) {
        RebateVariableUtil.validateForAddOrUpdate(rebateVariableVo);
        final String code = rebateVariableVo.getCode();
        List rebateVariableEntities = this.rebateVariableMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("code", code);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)rebateVariableEntities)) {
            throw new BusinessException("\u8fd4\u5229\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        rebateVariableVo.setBeanPath(this.getVariableBean(rebateVariableVo.getBeanName()).getBeanPath());
        this.rebateVariableMapper.insert(CrmBeanUtil.copy((Object)rebateVariableVo, RebateVariableEntity.class));
        this.crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj((String)"menuCode").toString(), rebateVariableVo.getId(), null, (Object)rebateVariableVo);
    }

    @Override
    @Transactional
    public void update(RebateVariableVo rebateVariableVo) {
        RebateVariableUtil.validateForAddOrUpdate(rebateVariableVo);
        RebateVariableEntity rebateVariableEntity = (RebateVariableEntity)((Object)this.rebateVariableMapper.selectById((Serializable)((Object)rebateVariableVo.getId())));
        if (rebateVariableEntity == null) {
            throw new BusinessException("\u8981\u7f16\u8f91\u7684\u8fd4\u5229\u53d8\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5220\u9664\uff01");
        }
        rebateVariableVo.setBeanPath(this.getVariableBean(rebateVariableVo.getBeanName()).getBeanPath());
        BeanUtils.copyProperties((Object)rebateVariableVo, (Object)((Object)rebateVariableEntity));
        RebateVariableVo rebateVariableold = this.findById(rebateVariableVo.getId());
        RebateVariableVo oldObject = (RebateVariableVo)CrmBeanUtil.copy((Object)rebateVariableold, RebateVariableVo.class);
        this.rebateVariableMapper.updateById((Object)rebateVariableEntity);
        RebateVariableVo rebateVariablenew = this.findById(rebateVariableVo.getId());
        RebateVariableVo newObject = (RebateVariableVo)CrmBeanUtil.copy((Object)rebateVariablenew, RebateVariableVo.class);
        this.crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj((String)"menuCode").toString(), rebateVariableVo.getId(), null, (Object)oldObject, (Object)newObject);
    }

    @Override
    public PageResult<RebateVariableVo> list(Integer pageNum, Integer pageSize) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)pageNum, (Integer)pageSize);
        List<RebateVariableVo> list = this.rebateVariableMapper.list((Page<RebateVariableVo>)page, (QueryWrapper<RebateVariableVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<RebateVariableVo> show() {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"effective_flag", (Object)YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        queryWrapper.orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        List rebateVariableEntities = this.rebateVariableMapper.selectList((Wrapper)queryWrapper);
        return CrmBeanUtil.copyList((List)rebateVariableEntities, RebateVariableVo.class);
    }

    @Override
    public RebateVariableVo findById(String id) {
        RebateVariableUtil.validate(id, "\u8981\u67e5\u770b\u7684\u8fd4\u5229\u53d8\u91cf\u7684id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RebateVariableEntity rebateVariableEntity = (RebateVariableEntity)((Object)this.rebateVariableMapper.selectById((Serializable)((Object)id)));
        return (RebateVariableVo)CrmBeanUtil.copy((Object)((Object)rebateVariableEntity), RebateVariableVo.class);
    }

    @Override
    public List<RebateVariableVo> findByIds(ArrayList ids) {
        RebateVariableUtil.validate(ids, "\u8981\u67e5\u770b\u7684\u8fd4\u5229\u53d8\u91cf\u7684id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", (Collection)ids);
        List rebateVariableEntities = this.rebateVariableMapper.selectList((Wrapper)wrapper);
        List list = CrmBeanUtil.copyList((List)rebateVariableEntities, RebateVariableVo.class);
        return null;
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8981\u5220\u9664\u7684\u8fd4\u5229\u53d8\u91cf\uff01");
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", ids);
        List rebateVariableEntities = this.rebateVariableMapper.selectList((Wrapper)wrapper);
        for (RebateVariableEntity entity : rebateVariableEntities) {
            RebateVariableVo rebateVariableVo = (RebateVariableVo)CrmBeanUtil.copy((Object)((Object)entity), RebateVariableVo.class);
            this.crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj((String)"menuCode").toString(), rebateVariableVo.getId(), null, (Object)rebateVariableVo);
        }
        this.rebateVariableMapper.deleteBatchIds(ids);
    }

    @Override
    public List<RebateVariableVo> findAll() {
        List entities = this.rebateVariableMapper.selectList((Wrapper)Wrappers.query());
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        List vos = CrmBeanUtil.copyList((List)entities, RebateVariableVo.class);
        return vos;
    }

    @Override
    public List<RebateVariableVo> listByCode(List<String> codes) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"code", codes);
        List rebateVariableEntities = this.rebateVariableMapper.selectList((Wrapper)queryWrapper);
        return CrmBeanUtil.copyList((List)rebateVariableEntities, RebateVariableVo.class);
    }

    @Override
    @Transactional
    public void updateEffectiveFlag(ArrayList<String> ids, Integer code) {
        RebateVariableUtil.validate(ids, "\u8bf7\u6307\u5b9a\u8981\u4fee\u6539\u7684\u8fd4\u5229\u53d8\u91cf\uff01");
        List rebateVariableEntities = this.rebateVariableMapper.selectBatchIds(ids);
        List exitsIds = rebateVariableEntities.stream().map(rebateVariableEntity -> rebateVariableEntity.getId()).collect(Collectors.toList());
        if (exitsIds.size() < ids.size()) {
            throw new BusinessException("\u90e8\u5206\u8fd4\u5229\u53d8\u91cf\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", ids);
        RebateVariableEntity entity = new RebateVariableEntity();
        entity.setEffectiveFlag(code);
        this.rebateVariableMapper.update((Object)entity, (Wrapper)wrapper);
    }

    @Override
    public Map<String, BigDecimal> getValueByVariable(String cusCode, String number, RebateVo rebateVo, List<RebateVariableVo> rebateVariableVos, String time) {
        String key = rebateVo.getId() + number;
        Map map = this.redisTemplate.opsForHash().entries((Object)key);
        if (!MapUtils.isEmpty((Map)map)) {
            return map;
        }
        HashMap<String, BigDecimal> nMap = new HashMap<String, BigDecimal>();
        rebateVariableVos.forEach(rebateVariableVo -> {
            BigDecimal cfr_ignored_0 = nMap.put(rebateVariableVo.getCode(), null);
        });
        rebateVariableVos.forEach(rebateVariableVo -> {
            AbstractVariableBean variableBasic = VariableBeanUtil.getBeanByName(rebateVariableVo.getBeanName());
            BigDecimal value = variableBasic.getValue(cusCode, time, rebateVo, (RebateVariableVo)rebateVariableVo);
            nMap.put(rebateVariableVo.getCode(), value);
        });
        this.redisTemplate.opsForHash().putAll((Object)key, nMap);
        this.redisTemplate.expire((Object)key, 1800L, TimeUnit.SECONDS);
        return nMap;
    }

    @Override
    public List<RebateVariableVo> findByCodes(List<String> codes) {
        if (CollectionUtil.listEmpty(codes)) {
            return Lists.newArrayList();
        }
        List entities = this.rebateVariableMapper.selectList((Wrapper)Wrappers.query().in((Object)"code", codes));
        return CrmBeanUtil.copyList((List)entities, RebateVariableVo.class);
    }
}

