/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.rebatedetail.RebateComputeLogVo;
import com.biz.crm.rebate.entity.RebateComputeLogEntity;
import com.biz.crm.rebate.mapper.RebateComputeLogMapper;
import com.biz.crm.rebate.service.RebateComputeLogService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"rebateComputeLogServiceExpandImpl"})
@Service(value="rebateComputeLogService")
public class RebateComputeLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateComputeLogMapper, RebateComputeLogEntity>
implements RebateComputeLogService {
    @Resource
    private RebateComputeLogMapper rebateComputeLogMapper;

    @Override
    public List<RebateComputeLogVo> findByCode(String rebateCode, String detailCode) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq(StringUtils.isNotEmpty((String)rebateCode), (Object)"rebate_code", (Object)rebateCode);
        queryWrapper.eq(StringUtils.isNotEmpty((String)detailCode), (Object)"detail_code", (Object)detailCode);
        List rebateComputeLogEntities = this.rebateComputeLogMapper.selectList((Wrapper)queryWrapper);
        return CrmBeanUtil.copyList((List)rebateComputeLogEntities, RebateComputeLogVo.class);
    }

    @Override
    @Transactional
    public RebateComputeLogVo add(RebateComputeLogVo vo, String detailCode) {
        this.validateAdd(vo);
        vo.setCode(CodeUtil.generateCode());
        vo.setDetailCode(detailCode);
        RebateComputeLogEntity entity = (RebateComputeLogEntity)((Object)CrmBeanUtil.copy((Object)vo, RebateComputeLogEntity.class));
        this.save((Object)entity);
        return (RebateComputeLogVo)CrmBeanUtil.copy((Object)((Object)entity), RebateComputeLogVo.class);
    }

    @Override
    public PageResult<RebateComputeLogVo> listByConditions(RebateComputeLogVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RebateComputeLogVo> pageResult = this.rebateComputeLogMapper.listByConditions((Page<RebateComputeLogVo>)page, param);
        return PageResult.builder().data(pageResult).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void deleteByRebateCodeAndTest(String rebateCode, Integer isTest, String speedNo) {
        ValidateUtils.validate((Object)rebateCode, (String)"\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(isTest) || YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(isTest) ? 1 : 0) != 0, (String)"\u6d4b\u8bd5\u72b6\u6001\u53ea\u80fd\u4f20\u662f\uff081\uff09\uff0c\u5426\uff080\uff09", (Object[])new Object[0]);
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"rebate_code", (Object)rebateCode)).eq((Object)"is_test", (Object)isTest)).notIn(StringUtils.isNotEmpty((String)speedNo), (Object)"speed_no", new Object[]{speedNo});
        this.rebateComputeLogMapper.delete((Wrapper)wrapper);
    }

    private void validateAdd(RebateComputeLogVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u65b0\u589e\u8ba1\u7b97\u65e5\u5fd7\u65f6\uff0c\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getRebateCode(), (String)"\u65b0\u589e\u8ba1\u7b97\u65e5\u5fd7\u65f6\uff0c\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u65b0\u589e\u8ba1\u7b97\u65e5\u5fd7\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getComputeTime(), (String)"\u65b0\u589e\u8ba1\u7b97\u65e5\u5fd7\u65f6\uff0c\u8ba1\u7b97\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

