/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.nebular.rebate.expression.RebateExpressionVo;
import com.biz.crm.nebular.rebate.product.RebateProductVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.rebate.entity.RebateEntity;
import com.biz.crm.rebate.mapper.RebateMapper;
import com.biz.crm.rebate.service.RebateAreaService;
import com.biz.crm.rebate.service.RebateExpressionService;
import com.biz.crm.rebate.service.RebateProductService;
import com.biz.crm.rebate.service.RebateService;
import com.biz.crm.rebate.util.RebateUtil;
import com.biz.crm.rebate.util.external.RebateValidator;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.variable.utils.RebateVariableUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"rebateServiceExpandImpl"})
@Service(value="rebateService")
public class RebateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateMapper, RebateEntity>
implements RebateService {
    @Resource
    private RebateMapper rebateMapper;
    @Resource
    private RebateAreaService rebateAreaService;
    @Resource
    private RebateProductService rebateProductService;
    @Resource
    private RebateExpressionService rebateExpressionService;
    @Autowired(required=false)
    private List<RebateValidator> rebateValidators;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @Transactional
    public void add(RebateVo rebateVo) {
        RebateUtil.validateForAddOrEdit(rebateVo);
        if (CollectionUtil.listNotEmpty(this.rebateValidators)) {
            this.rebateValidators.forEach(validate -> validate.validateAdd(rebateVo));
        }
        final String code = rebateVo.getCode();
        List rebateEntities = this.rebateMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("code", code);
            }
        });
        ValidateUtils.isTrue((boolean)CollectionUtil.listEmpty((List)rebateEntities), (String)"\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
        RebateEntity rebateEntity = (RebateEntity)((Object)CrmBeanUtil.copy((Object)rebateVo, RebateEntity.class));
        this.rebateMapper.insert((Object)rebateEntity);
        List<RebateProductVo> rebateProductVoList = RebateUtil.assembleProductList(rebateVo);
        this.rebateProductService.replace(rebateProductVoList, code);
        List<RebateAreaVo> rebateAreaVoList = RebateUtil.assembleAreaList(rebateVo);
        this.rebateAreaService.replace(rebateAreaVoList, code);
        this.rebateExpressionService.replace(rebateVo.getRebateExpressionVos(), code);
        this.crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj((String)"menuCode").toString(), rebateVo.getId(), null, (Object)rebateVo);
    }

    @Override
    @Transactional
    public void update(RebateVo rebateVo) {
        RebateEntity rebateEntity;
        RebateUtil.validateForAddOrEdit(rebateVo);
        if (CollectionUtil.listNotEmpty(this.rebateValidators)) {
            this.rebateValidators.forEach(validate -> validate.validateUpdate(rebateVo));
        }
        if ((rebateEntity = (RebateEntity)((Object)this.rebateMapper.selectById((Serializable)((Object)rebateVo.getId())))) == null) {
            throw new BusinessException("\u8981\u4fee\u6539\u7684\u8fd4\u5229\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01");
        }
        rebateEntity = (RebateEntity)((Object)CrmBeanUtil.copy((Object)rebateVo, RebateEntity.class));
        RebateEntity byIdold = (RebateEntity)((Object)this.getById((Serializable)((Object)rebateVo.getId())));
        RebateVo oldObject = (RebateVo)CrmBeanUtil.copy((Object)((Object)byIdold), RebateVo.class);
        this.rebateMapper.updateById((Object)rebateEntity);
        RebateVo newObject = this.findDetailsById(rebateVo.getId());
        this.crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj((String)"menuCode").toString(), rebateVo.getId(), null, (Object)oldObject, (Object)newObject);
        List<RebateProductVo> rebateProductVoList = RebateUtil.assembleProductList(rebateVo);
        this.rebateProductService.replace(rebateProductVoList, rebateEntity.getCode());
        List<RebateAreaVo> rebateAreaVoList = RebateUtil.assembleAreaList(rebateVo);
        this.rebateAreaService.replace(rebateAreaVoList, rebateEntity.getCode());
        this.rebateExpressionService.replace(rebateVo.getRebateExpressionVos(), rebateEntity.getCode());
    }

    @Override
    public RebateVo findDetailsById(String id) {
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u8f93\u5165\u8981\u67e5\u8be2\u7684\u8fd4\u5229\u653f\u7b56\u7684id\uff01");
        RebateEntity rebateEntity = (RebateEntity)((Object)this.rebateMapper.selectById((Serializable)((Object)id)));
        if (rebateEntity == null) {
            throw new BusinessException("\u8981\u67e5\u770b\u7684\u8fd4\u5229\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        RebateVo rebateVo = (RebateVo)CrmBeanUtil.copy((Object)((Object)rebateEntity), RebateVo.class);
        final String code = rebateVo.getCode();
        Map<String, List<RebateProductVo>> productMap = this.rebateProductService.listByRebateCodes((List<String>)new ArrayList<String>(){
            {
                this.add(code);
            }
        });
        RebateUtil.disAssembleProductList(rebateVo, productMap);
        Map<String, Map<String, List<RebateAreaVo>>> areaMap = this.rebateAreaService.mapByRebateCodes((List<String>)new ArrayList<String>(){
            {
                this.add(code);
            }
        });
        RebateUtil.disAssembleAreaList(rebateVo, areaMap);
        List<RebateExpressionVo> rebateExpressionVos = this.rebateExpressionService.findByRebateCode(code);
        rebateVo.setRebateExpressionVos(rebateExpressionVos);
        return rebateVo;
    }

    @Override
    public List<RebateVo> findDetailsByIds(String ids) {
        ValidateUtils.validate((Object)ids, (String)"\u8bf7\u8f93\u5165\u8981\u67e5\u8be2\u7684\u8fd4\u5229\u653f\u7b56\u7684id\uff01");
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().in((Object)"id", new Object[]{ids});
        List rebateEntities = this.rebateMapper.selectList((Wrapper)wrapper);
        if (rebateEntities == null) {
            throw new BusinessException("\u8981\u67e5\u770b\u7684\u8fd4\u5229\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        List rebateVos = CrmBeanUtil.copyList((List)rebateEntities, RebateVo.class);
        ArrayList<String> codes = new ArrayList<String>();
        for (RebateVo entity : rebateVos) {
            codes.add(entity.getCode());
        }
        Map<String, List<RebateProductVo>> productMap = this.rebateProductService.listByRebateCodes(codes);
        Map<String, Map<String, List<RebateAreaVo>>> areaMap = this.rebateAreaService.mapByRebateCodes(codes);
        Map<String, List<RebateExpressionVo>> expressionMap = this.rebateExpressionService.findByRebateCodes(codes);
        ArrayList list = new ArrayList();
        for (RebateVo vo : rebateVos) {
            RebateUtil.disAssembleProductList(vo, productMap);
            RebateUtil.disAssembleAreaList(vo, areaMap);
            vo.setRebateExpressionVos(expressionMap.get(vo.getCode()));
        }
        return rebateVos;
    }

    @Override
    @Transactional
    public void delByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8981\u5220\u9664\u7684\u8fd4\u5229\u653f\u7b56\uff01");
        }
        List<String> codes = this.rebateMapper.selectBatchIds(ids).stream().map(RebateEntity::getCode).collect(Collectors.toList());
        List<RebateVo> vos = this.findByIds(ids);
        for (RebateVo rebateVo : vos) {
            this.crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj((String)"menuCode").toString(), rebateVo.getId(), null, (Object)rebateVo);
        }
        this.rebateMapper.deleteBatchIds(ids);
        this.rebateProductService.delByRebateCodes(codes);
        this.rebateAreaService.delByRebateCodes(codes);
        this.rebateExpressionService.delByRebateCode(codes);
    }

    @Override
    public List<RebateVo> findByIds(List<String> ids) {
        List entities = this.rebateMapper.selectList((Wrapper)Wrappers.query().in((Object)"id", ids));
        List vos = CrmBeanUtil.copyList((List)entities, RebateVo.class);
        if (CollectionUtil.listEmpty((List)vos)) {
            return Lists.newArrayList();
        }
        return vos;
    }

    @Override
    public PageResult<RebateVo> list(RebateVo rebateVo) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.like(!StringUtils.isEmpty((String)rebateVo.getName()), (Object)"name", (Object)rebateVo.getName());
        queryWrapper.like(!StringUtils.isEmpty((String)rebateVo.getCode()), (Object)"code", (Object)rebateVo.getCode());
        queryWrapper.ge(StringUtils.isNotEmpty((String)rebateVo.getRebateStartDate()), (Object)"rebate_start_date", (Object)rebateVo.getRebateStartDate());
        queryWrapper.le(StringUtils.isNotEmpty((String)rebateVo.getRebateEndDate()), (Object)"rebate_end_date", (Object)rebateVo.getRebateEndDate());
        queryWrapper.eq(rebateVo.getRebateType() != null, (Object)"rebate_type", (Object)rebateVo.getRebateType());
        Page page = PageUtil.buildPage((Integer)rebateVo.getPageNum(), (Integer)rebateVo.getPageSize());
        List<RebateVo> list = this.rebateMapper.list((Page<RebateVo>)page, (QueryWrapper<RebateVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RebateVo findByCode(String code) {
        RebateEntity rebateEntity = (RebateEntity)((Object)this.rebateMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"code", (Object)code)));
        return (RebateVo)CrmBeanUtil.copy((Object)((Object)rebateEntity), RebateVo.class);
    }

    @Override
    @Transactional
    public void updateComputeState(String code, Integer computeState) {
        ValidateUtils.validate((Object)code, (String)"\u4fee\u6539\u4fc3\u9500\u653f\u7b56\u8ba1\u7b97\u72b6\u6001\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(computeState) || YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(computeState) ? 1 : 0) != 0, (String)"\u4fc3\u9500\u653f\u7b56\u8ba1\u7b97\u72b6\u6001\u53ea\u80fd\u65f6\u672a\u8ba1\u7b97[0]\u6216\u8005\u5df2\u8ba1\u7b97[1]", (Object[])new Object[0]);
        UpdateWrapper updateWrapper = (UpdateWrapper)((UpdateWrapper)Wrappers.update().eq((Object)"code", (Object)code)).set((Object)"is_compute", (Object)computeState);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public void updateEffectiveFlag(ArrayList<String> ids, Integer code) {
        RebateVariableUtil.validate(ids, "\u8bf7\u6307\u5b9a\u8981\u4fee\u6539\u7684\u8fd4\u5229\u653f\u7b56\uff01");
        List rebateEntities = this.rebateMapper.selectBatchIds(ids);
        List exitsIds = rebateEntities.stream().map(rebateEntity -> rebateEntity.getId()).collect(Collectors.toList());
        if (exitsIds.size() < ids.size()) {
            throw new BusinessException("\u90e8\u5206\u8fd4\u5229\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", ids);
        RebateEntity entity = new RebateEntity();
        entity.setEffectiveFlag(code);
        this.rebateMapper.update((Object)entity, (Wrapper)wrapper);
    }

    @Override
    public RebateVo findDetailsByCode(String code) {
        RebateVo rebateVo = this.findByCode(code);
        if (rebateVo == null) {
            return null;
        }
        return this.findDetailsById(rebateVo.getId());
    }
}

