/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.eunm.fee.FeePoolTypeEnum;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolAccountReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.rebate.rebatedetail.RebateDetailAdjustLogVo;
import com.biz.crm.nebular.rebate.rebatedetail.RebateDetailVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.rebate.entity.RebateDetailEntity;
import com.biz.crm.rebate.enums.RebateDetailStateEnum;
import com.biz.crm.rebate.enums.RebateTypeEnum;
import com.biz.crm.rebate.mapper.RebateDetailMapper;
import com.biz.crm.rebate.service.RebateDetailAdjustLogService;
import com.biz.crm.rebate.service.RebateDetailService;
import com.biz.crm.rebate.service.RebateService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CommonFieldUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateDetailService")
@ConditionalOnMissingBean(name={"rebateDetailServiceImpl"})
public class RebateDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateDetailMapper, RebateDetailEntity>
implements RebateDetailService {
    @Resource
    private RebateDetailMapper rebateDetailMapper;
    @Resource
    private RebateDetailAdjustLogService rebateDetailAdjustLogService;
    @Resource
    private RebateService rebateService;
    @Resource
    private FeePoolFeign feePoolFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    @Transactional
    public List<RebateDetailVo> addBatch(List<RebateDetailVo> vos) {
        this.validateAddBatch(vos);
        CommonFieldUtil.initCreateFields(vos);
        vos.forEach(vo -> vo.setCode(CodeUtil.generateCode()));
        List entities = CrmBeanUtil.copyList(vos, RebateDetailEntity.class);
        this.saveBatch(entities);
        return CrmBeanUtil.copyList((List)entities, RebateDetailVo.class);
    }

    @Override
    @Transactional
    public RebateDetailVo adjust(RebateDetailAdjustLogVo logVo) {
        this.validateAdjust(logVo);
        RebateDetailEntity entity = (RebateDetailEntity)((Object)this.rebateDetailMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"code", (Object)logVo.getRebateDetailCode())));
        entity.setAdjustAmount(entity.getAdjustAmount().add(logVo.getAdjustAmount()));
        entity.setActualAmount(entity.getComputeAmount().add(entity.getAdjustAmount()));
        ValidateUtils.validate((Object)(entity.getActualAmount().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0), (String)"\u8c03\u6574\u540e\u7684\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
        CommonFieldUtil.initUpdateFields((Object)((Object)entity));
        this.updateById((Object)entity);
        this.rebateDetailAdjustLogService.add(logVo, logVo.getRebateDetailCode());
        return (RebateDetailVo)CrmBeanUtil.copy((Object)((Object)entity), RebateDetailVo.class);
    }

    @Override
    public PageResult<RebateDetailVo> list(RebateDetailVo rebateDetailVo) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq(rebateDetailVo.getOnAccountState() != null, (Object)"on_account_state", (Object)rebateDetailVo.getOnAccountState());
        queryWrapper.like(!StringUtils.isEmpty((String)rebateDetailVo.getCode()), (Object)"code", (Object)rebateDetailVo.getCode());
        queryWrapper.like(!StringUtils.isEmpty((String)rebateDetailVo.getName()), (Object)"name", (Object)rebateDetailVo.getName());
        queryWrapper.eq(!StringUtils.isEmpty((String)rebateDetailVo.getComputeYearMonth()), (Object)"compute_year_month", (Object)rebateDetailVo.getComputeYearMonth());
        queryWrapper.eq(rebateDetailVo.getIsTest() != null, (Object)"is_test", (Object)rebateDetailVo.getIsTest());
        queryWrapper.like(StringUtils.isNotEmpty((String)rebateDetailVo.getCusCode()), (Object)"cus_code", (Object)rebateDetailVo.getCusCode());
        queryWrapper.like(StringUtils.isNotEmpty((String)rebateDetailVo.getCusName()), (Object)"cus_name", (Object)rebateDetailVo.getCusName());
        Page page = PageUtil.buildPage((Integer)rebateDetailVo.getPageNum(), (Integer)rebateDetailVo.getPageSize());
        List<RebateDetailVo> list = this.rebateDetailMapper.list((Page<RebateDetailVo>)page, (QueryWrapper<RebateDetailVo>)queryWrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void invalid(List<String> ids) {
        ValidateUtils.notEmpty(ids, (String)"\u6279\u91cf\u4f5c\u5e9f\u8fd4\u5229\u660e\u7ec6\u65f6\uff0cid\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        UpdateWrapper wrapper = Wrappers.update();
        wrapper.in((Object)"id", ids);
        wrapper.set((Object)"on_account_state", (Object)RebateDetailStateEnum.DISABLED.getCode());
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void onAccount(String id) {
        ValidateUtils.validate((Object)id, (String)"\u4e0a\u8d26\u65f6\uff0c\u8fd4\u5229\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
        RebateDetailEntity detailEntity = (RebateDetailEntity)((Object)this.rebateDetailMapper.selectById((Serializable)((Object)id)));
        ValidateUtils.validate((Object)((Object)detailEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8fd4\u5229\u660e\u7ec6\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u7684\u660e\u7ec6\u7f16\u7801\u662f\u5426\u6b63\u786e");
        RebateVo rebateVo = this.rebateService.findByCode(detailEntity.getRebateCode());
        ValidateUtils.validate((Object)rebateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8fd4\u5229\u653f\u7b56\u8bb0\u5f55");
        ValidateUtils.isTrue((!YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(detailEntity.getOnAccountState()) ? 1 : 0) != 0, (String)"\u8be5\u660e\u7ec6\u5df2\u4e0a\u8fc7\u8d26\u4e0d\u80fd\u91cd\u590d\u4e0a\u8d26", (Object[])new Object[0]);
        ValidateUtils.isTrue((!YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(detailEntity.getIsTest()) ? 1 : 0) != 0, (String)"\u6d4b\u8bd5\u6570\u636e\u4e0d\u80fd\u4e0a\u8d26", (Object[])new Object[0]);
        RebateDetailVo detailVo = (RebateDetailVo)CrmBeanUtil.copy((Object)((Object)detailEntity), RebateDetailVo.class);
        if (RebateTypeEnum.REBATE_ON_ACCOUNT.getCode().equals(rebateVo.getOnAccountType())) {
            this.rebateOnAccount(detailVo);
        } else if (RebateTypeEnum.REP_ON_ACCOUNT.getCode().equals(rebateVo.getOnAccountType())) {
            this.repOnAccount(detailVo);
        } else {
            throw new BusinessException("\u8fd4\u5229\u653f\u7b56\u3010%s(%s)\u3011\u6ca1\u6709\u7ef4\u62a4\u6b63\u786e\u7684\u4e0a\u8d26\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e0a\u8d26\uff0c\u8bf7\u5148\u7ef4\u62a4\u5176\u4e0a\u8d26\u7c7b\u578b\uff0c\u518d\u6765\u505a\u4e0a\u8d26\u64cd\u4f5c", new String[]{rebateVo.getName(), rebateVo.getCode()});
        }
        detailEntity.setOnAccountState(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        this.rebateDetailMapper.updateById((Object)detailEntity);
    }

    @Override
    public void deleteByRebateCodeAndTest(String rebateCode, Integer isTest, String speedNo) {
        ValidateUtils.validate((Object)rebateCode, (String)"\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(isTest) || YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(isTest) ? 1 : 0) != 0, (String)"\u6d4b\u8bd5\u72b6\u6001\u53ea\u80fd\u4f20\u662f\uff081\uff09\uff0c\u5426\uff080\uff09", (Object[])new Object[0]);
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"rebate_code", (Object)rebateCode)).eq((Object)"is_test", (Object)isTest)).notIn(StringUtils.isNotEmpty((String)speedNo), (Object)"speed_no", new Object[]{speedNo});
        this.rebateDetailMapper.delete((Wrapper)wrapper);
    }

    @Override
    public void onAccountBatch(List<String> ids) {
        ids.forEach(id -> this.onAccount((String)id));
    }

    @Override
    public void onAccountParentBatch(List<String> ids) {
        ids.forEach(id -> this.onAccountParent((String)id));
    }

    @Override
    public void onAccountParent(String id) {
        ValidateUtils.validate((Object)id, (String)"\u4e0a\u8d26\u65f6\uff0c\u8fd4\u5229\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
        RebateDetailEntity detailEntity = (RebateDetailEntity)((Object)this.rebateDetailMapper.selectById((Serializable)((Object)id)));
        ValidateUtils.validate((Object)((Object)detailEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8fd4\u5229\u660e\u7ec6\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u7684\u660e\u7ec6\u7f16\u7801\u662f\u5426\u6b63\u786e");
        RebateVo rebateVo = this.rebateService.findByCode(detailEntity.getRebateCode());
        ValidateUtils.validate((Object)rebateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8fd4\u5229\u653f\u7b56\u8bb0\u5f55");
        ValidateUtils.isTrue((!YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(detailEntity.getOnAccountState()) ? 1 : 0) != 0, (String)"\u8be5\u660e\u7ec6\u5df2\u4e0a\u8fc7\u8d26\u4e0d\u80fd\u91cd\u590d\u4e0a\u8d26", (Object[])new Object[0]);
        ValidateUtils.isTrue((!YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(detailEntity.getIsTest()) ? 1 : 0) != 0, (String)"\u6d4b\u8bd5\u6570\u636e\u4e0d\u80fd\u4e0a\u8d26", (Object[])new Object[0]);
        RebateDetailVo detailVo = (RebateDetailVo)CrmBeanUtil.copy((Object)((Object)detailEntity), RebateDetailVo.class);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)this.mdmCustomerMsgFeign.query(null, detailVo.getCusCode()).getResult();
        ValidateUtils.validate((Object)mdmCustomerMsgRespVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5ba2\u6237\u3010%s\u3011\u7684\u539f\u59cb\u6570\u636e", (Object[])new Object[]{detailVo.getCusCode()});
        ValidateUtils.validate((Object)mdmCustomerMsgRespVo.getExt1(), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5ba2\u6237\u3010%s\u3011\u7684\u4e0a\u7ea7\u5ba2\u6237\u7f16\u7801", (Object[])new Object[]{detailVo.getCusCode()});
        detailVo.setCusCode(mdmCustomerMsgRespVo.getExt1());
        if (RebateTypeEnum.REBATE_ON_ACCOUNT.getCode().equals(rebateVo.getOnAccountType())) {
            this.rebateOnAccount(detailVo);
        } else if (RebateTypeEnum.REP_ON_ACCOUNT.getCode().equals(rebateVo.getOnAccountType())) {
            this.repOnAccount(detailVo);
        } else {
            throw new BusinessException("\u8fd4\u5229\u653f\u7b56\u3010%s(%s)\u3011\u6ca1\u6709\u7ef4\u62a4\u6b63\u786e\u7684\u4e0a\u8d26\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e0a\u8d26\uff0c\u8bf7\u5148\u7ef4\u62a4\u5176\u4e0a\u8d26\u7c7b\u578b\uff0c\u518d\u6765\u505a\u4e0a\u8d26\u64cd\u4f5c", new String[]{rebateVo.getName(), rebateVo.getCode()});
        }
        detailEntity.setOnAccountState(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        this.rebateDetailMapper.updateById((Object)detailEntity);
    }

    private void repOnAccount(RebateDetailVo detail) {
        FeePoolAccountReqVo feePoolAccountReqVo = new FeePoolAccountReqVo();
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(detail.getProductLevelFlag())) {
            feePoolAccountReqVo.setProductLevelCode(detail.getRebateProductLevelCode());
        } else {
            feePoolAccountReqVo.setProductCodeList((List)Lists.newArrayList((Object[])new String[]{detail.getComputeProductCode()}));
        }
        feePoolAccountReqVo.setAmount(detail.getActualAmount());
        feePoolAccountReqVo.setCustomerCode(detail.getCusCode());
        feePoolAccountReqVo.setOperationType(FeePoolOperationTypeEnum.REBATE_ACCOUNT.getValue());
        feePoolAccountReqVo.setPoolType(FeePoolTypeEnum.GOODS.getValue());
        feePoolAccountReqVo.setRemarks("\u8fd4\u5229\u4e0a\u8d26");
        feePoolAccountReqVo.setFromCode(detail.getCode());
        feePoolAccountReqVo.setFromDesc("\u8fd4\u5229\u4e0a\u8d26");
        Result result = this.feePoolFeign.account(feePoolAccountReqVo);
        ValidateUtils.isTrue((boolean)result.isSuccess(), (String)result.getMessage(), (Object[])new Object[0]);
    }

    private void rebateOnAccount(RebateDetailVo detail) {
        FeePoolAccountReqVo feePoolAccountReqVo = new FeePoolAccountReqVo();
        feePoolAccountReqVo.setAmount(detail.getActualAmount());
        feePoolAccountReqVo.setCustomerCode(detail.getCusCode());
        feePoolAccountReqVo.setOperationType(FeePoolOperationTypeEnum.REBATE_ACCOUNT.getValue());
        feePoolAccountReqVo.setPoolType(FeePoolTypeEnum.DISCOUNT.getValue());
        feePoolAccountReqVo.setRemarks("\u8fd4\u5229\u4e0a\u8d26");
        feePoolAccountReqVo.setFromCode(detail.getCode());
        feePoolAccountReqVo.setFromDesc("\u8fd4\u5229\u4e0a\u8d26");
        Result result = this.feePoolFeign.account(feePoolAccountReqVo);
        ValidateUtils.isTrue((boolean)result.isSuccess(), (String)result.getMessage(), (Object[])new Object[0]);
    }

    private void validateAdjust(RebateDetailAdjustLogVo logVo) {
        ValidateUtils.validate((Object)logVo, (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)logVo.getRebateDetailCode(), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)logVo.getAdjustAmount(), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)(logVo.getAdjustAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0), (String)"\u660e\u7ec6\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u91cf\u5fc5\u987b\u5927\u4e8e0");
    }

    private void validateAddBatch(List<RebateDetailVo> vos) {
        ValidateUtils.notEmpty(vos, (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u8fd4\u5229\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        for (int i = 0; i < vos.size(); ++i) {
            RebateDetailVo vo = vos.get(0);
            ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getCusName(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[]{i});
            ValidateUtils.validate((Object)vo.getName(), (String)"\u6279\u91cf\u4fdd\u5b58\u8fd4\u5229\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u5f02\u5e38\uff0c\u7b2c%d\u6761\u8bb0\u5f55\u8fd4\u5229\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[]{i});
        }
    }
}

