/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.product.RebateProductVo;
import com.biz.crm.rebate.entity.RebateProductEntity;
import com.biz.crm.rebate.mapper.RebateProductMapper;
import com.biz.crm.rebate.service.RebateProductService;
import com.biz.crm.rebate.util.RebateProductUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"rebateProductServiceExpandImpl"})
@Service(value="rebateProductService")
public class RebateProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateProductMapper, RebateProductEntity>
implements RebateProductService {
    @Resource
    private RebateProductMapper rebateProductMapper;

    @Override
    @Transactional
    public void add(List<RebateProductVo> productVos, String rebateCode) {
        if (CollectionUtil.listEmpty(productVos)) {
            return;
        }
        RebateProductUtil.validateProduct(productVos);
        List collect = productVos.stream().map(product -> product.setRebateCode(rebateCode)).collect(Collectors.toList());
        this.saveBatch(CrmBeanUtil.copyList(collect, RebateProductEntity.class));
    }

    @Override
    @Transactional
    public void delByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u4f60\u8981\u5220\u9664\u7684id!");
        }
        this.rebateProductMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional
    public void delByRebateCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            throw new BusinessException("\u5220\u9664\u4ea7\u54c1\u65f6\uff0c\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.rebateProductMapper.delete((Wrapper)new QueryWrapper().in((Object)"rebate_code", codes));
    }

    @Override
    public Map<String, List<RebateProductVo>> listByRebateCodes(List<String> rebateCodes) {
        HashMap<String, List<RebateProductVo>> result = new HashMap<String, List<RebateProductVo>>();
        if (CollectionUtil.listEmpty(rebateCodes)) {
            return result;
        }
        List productEntities = this.rebateProductMapper.selectList((Wrapper)new QueryWrapper().in((Object)"rebate_code", rebateCodes));
        if (CollectionUtils.isEmpty((Collection)productEntities)) {
            return result;
        }
        List productVos = CrmBeanUtil.copyList((List)productEntities, RebateProductVo.class);
        for (String code : rebateCodes) {
            List collect = productVos.stream().filter(o -> o.getRebateCode().equals(code)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                result.put(code, collect);
                continue;
            }
            result.put(code, new ArrayList());
        }
        return result;
    }

    @Override
    @Transactional
    public void replace(List<RebateProductVo> productVos, final String rebateCode) {
        ValidateUtils.validate((Object)rebateCode, (String)"\u8bf7\u6307\u5b9a\u653f\u7b56\u7f16\u7801\uff01");
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("rebate_code", rebateCode);
            }
        };
        if (CollectionUtils.isEmpty(productVos)) {
            this.rebateProductMapper.deleteByMap(map);
            return;
        }
        productVos = RebateProductUtil.checkParam(productVos);
        List addRebateProductVos = productVos.stream().filter(rebateProductVo -> StringUtils.isEmpty((String)rebateProductVo.getId())).collect(Collectors.toList());
        addRebateProductVos = addRebateProductVos.stream().map(rebateProductVo -> rebateProductVo.setRebateCode(rebateCode)).collect(Collectors.toList());
        List rebateProductVos = productVos.stream().filter(rebateProductVo -> !StringUtils.isEmpty((String)rebateProductVo.getId())).collect(Collectors.toList());
        List ids = rebateProductVos.stream().map(rebateProductVo -> rebateProductVo.getId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rebateProductVos)) {
            this.rebateProductMapper.deleteByMap(map);
            this.saveBatch(CrmBeanUtil.copyList(addRebateProductVos, RebateProductEntity.class));
            return;
        }
        List rebateProductEntities = this.rebateProductMapper.selectByMap(map);
        List rebateProductEntityList = rebateProductEntities.stream().filter(rebateProductEntity -> !ids.contains(rebateProductEntity.getId())).collect(Collectors.toList());
        List delIds = rebateProductEntityList.stream().map(rebateProductEntity -> rebateProductEntity.getId()).collect(Collectors.toList());
        this.removeByIds(delIds);
        this.saveBatch(CrmBeanUtil.copyList(addRebateProductVos, RebateProductEntity.class));
    }

    @Override
    public Map<String, Map<String, List<RebateProductVo>>> MapByRebateCodes(List<String> rebateCodes) {
        HashMap<String, Map<String, List<RebateProductVo>>> result = new HashMap<String, Map<String, List<RebateProductVo>>>();
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        if (CollectionUtils.isEmpty(rebateCodes)) {
            return result;
        }
        List productVos = CrmBeanUtil.copyList((List)this.rebateProductMapper.selectList((Wrapper)new QueryWrapper().in((Object)"rebate_code", rebateCodes)), RebateProductVo.class);
        if (CollectionUtil.listEmpty((List)productVos)) {
            return result;
        }
        for (String code : rebateCodes) {
            List collect = productVos.stream().filter(o -> o.getRebateCode().equals(code)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                result.put(code, map);
                continue;
            }
            List assassProduct = collect.stream().filter(o -> o.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && o.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(assassProduct)) {
                map.put("assassProduct", new ArrayList());
            } else {
                map.put("assassProduct", assassProduct);
            }
            List nonAssassProduct = collect.stream().filter(o -> o.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && o.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(assassProduct)) {
                map.put("nonAssassProduct", new ArrayList());
            } else {
                map.put("nonAssassProduct", nonAssassProduct);
            }
            List assassProductLevel = collect.stream().filter(o -> o.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && o.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(assassProduct)) {
                map.put("assassProductLevel", new ArrayList());
            } else {
                map.put("assassProductLevel", assassProductLevel);
            }
            List nonAssassProductLevel = collect.stream().filter(o -> o.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && o.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(assassProduct)) {
                map.put("nonAssassProductLevel", new ArrayList());
            } else {
                map.put("nonAssassProductLevel", nonAssassProductLevel);
            }
            result.put(code, map);
        }
        return result;
    }
}

