/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.util;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RebateAreaUtil {
    public static void validateProduct(List<RebateAreaVo> rebateAreaVos) {
        rebateAreaVos.stream().forEach(rebateAreaVo -> {
            if (rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())) {
                ValidateUtils.validate((Object)rebateAreaVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                ValidateUtils.validate((Object)rebateAreaVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                ValidateUtils.validate((Object)rebateAreaVo.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                ValidateUtils.validate((Object)rebateAreaVo.getCusName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        });
    }

    public static List<RebateAreaVo> checkParam(List<RebateAreaVo> rebateAreaVos) {
        RebateAreaUtil.validateProduct(rebateAreaVos);
        List<RebateAreaVo> organizations = rebateAreaVos.stream().filter(rebateAreaVo -> rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateAreaVo.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
        organizations = RebateAreaUtil.removeDuplicateOrg(organizations);
        List<RebateAreaVo> nonOrganizations = rebateAreaVos.stream().filter(rebateAreaVo -> rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateAreaVo.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
        nonOrganizations = RebateAreaUtil.removeDuplicateOrg(nonOrganizations);
        List<RebateAreaVo> customers = rebateAreaVos.stream().filter(rebateAreaVo -> rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateAreaVo.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
        customers = RebateAreaUtil.removeDuplicateCus(customers);
        List<RebateAreaVo> nonCustomers = rebateAreaVos.stream().filter(rebateAreaVo -> rebateAreaVo.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateAreaVo.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
        nonCustomers = RebateAreaUtil.removeDuplicateCus(nonCustomers);
        rebateAreaVos.clear();
        rebateAreaVos.addAll(organizations);
        rebateAreaVos.addAll(nonOrganizations);
        rebateAreaVos.addAll(customers);
        rebateAreaVos.addAll(nonCustomers);
        return rebateAreaVos;
    }

    private static List<RebateAreaVo> removeDuplicateOrg(List<RebateAreaVo> organizations) {
        List orgCodes = organizations.stream().map(RebateAreaVo::getOrgCode).collect(Collectors.toList());
        ArrayList duplicateOrgCodes = new ArrayList();
        ArrayList tempList = new ArrayList();
        orgCodes.stream().forEach(code -> {
            if (!tempList.contains(code)) {
                tempList.add(code);
            } else {
                duplicateOrgCodes.add(code);
            }
        });
        return organizations.stream().filter(rebateAreaVo -> {
            if (!duplicateOrgCodes.contains(rebateAreaVo.getOrgCode())) {
                return true;
            }
            return !StringUtils.isEmpty((String)rebateAreaVo.getId());
        }).collect(Collectors.toList());
    }

    private static List<RebateAreaVo> removeDuplicateCus(List<RebateAreaVo> customers) {
        List cusCodes = customers.stream().map(RebateAreaVo::getCusCode).collect(Collectors.toList());
        ArrayList duplicateCusCodes = new ArrayList();
        ArrayList tempList = new ArrayList();
        cusCodes.stream().forEach(code -> {
            if (!tempList.contains(code)) {
                tempList.add(code);
            } else {
                duplicateCusCodes.add(code);
            }
        });
        return customers.stream().filter(rebateAreaVo -> {
            if (!duplicateCusCodes.contains(rebateAreaVo.getCusCode())) {
                return true;
            }
            return !StringUtils.isEmpty((String)rebateAreaVo.getId());
        }).collect(Collectors.toList());
    }

    public static void assembleMap(Map<String, Map<String, List<RebateAreaVo>>> result, List<String> rebateCodes, List<RebateAreaVo> rebateAreaVos) {
        rebateCodes.stream().forEach(rebateCode -> {
            HashMap areaResult = new HashMap();
            List organizations = rebateAreaVos.stream().filter(rebateAreaEntity -> rebateAreaEntity.getRebateCode().equals(rebateCode) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateAreaEntity.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
            List nonOrganizations = rebateAreaVos.stream().filter(rebateAreaEntity -> rebateAreaEntity.getRebateCode().equals(rebateCode) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateAreaEntity.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
            List customers = rebateAreaVos.stream().filter(rebateAreaEntity -> rebateAreaEntity.getRebateCode().equals(rebateCode) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateAreaEntity.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
            List nonCustomers = rebateAreaVos.stream().filter(rebateAreaEntity -> rebateAreaEntity.getRebateCode().equals(rebateCode) && rebateAreaEntity.getOrgFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateAreaEntity.getContainFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
            areaResult.put("containOrg", organizations);
            areaResult.put("nonContainOrg", nonOrganizations);
            areaResult.put("containCus", customers);
            areaResult.put("nonContainCus", nonCustomers);
            result.put((String)rebateCode, areaResult);
        });
    }
}

