/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.rebate.entity.RebateAreaEntity;
import com.biz.crm.rebate.mapper.RebateAreaMapper;
import com.biz.crm.rebate.service.RebateAreaService;
import com.biz.crm.rebate.util.RebateAreaUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"rebateAreaServiceExpandImpl"})
@Service(value="rebateAreaService")
public class RebateAreaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateAreaMapper, RebateAreaEntity>
implements RebateAreaService {
    @Resource
    private RebateAreaMapper rebateAreaMapper;

    @Override
    @Transactional
    public void replace(List<RebateAreaVo> rebateAreaVos, final String rebateCode) {
        ValidateUtils.validate((Object)rebateCode, (String)"\u8bf7\u6307\u5b9a\u8fd4\u5229\u653f\u7b56\uff01");
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("rebate_code", rebateCode);
            }
        };
        if (CollectionUtils.isEmpty(rebateAreaVos)) {
            this.rebateAreaMapper.deleteByMap(map);
            return;
        }
        rebateAreaVos = RebateAreaUtil.checkParam(rebateAreaVos);
        List addRebateAreaVos = rebateAreaVos.stream().filter(rebateAreaVo -> StringUtils.isEmpty((String)rebateAreaVo.getId())).collect(Collectors.toList());
        addRebateAreaVos = addRebateAreaVos.stream().map(rebateAreaVo -> rebateAreaVo.setRebateCode(rebateCode)).collect(Collectors.toList());
        List rebateAreaVoList = rebateAreaVos.stream().filter(rebateAreaVo -> !StringUtils.isEmpty((String)rebateAreaVo.getId())).collect(Collectors.toList());
        List ids = rebateAreaVoList.stream().map(rebateAreaVo -> rebateAreaVo.getId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            this.rebateAreaMapper.deleteByMap(map);
            this.saveBatch(CrmBeanUtil.copyList(addRebateAreaVos, RebateAreaEntity.class));
            return;
        }
        List rebateAreaEntities = this.rebateAreaMapper.selectByMap(map);
        List rebateAreaEntityList = rebateAreaEntities.stream().filter(rebateAreaEntity -> !ids.contains(rebateAreaEntity.getId())).collect(Collectors.toList());
        List delIds = rebateAreaEntityList.stream().map(rebateAreaEntity -> rebateAreaEntity.getId()).collect(Collectors.toList());
        this.removeByIds(delIds);
        this.saveBatch(CrmBeanUtil.copyList(addRebateAreaVos, RebateAreaEntity.class));
    }

    @Override
    @Transactional
    public void delByRebateCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            throw new BusinessException("\u5220\u9664\u533a\u57df\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.rebateAreaMapper.delete((Wrapper)Wrappers.query().in((Object)"rebate_code", codes));
    }

    @Override
    public Map<String, Map<String, List<RebateAreaVo>>> mapByRebateCodes(List<String> rebateCodes) {
        HashMap<String, Map<String, List<RebateAreaVo>>> result = new HashMap<String, Map<String, List<RebateAreaVo>>>();
        if (CollectionUtils.isEmpty(rebateCodes)) {
            return result;
        }
        List rebateAreaEntities = this.rebateAreaMapper.selectList((Wrapper)new QueryWrapper().in((Object)"rebate_code", rebateCodes));
        List rebateAreaVos = CrmBeanUtil.copyList((List)rebateAreaEntities, RebateAreaVo.class);
        RebateAreaUtil.assembleMap(result, rebateCodes, rebateAreaVos);
        return result;
    }

    @Override
    public Map<String, List<RebateAreaVo>> listByRebateCodes(List<String> rebateCodes) {
        HashMap<String, List<RebateAreaVo>> result = new HashMap<String, List<RebateAreaVo>>();
        if (CollectionUtil.listEmpty(rebateCodes)) {
            return result;
        }
        List rebateAreaEntities = this.rebateAreaMapper.selectList((Wrapper)new QueryWrapper().in((Object)"rebate_code", rebateCodes));
        if (CollectionUtils.isEmpty((Collection)rebateAreaEntities)) {
            return result;
        }
        List rebateAreaVos = CrmBeanUtil.copyList((List)rebateAreaEntities, RebateAreaVo.class);
        rebateCodes.stream().forEach(rebateCode -> {
            List rebateAreaVoList = rebateAreaVos.stream().filter(rebateAreaVo -> rebateCode.equals(rebateAreaVo.getRebateCode())).collect(Collectors.toList());
            result.put((String)rebateCode, rebateAreaVoList);
        });
        return result;
    }
}

