/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.util;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.rebate.product.RebateProductVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RebateProductUtil {
    public static void validateProduct(List<RebateProductVo> productVos) {
        for (RebateProductVo products : productVos) {
            if (products.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())) {
                ValidateUtils.validate((Object)products.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                ValidateUtils.validate((Object)products.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                continue;
            }
            ValidateUtils.validate((Object)products.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            ValidateUtils.validate((Object)products.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public static List<RebateProductVo> checkParam(List<RebateProductVo> productVos) {
        RebateProductUtil.validateProduct(productVos);
        List<RebateProductVo> assessLevels = productVos.stream().filter(rebateProductVo -> rebateProductVo.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateProductVo.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
        assessLevels = RebateProductUtil.removeDuplicateLevel(assessLevels);
        List<RebateProductVo> assessProducts = productVos.stream().filter(rebateProductVo -> rebateProductVo.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()) && rebateProductVo.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
        assessProducts = RebateProductUtil.removeDuplicateProducts(assessProducts);
        List<RebateProductVo> rebateLevels = productVos.stream().filter(rebateProductVo -> rebateProductVo.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateProductVo.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())).collect(Collectors.toList());
        rebateLevels = RebateProductUtil.removeDuplicateLevel(rebateLevels);
        List<RebateProductVo> rebateProducts = productVos.stream().filter(rebateProductVo -> rebateProductVo.getAssessFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) && rebateProductVo.getProductLevelFlag().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).collect(Collectors.toList());
        rebateProducts = RebateProductUtil.removeDuplicateProducts(rebateProducts);
        productVos.clear();
        productVos.addAll(assessLevels);
        productVos.addAll(assessProducts);
        productVos.addAll(rebateLevels);
        productVos.addAll(rebateProducts);
        return productVos;
    }

    private static List<RebateProductVo> removeDuplicateProducts(List<RebateProductVo> products) {
        List productCodes = products.stream().map(RebateProductVo::getProductCode).collect(Collectors.toList());
        ArrayList duplicateProductCodes = new ArrayList();
        ArrayList tempList = new ArrayList();
        productCodes.stream().forEach(code -> {
            if (!tempList.contains(code)) {
                tempList.add(code);
            } else {
                duplicateProductCodes.add(code);
            }
        });
        return products.stream().filter(rebateProductVo -> {
            if (!duplicateProductCodes.contains(rebateProductVo.getProductCode())) {
                return true;
            }
            return !StringUtils.isEmpty((String)rebateProductVo.getId());
        }).collect(Collectors.toList());
    }

    private static List<RebateProductVo> removeDuplicateLevel(List<RebateProductVo> levels) {
        List levelCodes = levels.stream().map(RebateProductVo::getProductLevelCode).collect(Collectors.toList());
        ArrayList duplicateLevelCodes = new ArrayList();
        ArrayList tempList = new ArrayList();
        levelCodes.stream().forEach(code -> {
            if (!tempList.contains(code)) {
                tempList.add(code);
            } else {
                duplicateLevelCodes.add(code);
            }
        });
        return levels.stream().filter(rebateProductVo -> {
            if (!duplicateLevelCodes.contains(rebateProductVo.getProductLevelCode())) {
                return true;
            }
            return !StringUtils.isEmpty((String)rebateProductVo.getId());
        }).collect(Collectors.toList());
    }
}

