/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.nebular.rebate.expression.RebateConditionComputeResult;
import com.biz.crm.nebular.rebate.expression.RebateExecuteComputeResult;
import com.biz.crm.nebular.rebate.expression.RebateExpressionVo;
import com.biz.crm.nebular.rebate.product.RebateProductVo;
import com.biz.crm.nebular.rebate.rebatedetail.RebateComputeLogVo;
import com.biz.crm.nebular.rebate.rebatedetail.RebateComputeParam;
import com.biz.crm.nebular.rebate.rebatedetail.RebateComputeWebParam;
import com.biz.crm.nebular.rebate.rebatedetail.RebateDetailVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.nebular.rebate.variable.RebateVariableVo;
import com.biz.crm.rebate.entity.RebateEntity;
import com.biz.crm.rebate.enums.RebateDetailStateEnum;
import com.biz.crm.rebate.mapper.RebateMapper;
import com.biz.crm.rebate.service.RebateAreaService;
import com.biz.crm.rebate.service.RebateComputeLogService;
import com.biz.crm.rebate.service.RebateComputeService;
import com.biz.crm.rebate.service.RebateDetailService;
import com.biz.crm.rebate.service.RebateExpressionService;
import com.biz.crm.rebate.service.RebateProductService;
import com.biz.crm.rebate.service.RebateService;
import com.biz.crm.rebate.util.MathUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.variable.service.RebateVariableService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateComputeService")
@ConditionalOnMissingBean(name={"rebateComputeServiceImpl"})
public class RebateComputeServiceImpl
implements RebateComputeService {
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private RebateMapper rebateMapper;
    @Resource
    private RebateAreaService rebateAreaService;
    @Resource
    private RebateProductService rebateProductService;
    @Resource
    private RebateExpressionService rebateExpressionService;
    @Resource
    private RebateVariableService rebateVariableService;
    @Resource
    private RebateService rebateService;
    @Resource
    private RebateDetailService rebateDetailService;
    @Resource
    private RebateComputeLogService rebateComputeLogService;

    @Override
    @Transactional
    public void calByCodes(List<String> codes, Date computeTime, String rebateTitle, Integer isTest) {
        ValidateUtils.notEmpty(codes, (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u653f\u7b56\u7f16\u7801\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        ValidateUtils.validate((Object)isTest, (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u662f\u5426\u6d4b\u8bd5\u3010isTest\u3011\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.isTrue((YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(isTest) || YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(isTest) ? 1 : 0) != 0, (String)"\u662f\u5426\u6d4b\u8bd5\u53ea\u80fd\u4f20\u90120\uff08\u5426\uff09\u6216\u80051\uff08\u662f\uff09", (Object[])new Object[0]);
        if (computeTime == null) {
            computeTime = new Date();
        }
        String computeDateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(computeTime);
        List entities = this.rebateMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().in((Object)"code", codes)).eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode())).lt((Object)"rebate_start_date", (Object)computeDateStr));
        ValidateUtils.notEmpty((Collection)entities, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u4efb\u4f55%s\u7b26\u5408\u65f6\u95f4\u8303\u56f4\u7684\u672a\u8ba1\u7b97\u8fc7\u7684\u6709\u6548\u653f\u7b56\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u653f\u7b56\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165\uff0c\u6216\u8005\u5b58\u5728\u91cd\u590d\u8ba1\u7b97", (String[])new String[]{computeDateStr});
        Map<String, List<RebateAreaVo>> cusMap = this.rebateAreaService.listByRebateCodes(codes);
        cusMap = this.buildCuss(cusMap);
        Map<String, List<RebateProductVo>> rebateProductMap = this.rebateProductService.listByRebateCodes(codes);
        Map<String, List<RebateExpressionVo>> expressionMap = this.rebateExpressionService.listByRebateCodes(codes);
        List<RebateComputeParam> params = this.buildParam(entities, cusMap, rebateProductMap, expressionMap);
        String speedNo = CodeUtil.generateCode();
        for (RebateComputeParam param : params) {
            param.setSpeedNo(speedNo);
            param.setComputeTime(computeTime);
            param.setRebateTitle(rebateTitle);
            param.setIsTest(isTest);
            this.cal(param);
        }
    }

    @Override
    @Transactional
    public void cal(RebateComputeParam param) {
        this.validateCal(param);
        RebateExpressionVo rebateExpressionVo = this.rebateExpressionService.findByCode(param.getExpressionCode());
        ValidateUtils.validate((Object)rebateExpressionVo, (String)"\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u516c\u5f0f\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        RebateVo rebateVo = this.rebateService.findDetailsByCode(param.getRebateCode());
        ValidateUtils.validate((Object)rebateVo, (String)"\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u653f\u7b56\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u4f20\u5165\u653f\u7b56\u7f16\u7801");
        RebateConditionComputeResult conditionResult = this.computeConditionExpression(rebateExpressionVo.getConditionExpress(), rebateVo, param);
        RebateExecuteComputeResult executeComputeResult = null;
        boolean flag = conditionResult.isValue();
        MdmCustomerMsgRespVo customerMsgRespVo = (MdmCustomerMsgRespVo)this.mdmCustomerMsgFeign.query(null, param.getCusCode()).getResult();
        ValidateUtils.validate((Object)customerMsgRespVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5ba2\u6237\u4fe1\u606f\u3010%s\u3011", (Object[])new Object[]{param.getCusCode()});
        RebateDetailVo detailVo = null;
        boolean isTest = YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(param.getIsTest());
        if (flag) {
            executeComputeResult = this.computeRebateExpression(rebateExpressionVo.getComputeExpress(), rebateVo, param);
            if (isTest) {
                this.rebateDetailService.deleteByRebateCodeAndTest(rebateVo.getCode(), YesNoEnum.YesNoCodeNumberEnum.YES.getCode(), param.getSpeedNo());
            }
            detailVo = this.buildAndCreateDetail(param, rebateVo, executeComputeResult, customerMsgRespVo);
            ValidateUtils.validate((Object)detailVo, (String)"\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u660e\u7ec6\u5931\u8d25");
        }
        if (isTest) {
            this.rebateComputeLogService.deleteByRebateCodeAndTest(rebateVo.getCode(), YesNoEnum.YesNoCodeNumberEnum.YES.getCode(), param.getSpeedNo());
        }
        this.buildAndCreateComputeLog(param, rebateVo, conditionResult, executeComputeResult, customerMsgRespVo, detailVo);
        if (!isTest) {
            this.rebateService.updateComputeState(rebateVo.getCode(), YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        }
    }

    private void buildAndCreateComputeLog(RebateComputeParam param, RebateVo rebateVo, RebateConditionComputeResult conditionResult, RebateExecuteComputeResult executeComputeResult, MdmCustomerMsgRespVo customerMsgRespVo, RebateDetailVo detailVo) {
        ValidateUtils.validate((Object)param, (String)"\u4fdd\u5b58\u8ba1\u7b97\u65e5\u5fd7\u6570\u636e\uff0c\u8ba1\u7b97\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)rebateVo, (String)"\u4fdd\u5b58\u8ba1\u7b97\u65e5\u5fd7\u6570\u636e\uff0c\u8fd4\u5229\u653f\u7b56\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)conditionResult, (String)"\u4fdd\u5b58\u8ba1\u7b97\u65e5\u5fd7\u6570\u636e\uff0c\u6761\u4ef6\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        RebateComputeLogVo vo = new RebateComputeLogVo();
        vo.setComputeTime(DateUtil.format((Date)param.getComputeTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        vo.setRebateCode(rebateVo.getCode());
        vo.setCusCode(customerMsgRespVo.getCustomerCode());
        vo.setCusName(customerMsgRespVo.getCustomerName());
        vo.setExpressionCode(param.getExpressionCode());
        vo.setComputeProductCode(param.getRebateProductCode());
        vo.setSpeedNo(param.getSpeedNo());
        vo.setComputeYearMonth(DateUtil.format((Date)param.getComputeTime(), (String)"yyyy-MM"));
        if (detailVo != null) {
            vo.setDetailCode(detailVo.getCode());
            vo.setDetailName(detailVo.getName());
        }
        vo.setConditionExpression(conditionResult.getExpressStr());
        vo.setConditionValues(conditionResult.getComputeProcess());
        vo.setConditionProperties(conditionResult.getComputeProcessResult());
        vo.setConditionResult(Boolean.valueOf(conditionResult.isValue()));
        if (executeComputeResult != null) {
            vo.setComputeExpression(executeComputeResult.getExpressStr());
            vo.setComputeValues(executeComputeResult.getComputeProcess());
            vo.setComputeProperties(executeComputeResult.getComputeProcessResult());
            vo.setComputeResult(executeComputeResult.getValue());
        }
        vo.setIsTest(param.getIsTest());
        vo.setProductLevelFlag(param.getProductLevelFlag());
        vo.setRebateProductLevelCode(param.getRebateProductLevelCode());
        this.rebateComputeLogService.add(vo, vo.getDetailCode());
    }

    private RebateDetailVo buildAndCreateDetail(RebateComputeParam param, RebateVo rebateVo, RebateExecuteComputeResult computeResult, MdmCustomerMsgRespVo customerMsgRespVo) {
        ValidateUtils.validate((Object)param, (String)"\u4fdd\u5b58\u660e\u7ec6\u6570\u636e\u65f6\uff0c\u8ba1\u7b97\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)rebateVo, (String)"\u4fdd\u5b58\u660e\u7ec6\u6570\u636e\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)computeResult, (String)"\u4fdd\u5b58\u660e\u7ec6\u6570\u636e\u65f6\uff0c\u8ba1\u7b97\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        RebateDetailVo vo = new RebateDetailVo();
        vo.setComputeTime(DateUtil.format((Date)param.getComputeTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        vo.setName(param.getRebateTitle());
        vo.setRebateCode(rebateVo.getCode());
        vo.setExpressionCode(param.getExpressionCode());
        vo.setComputeProductCode(param.getRebateProductCode());
        vo.setOnAccountState(RebateDetailStateEnum.UN_ON_ACCOUNT.getCode());
        vo.setCusCode(customerMsgRespVo.getCustomerCode());
        vo.setCusName(customerMsgRespVo.getCustomerName());
        vo.setCusChannelCode(customerMsgRespVo.getChannel());
        vo.setCusChannelName(customerMsgRespVo.getChannelName());
        vo.setCusOrgCode(customerMsgRespVo.getOrgCode());
        vo.setCusOrgName(customerMsgRespVo.getOrgName());
        vo.setComputeAmount(computeResult.getValue());
        vo.setActualAmount(computeResult.getValue());
        vo.setRebateType(rebateVo.getRebateType());
        vo.setStartTime(rebateVo.getRebateStartDate());
        vo.setEndTime(rebateVo.getRebateEndDate());
        vo.setIsTest(param.getIsTest());
        vo.setSpeedNo(param.getSpeedNo());
        vo.setProductLevelFlag(param.getProductLevelFlag());
        vo.setRebateProductLevelCode(param.getRebateProductLevelCode());
        vo.setComputeYearMonth(DateUtil.format((Date)param.getComputeTime(), (String)"yyyy-MM"));
        List<RebateDetailVo> vos = this.rebateDetailService.addBatch(Lists.newArrayList((Object[])new RebateDetailVo[]{vo}));
        return CollectionUtil.listEmpty(vos) ? null : vos.get(0);
    }

    @Override
    public RebateExecuteComputeResult computeRebateExpression(String expressStr, RebateVo rebateVo, RebateComputeParam param) {
        ValidateUtils.validate((Object)expressStr, (String)"\u89e3\u6790\u8fd4\u5229\u8868\u8fbe\u5f0f\u65f6\uff0c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)rebateVo, (String)"\u89e3\u6790\u8fd4\u5229\u8868\u8fbe\u5f0f\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a");
        RebateExecuteComputeResult result = new RebateExecuteComputeResult();
        RebateConditionComputeResult conditionComputeResult = this.replaceVariable(expressStr, rebateVo, param);
        String expressValue = conditionComputeResult.getExpressValue();
        BigDecimal computeResult = MathUtil.computeExpression(expressValue, BigDecimal.class);
        ValidateUtils.validate((Object)computeResult, (String)"\u8fd4\u5229\u516c\u5f0f\u3010%s\u3011\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u662f\u5426\u6b63\u786e", (Object[])new Object[]{expressStr});
        result.setExpressStr(expressStr);
        result.setExpressValue(expressValue);
        result.setValue(computeResult);
        result.setComputeProcess(conditionComputeResult.getComputeProcess());
        result.setComputeProcessResult(conditionComputeResult.getComputeProcessResult());
        return result;
    }

    @Override
    public RebateConditionComputeResult computeConditionExpression(String expressStr, RebateVo rebateVo, RebateComputeParam param) {
        ValidateUtils.validate((Object)expressStr, (String)"\u89e3\u6790\u6761\u4ef6\u8868\u8fbe\u5f0f\u65f6\uff0c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)rebateVo, (String)"\u89e3\u6790\u6761\u4ef6\u8868\u8fbe\u5f0f\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        RebateConditionComputeResult result = this.replaceVariable(expressStr, rebateVo, param);
        String expressValue = result.getExpressValue();
        Boolean computeResult = MathUtil.computeExpression(expressValue, Boolean.class);
        ValidateUtils.validate((Object)computeResult, (String)"\u8fd4\u5229\u6761\u4ef6\u516c\u5f0f\u3010%s\u3011\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u662f\u5426\u6b63\u786e", (Object[])new Object[]{expressStr});
        result.setValue(computeResult.booleanValue());
        result.setExpressStr(expressStr);
        return result;
    }

    @Override
    @Transactional
    public void calByCodes(RebateComputeWebParam param) {
        ValidateUtils.validate((Object)param, (String)"\u8fd4\u5229\u8ba1\u7b97\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        this.calByCodes(param.getCodes(), param.getComputeTime(), param.getRebateTitle(), param.getIsTest());
    }

    private RebateConditionComputeResult replaceVariable(String expressStr, RebateVo rebateVo, RebateComputeParam param) {
        ValidateUtils.validate((Object)expressStr, (String)"\u66ff\u6362\u516c\u5f0f\u53d8\u91cf\u65f6\uff0c\u516c\u5f0f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        RebateConditionComputeResult result = new RebateConditionComputeResult();
        result.setExpressStr(expressStr);
        Pattern pattern = Pattern.compile("[0-9]*[a-zA-Z]{1,}[0-9]*");
        Matcher matcher = pattern.matcher(expressStr);
        ArrayList variables = Lists.newArrayList();
        while (matcher.find()) {
            variables.add(matcher.group());
        }
        List<RebateVariableVo> variableVos = this.rebateVariableService.findByCodes(variables);
        Map<String, BigDecimal> variableMap = YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(param.getIsTest()) ? this.rebateVariableService.getValueByVariable(param.getCusCode(), UUID.randomUUID().toString(), rebateVo, variableVos, DateUtil.format((Date)param.getComputeTime(), (String)"yyyy-MM-dd HH:mm:ss")) : variableVos.stream().collect(Collectors.toMap(RebateVariableVo::getCode, a -> a.getReplacementValue() == null ? BigDecimal.ZERO : a.getReplacementValue()));
        String expressValue = expressStr;
        String expressProperties = new String();
        String expressProcess = new String();
        for (Map.Entry<String, BigDecimal> entry : variableMap.entrySet()) {
            String k = entry.getKey() == null ? "" : entry.getKey().toString();
            String v = entry.getValue() == null ? "0" : ((Object)entry.getValue()).toString();
            ValidateUtils.validate((Object)v, (String)"%s\u65f6\u68c0\u6d4b\u5230\u53d8\u91cf\u3010%s\u3011\u503c\u4e3a\u7a7a", (Object[])new Object[]{YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(param.getIsTest()) ? "\u8ba1\u7b97" : "\u6d4b\u8bd5\u8ba1\u7b97", k});
            expressValue = expressValue.replace(k, v);
            expressProperties = String.join((CharSequence)";", expressProperties, String.join((CharSequence)",", String.join((CharSequence)":", "variableCode", k), String.join((CharSequence)":", "speedNo", param.getSpeedNo()), String.join((CharSequence)":", "rebateCode", rebateVo.getCode()), String.join((CharSequence)":", "computeTime", DateUtil.format((Date)param.getComputeTime(), (String)"yyyy-MM-dd HH:mm:ss"))));
            expressProcess = String.join((CharSequence)";", expressProcess, String.join((CharSequence)":", k, v));
        }
        if (StringUtils.isNotEmpty((String)expressProperties)) {
            expressProperties = expressProperties.substring(1);
        }
        if (StringUtils.isNotEmpty((String)expressProcess)) {
            expressProcess = expressProcess.substring(1);
        }
        result.setExpressValue(expressValue);
        result.setComputeProcessResult(expressProperties);
        result.setComputeProcess(expressProcess);
        return result;
    }

    private void validateCal(RebateComputeParam param) {
        ValidateUtils.validate((Object)param, (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)param.getCusCode(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)param.getRebateCode(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u8fd4\u5229\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)param.getSpeedNo(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u8ba1\u7b97\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)param.getExpressionCode(), (String)"\u8ba1\u7b97\u8fd4\u5229\u65f6\uff0c\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private List<RebateComputeParam> buildParam(List<RebateEntity> entities, Map<String, List<RebateAreaVo>> cusMap, Map<String, List<RebateProductVo>> rebateProductMap, Map<String, List<RebateExpressionVo>> expressionMap) {
        ArrayList params = Lists.newArrayList();
        entities.forEach(en -> {
            List cuss = (List)cusMap.get(en.getCode());
            ValidateUtils.notEmpty((Collection)cuss, (String)"\u6267\u884c\u653f\u7b56\u3010%s(%s)\u3011\u8ba1\u7b97\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u4eab\u53d7\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\u8be5\u653f\u7b56\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String[])new String[]{en.getName(), en.getCode()});
            cuss = Lists.newArrayList(cuss.stream().collect(Collectors.toMap(RebateAreaVo::getCusCode, cus -> cus, (c1, c2) -> c2)).values());
            List productVos = (List)rebateProductMap.get(en.getCode());
            productVos = CollectionUtil.listEmpty((List)productVos) ? Lists.newArrayList() : productVos;
            productVos = Lists.newArrayList(productVos.stream().collect(Collectors.toMap(RebateProductVo::getProductCode, p -> p, (p1, p2) -> p2)).values());
            List expressionVos = (List)expressionMap.get(en.getCode());
            this.buildParam((RebateEntity)((Object)en), cuss, productVos, expressionVos, params);
        });
        return params;
    }

    private void buildParam(RebateEntity en, List<RebateAreaVo> cuss, List<RebateProductVo> productVos, List<RebateExpressionVo> expressionVos, List<RebateComputeParam> params) {
        if (CollectionUtil.listEmpty(cuss)) {
            cuss.add(new RebateAreaVo());
        }
        if (CollectionUtil.listEmpty(productVos)) {
            productVos.add(new RebateProductVo());
        }
        if (CollectionUtil.listEmpty(expressionVos)) {
            expressionVos.add(new RebateExpressionVo());
        }
        cuss.forEach(cus -> {
            if (CollectionUtil.listNotEmpty((List)productVos)) {
                productVos.forEach(product -> expressionVos.forEach(express -> {
                    RebateComputeParam param = new RebateComputeParam();
                    param.setCusCode(cus.getCusCode());
                    param.setProductLevelFlag(product.getProductLevelFlag());
                    param.setRebateProductCode(product.getProductCode());
                    param.setRebateProductLevelCode(product.getProductLevelCode());
                    param.setRebateProductCode(product.getProductCode());
                    param.setExpressionCode(express.getCode());
                    param.setRebateCode(en.getCode());
                    params.add(param);
                }));
            } else {
                expressionVos.forEach(express -> {
                    RebateComputeParam param = new RebateComputeParam();
                    param.setCusCode(cus.getCusCode());
                    param.setExpressionCode(express.getCode());
                    param.setRebateCode(en.getCode());
                    params.add(param);
                });
            }
        });
    }

    private Map<String, List<RebateAreaVo>> buildCuss(Map<String, List<RebateAreaVo>> cusMap) {
        cusMap.forEach((k, v) -> {
            List cuss = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getOrgFlag()) && YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(f.getContainFlag())).collect(Collectors.toList());
            List<RebateAreaVo> cusOrgs = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(f.getOrgFlag()) && YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(f.getContainFlag())).collect(Collectors.toList());
            List divideCuss = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getOrgFlag()) && YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getContainFlag())).collect(Collectors.toList());
            List<RebateAreaVo> divideCusOrgs = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(f.getOrgFlag()) && YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getContainFlag())).collect(Collectors.toList());
            ArrayList allCuss = Lists.newArrayList();
            allCuss.addAll(cuss);
            allCuss.addAll(this.buildCussByOrg(cusOrgs));
            ArrayList allDivideCuss = Lists.newArrayList();
            allDivideCuss.addAll(divideCuss);
            allDivideCuss.addAll(this.buildCussByOrg(divideCusOrgs));
            this.differenceCuss(allCuss, allDivideCuss);
            v.clear();
            v.addAll(allCuss);
        });
        return cusMap;
    }

    private void differenceCuss(List<RebateAreaVo> sourceCuss, List<RebateAreaVo> targetCuss) {
        List result = sourceCuss.stream().filter(source -> !this.containsCusCode(targetCuss, source.getCusCode())).collect(Collectors.toList());
        if (CollectionUtil.listNotEmpty(result)) {
            sourceCuss.clear();
            sourceCuss.addAll(result);
        }
    }

    private boolean containsCusCode(List<RebateAreaVo> cuss, String cusCode) {
        if (CollectionUtil.listEmpty(cuss)) {
            return false;
        }
        List cusCodes = cuss.stream().map(RebateAreaVo::getCusCode).collect(Collectors.toList());
        return cusCodes.contains(cusCode);
    }

    private List<RebateAreaVo> buildCussByOrg(List<RebateAreaVo> cusOrgs) {
        ArrayList rebateAreaVos = Lists.newArrayList();
        cusOrgs.forEach(org -> {
            MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
            mdmCustomerMsgReqVo.setCustomerOrgCode(org.getOrgCode());
            List cusRel = (List)this.mdmCustomerMsgFeign.findCustomerSelectList(mdmCustomerMsgReqVo).getResult();
            this.buildCussByFeignRel(cusRel, rebateAreaVos);
        });
        return rebateAreaVos;
    }

    private void buildCussByFeignRel(List<MdmCustomerMsgSelectRespVo> cusRel, List<RebateAreaVo> rebateAreaVos) {
        if (CollectionUtil.listEmpty(cusRel)) {
            return;
        }
        cusRel.forEach(cus -> {
            RebateAreaVo vo = new RebateAreaVo();
            vo.setCusCode(cus.getCustomerCode());
            rebateAreaVos.add(vo);
        });
    }

    private Map<String, List<RebateProductVo>> buildRebateProducts(Map<String, List<RebateProductVo>> productMap) {
        productMap.forEach((k, v) -> {
            List productVos = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getProductLevelFlag()) && YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getAssessFlag())).collect(Collectors.toList());
            List<RebateProductVo> productLevelVos = v.stream().filter(f -> YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(f.getProductLevelFlag()) && YesNoEnum.YesNoCodeNumberEnum.NO.getCode().equals(f.getAssessFlag())).collect(Collectors.toList());
            v.clear();
            v.addAll(productVos);
            v.addAll(this.buildProductsByLevel(productLevelVos));
        });
        return productMap;
    }

    private List<RebateProductVo> buildProductsByLevel(List<RebateProductVo> productLevelVos) {
        ArrayList vos = Lists.newArrayList();
        productLevelVos.forEach(level -> {
            MdmProductReqVo mdmProductReqVo = new MdmProductReqVo();
            mdmProductReqVo.setProductLevelCode(level.getProductLevelCode());
            List mdmProductRespVos = (List)this.mdmProductFeign.listCondition(mdmProductReqVo).getResult();
            this.buildProductsByFeignRel(mdmProductRespVos, vos);
        });
        return vos;
    }

    private void buildProductsByFeignRel(List<MdmProductRespVo> mdmProductRespVos, List<RebateProductVo> vos) {
        if (CollectionUtil.listEmpty(mdmProductRespVos)) {
            return;
        }
        mdmProductRespVos.forEach(product -> {
            RebateProductVo productVo = new RebateProductVo();
            productVo.setProductCode(product.getProductCode());
            vos.add(productVo);
        });
    }
}

