/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.rebate.entity.RebateAreaEntity;
import com.biz.crm.rebate.entity.RebateEntity;
import com.biz.crm.rebate.mapper.RebateAreaMapper;
import com.biz.crm.rebate.mapper.RebateMapper;
import com.biz.crm.rebate.service.RebateApiService;
import com.biz.crm.rebate.service.RebateAreaService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@ConditionalOnMissingBean(name={"RebateApiServiceExpandImpl"})
@Service
public class RebateApiServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateMapper, RebateEntity>
implements RebateApiService {
    @Resource
    private RebateMapper rebateMapper;
    @Resource
    private RebateAreaService rebateAreaService;
    @Resource
    private RebateAreaMapper areaMapper;

    @Override
    public PageResult<RebateVo> findRebatesByParam(RebateVo reqVo) {
        List<RebateVo> list;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        page.setSearchCount(reqVo.getNeedPageFlag().booleanValue());
        if (reqVo.getQueryEffectiveFlag().booleanValue()) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        if (CollectionUtils.isNotEmpty(list = this.rebateMapper.findRebatesByParam((Page<RebateVo>)page, reqVo)) && reqVo.getQueryScopeFlag().booleanValue()) {
            List codes = list.stream().map(RebateVo::getCode).collect(Collectors.toList());
            List policyScopeEntities = this.areaMapper.selectList((Wrapper)Wrappers.lambdaQuery(RebateAreaEntity.class).in(RebateAreaEntity::getRebateCode, codes));
            Map<String, List<RebateAreaEntity>> map = policyScopeEntities.stream().collect(Collectors.groupingBy(RebateAreaEntity::getRebateCode));
            list.forEach(o -> {
                List scopeEntities = (List)map.get(o.getCode());
                if (CollectionUtils.isNotEmpty((Collection)scopeEntities)) {
                    List rebateAreaVos = CrmBeanUtil.copyList((List)scopeEntities, RebateAreaVo.class);
                    o.setScopeList(rebateAreaVos);
                } else {
                    o.setScopeList(Collections.EMPTY_LIST);
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

