package com.biz.crm.mq;

import com.biz.crm.mq.mqlog.MdmMqMessageLogFeign;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;

import java.util.Map;


/**
 * MQ 发送工具
 *  @author: luoqi
 *  @Date: 2020-9-25 17:35
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class RocketMQProducer {
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private MdmMqMessageLogFeign mdmMqMessageLogFeign;
    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topicDef;


    /**
     * 发送消息
     *  @author: luoqi
     *  @Date: 2020-9-27 14:50
     *  @version: V1.0
     *  @Description:
     */
    public void convertAndSend(RocketMQMessageBody mqMessageBody){
        MdmMqMessageLogVo logVo = this.msgLog(mqMessageBody);
        try {
//            MessagePostProcessor messagePostProcessor = new MessagePostProcessor() {
//                @Override
//                public Message<?> postProcessMessage(Message<?> message) {
//                    return null;
//                }
//            };
            Map<String, Object> header = Maps.newHashMap();
            header.put(MessageConst.PROPERTY_KEYS, logVo.getId());
            rocketMQTemplate.convertAndSend(logVo.getTopicAndTags(), mqMessageBody, header);
        }catch (MessagingException e){
            this.msgException(logVo, mqMessageBody, e);
        }
    }

    /**
     * 批量
     * @param mqMessageBody
     */
    public void convertAndSendBatch(RocketMQMessageBody mqMessageBody){
        //TODO 批量待实现
        return;
    }
    /**
     * 同步发送顺序消费的消息
     * @param mqMessageBody
     */
    public void syncSendOrderly(RocketMQMessageBody mqMessageBody){
        MdmMqMessageLogVo logVo = this.msgLog(mqMessageBody);

        try {
//            MessagePostProcessor messagePostProcessor = new MessagePostProcessor() {
//                @Override
//                public Message<?> postProcessMessage(Message<?> message) {
//                    return null;
//                }
//            };
            SendResult sendResult = rocketMQTemplate.syncSendOrderly(logVo.getTopicAndTags(), mqMessageBody, logVo.getId());
        }catch (Exception e){
            this.msgException(logVo, mqMessageBody, e);
        }
    }

    private void msgException(MdmMqMessageLogVo logVo, RocketMQMessageBody mqMessageBody, Exception e){
        log.error("MQ消息发送失败:mqMessageBody = {} >>>", JsonPropertyUtil.toJsonString(mqMessageBody), e);
        logVo.setSendLog(ExceptionUtils.getStackTrace(e));
        if(StringUtils.isBlank(logVo.getSendLog())){
            logVo.setSendLog("MQ消息发送失败");
        }
        mdmMqMessageLogFeign.update(logVo);
    }

    private MdmMqMessageLogVo msgLog(RocketMQMessageBody mqMessageBody){
        if(StringUtils.isBlank(mqMessageBody.getTopic())){
            mqMessageBody.setTopic(this.topicDef);
        }
        MdmMqMessageLogVo logVo = MdmMqMessageLogVo.buildLogVo(mqMessageBody);
        Result<String> result = mdmMqMessageLogFeign.save(logVo);
        if(null != result){
            String logid = result.getResult();
            mqMessageBody.setId(logid);
            logVo.setId(logid);
        }
        if(StringUtils.isBlank(logVo.getId())){
            log.warn("记录日志失败：mqMessageBody = {}", JsonPropertyUtil.toJsonString(mqMessageBody));
        }
        return logVo;
    }




}
