package com.biz.crm.mq;

import com.biz.crm.base.BusinessException;
import com.biz.crm.mq.mqlog.MdmMqMessageLogFeign;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;


/**
 *  @author: luoqi
 *  @Date: 2020-10-30 11:33
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
public abstract class AbstractRocketMQConsumer implements RocketMQListener<RocketMQMessageBody> {
    @Autowired
    private MdmMqMessageLogFeign mdmMqMessageLogFeign;

    @Override
    public void onMessage(RocketMQMessageBody message) {
        if(null == message){
            log.warn("消费MQ消息：RocketMQMessageBody 为空，忽略本次消费");
            throw new BusinessException("消费MQ消息：RocketMQMessageBody 为空，忽略本次消费");
        }
        MdmMqMessageLogVo logVo = new MdmMqMessageLogVo();
        Exception handleException = null;
        String json = JsonPropertyUtil.toJsonString(message);
        // 调用用户实现的 handleMessage 消费消息
        try {
            UserUtils.doTokenForNull();
            logVo.setCallbackBegin(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmssSSS));
            Object result = this.handleMessage(message);
            logVo.setCallbackEnd(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmssSSS));
            logVo.setCallbackLog(JsonPropertyUtil.toJsonString(result));
        }catch (Exception e){
            log.error("消费MQ消息，失败：message = {} >>>", json, e);
            logVo.setCallbackLog(ExceptionUtils.getStackTrace(e));
            handleException = e;
        }
        //丢失日志id
        if(StringUtils.isBlank(message.getId())){
            log.warn("消费MQ消息，记录日志失败：message = {}", json);
            //抛出异常
            if(null != handleException){
                throw new BusinessException("消费MQ消息，失败：message = " + json, handleException);
            }
            return;
        }
        //回写日志到数据行
        try {
            logVo.setId(message.getId());
            UserUtils.doTokenForNull();
            mdmMqMessageLogFeign.update(logVo);
        }catch (Exception e){
            log.error("消费MQ消息，记录日志失败：message = {} >>>", json, e);
        }
        //抛出异常
        if(null != handleException){
            throw new BusinessException("消费MQ消息，失败：message = " + json, handleException);
        }

    }

    /**
     * 消费消息
     * @param message
     * @return
     */
    protected abstract Object handleMessage(RocketMQMessageBody message) throws InterruptedException;
}
