package com.biz.crm.mq;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mq.mqlog.MdmMqMessageLogEs;
import com.biz.crm.mq.mqlog.MdmMqMessageLogRepository;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;


/**
 * MQ 发送工具
 *  @author: luoqi
 *  @Date: 2020-9-25 17:35
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class RocketMQProducer {
    @Resource
    private RocketMQTemplate rocketMQTemplate;
    @Resource
    private MdmMqMessageLogRepository mdmMqMessageLogRepository;
//    @Resource
//    private MdmMqMessageLogFeign mdmMqMessageLogFeign;
    @Resource
    private RedisService redisService;
    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topicDef;


    /**
     * 发送消息
     *  @author: luoqi
     *  @Date: 2020-9-27 14:50
     *  @version: V1.0
     *  @Description:
     */
    public void convertAndSend(RocketMQMessageBody mqMessageBody){
        MdmMqMessageLogEs logVo = this.msgLog(mqMessageBody);
        log.info("MQ消息发送消息[mqMessageBody]："+ JSON.toJSONString(mqMessageBody));
        try {
            Map<String, Object> header = Maps.newHashMap();
            header.put(MessageConst.PROPERTY_KEYS, logVo.getId());

            rocketMQTemplate.convertAndSend(logVo.getTopicAndTags(), mqMessageBody, header);
        }catch (MessagingException e){
            this.msgException(logVo, mqMessageBody, e);
            throw new BusinessException("MQ消息发送失败");
        }
    }

    /**
     * 批量
     * @param mqMessageBody
     */
    public void convertAndSendBatch(RocketMQMessageBody mqMessageBody){
        //TODO 批量待实现
        return;
    }
    /**
     * 同步发送顺序消费的消息
     * @param mqMessageBody
     */
    public void syncSendOrderly(RocketMQMessageBody mqMessageBody){
        MdmMqMessageLogEs logVo = this.msgLog(mqMessageBody);
        try {
            Map<String, Object> header = Maps.newHashMap();
            header.put(MessageConst.PROPERTY_KEYS, logVo.getId());
            SendResult sendResult = rocketMQTemplate.syncSendOrderly(
                    logVo.getTopicAndTags() // topic
                    , mqMessageBody // message
                    , mqMessageBody.getTag());// 保证相同的tag发送到同一个队列，已实现同一 tag 的消息的顺序消费
        }catch (Exception e){
            log.error("MQ消息发送失败",e);
            this.msgException(logVo, mqMessageBody, e);
            throw new BusinessException("MQ消息发送失败");
        }
    }

    private void msgException(MdmMqMessageLogEs logVo, RocketMQMessageBody mqMessageBody, Exception e){
        log.error("MQ消息发送失败:mqMessageBody = {} >>>", JsonPropertyUtil.toJsonString(mqMessageBody), e);
        logVo.setSendLog(ExceptionUtils.getStackTrace(e));
        if(StringUtils.isBlank(logVo.getSendLog())){
            logVo.setSendLog("MQ消息发送失败");
        }
        logVo.setSendStatus(CrmEnableStatusEnum.DISABLE.getCode());
        redisService.setDays(RedisParam.MQ_MESSAGE+logVo.getId(),logVo, RedisParam.TIME5);
        mdmMqMessageLogRepository.save(logVo);
    }

    private MdmMqMessageLogEs msgLog(RocketMQMessageBody mqMessageBody){
        if(StringUtils.isBlank(mqMessageBody.getTopic())){
            mqMessageBody.setTopic(this.topicDef);
        }
        if(StringUtils.isBlank(mqMessageBody.getToken())){
            mqMessageBody.setToken(UserUtils.getToken());
        }
        MdmMqMessageLogEs logVo = MdmMqMessageLogEs.buildLogVo(mqMessageBody);
        logVo = mdmMqMessageLogRepository.save(logVo);
        mqMessageBody.setId(logVo.getId());
        redisService.setDays(RedisParam.MQ_MESSAGE + logVo.getId(),logVo, RedisParam.TIME5);

        return logVo;
    }




}
