package com.biz.crm.mq.mqlog;


import com.biz.crm.mq.MdmMqMessageLogVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


/**
 *  @author: luoqi
 *  @Date: 2020-9-27 11:06
 *  @version: V1.0
 *  @Description:
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "mdmMqMessageLogFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmMqMessageLogFeign.FallBackClass.class)
public interface MdmMqMessageLogFeign {
    /**
     * 新增
     */
    @PostMapping("/mqmessagelog/save")
    Result<String> save(@RequestBody MdmMqMessageLogVo mdmMqMessageLogVo);

    /**
     * 更新
     */
    @PostMapping("/mqmessagelog/updateById")
    void updateById(@RequestParam("id") String id) ;


    @PostMapping("/mqmessagelog/getbyid")
    Result<MdmMqMessageLogVo> getById(@RequestParam("id") String id);

    @Component
    @Slf4j
    class FallBackClass implements FallbackFactory<MdmMqMessageLogFeign> {
        @Override
        public MdmMqMessageLogFeign create(Throwable throwable) {
            return new MdmMqMessageLogFeign() {
                /**
                 * 更新
                 */
                @Override
                public void updateById(String id) {
                    log.error("更新MQ日志失败:mdmMqMessageLogVo = {} >>>", id, throwable);
                    return ;
                }

                @Override
                public Result<MdmMqMessageLogVo> getById(String id) {
                    log.error("查询MQ日志失败:id = {} >>>", id, throwable);
                    return null;
                }

                /**
                 * 新增
                 * @param mdmMqMessageLogVo
                 */
                @Override
                public Result<String> save(MdmMqMessageLogVo mdmMqMessageLogVo) {
                    log.error("插入MQ日志失败:mdmMqMessageLogVo = {} >>>", JsonPropertyUtil.toJsonString(mdmMqMessageLogVo), throwable);
                    return null;
                }

            };
        }
    }
}
