/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaNoticeEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeFileReqVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReceivingReqVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeRespVo;
import com.biz.crm.notice.mapper.SfaNoticeFileMapper;
import com.biz.crm.notice.mapper.SfaNoticeMapper;
import com.biz.crm.notice.mapper.SfaNoticeReceivingMapper;
import com.biz.crm.notice.model.SfaNoticeEntity;
import com.biz.crm.notice.model.SfaNoticeFileEntity;
import com.biz.crm.notice.model.SfaNoticeReceivingEntity;
import com.biz.crm.notice.service.ISfaNoticeFileService;
import com.biz.crm.notice.service.ISfaNoticeReadService;
import com.biz.crm.notice.service.ISfaNoticeReceivingService;
import com.biz.crm.notice.service.ISfaNoticeService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaNoticeServiceExpandImpl"})
public class SfaNoticeServiceImpl
extends ServiceImpl<SfaNoticeMapper, SfaNoticeEntity>
implements ISfaNoticeService {
    private static final Logger log = LoggerFactory.getLogger(SfaNoticeServiceImpl.class);
    @Resource
    private SfaNoticeMapper sfaNoticeMapper;
    @Resource
    private SfaNoticeFileMapper noticeFileMapper;
    @Resource
    private SfaNoticeReceivingMapper noticeReceivingMapper;
    @Autowired
    private ISfaNoticeFileService iSfaNoticeFileService;
    @Autowired
    private ISfaNoticeReceivingService iSfaNoticeReceivingService;
    @Autowired
    private ISfaNoticeReadService iSfaNoticeReadService;

    @Override
    @CrmLog
    public PageResult<SfaNoticeRespVo> findList(SfaNoticeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaNoticeRespVo> list = this.sfaNoticeMapper.findList((Page<SfaNoticeRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List noticeCodes = list.stream().map(SfaNoticeRespVo::getNoticeCode).collect(Collectors.toList());
            SfaNoticeReadReqVo readReqVo = new SfaNoticeReadReqVo();
            readReqVo.setNoticeCodes(noticeCodes);
            readReqVo.setPageSize(Integer.valueOf(-1));
            List readRespVoList = this.iSfaNoticeReadService.findList(readReqVo).getData();
            Map<String, List<SfaNoticeReadRespVo>> readRespMap = readRespVoList.stream().collect(Collectors.groupingBy(SfaNoticeReadRespVo::getNoticeCode));
            for (SfaNoticeRespVo noticeVo : list) {
                noticeVo.setNoticeOrg(noticeVo.getCreateOrgName());
                noticeVo.setNoticeDate(noticeVo.getCreateDate());
                noticeVo.setNoticeTypeDesc(SfaNoticeEnum.getSfaNotice(noticeVo.getNoticeType()).getCode());
                noticeVo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)noticeVo.getEnableStatus()));
                List<SfaNoticeReadRespVo> noticeReadRespVos = readRespMap.get(noticeVo.getNoticeCode());
                if (noticeReadRespVos != null && noticeReadRespVos.size() > 0) {
                    noticeVo.setVisitNum(Integer.valueOf(noticeReadRespVos.size()));
                    Set readusers = noticeReadRespVos.stream().map(SfaNoticeReadRespVo::getUserName).collect(Collectors.toSet());
                    noticeVo.setReadUserNum(Integer.valueOf(readusers.size()));
                    continue;
                }
                noticeVo.setVisitNum(Integer.valueOf(0));
                noticeVo.setReadUserNum(Integer.valueOf(0));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaNoticeRespVo query(SfaNoticeReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaNoticeRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaNoticeRespVo();
        }
        SfaNoticeRespVo sfaNoticeRespVo = (SfaNoticeRespVo)list.get(0);
        SfaNoticeFileReqVo fileReqVo = new SfaNoticeFileReqVo();
        fileReqVo.setNoticeCode(sfaNoticeRespVo.getNoticeCode());
        fileReqVo.setPageSize(Integer.valueOf(-1));
        List fileRespVos = this.iSfaNoticeFileService.findList(fileReqVo).getData();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)fileRespVos)) {
            sfaNoticeRespVo.setNoticeFileRespVos(fileRespVos);
        }
        SfaNoticeReceivingReqVo receivingReqVo = new SfaNoticeReceivingReqVo();
        receivingReqVo.setNoticeCode(sfaNoticeRespVo.getNoticeCode());
        receivingReqVo.setPageSize(Integer.valueOf(-1));
        List receivingRespVos = this.iSfaNoticeReceivingService.findList(receivingReqVo).getData();
        receivingRespVos.forEach(data -> data.setReceivingType(SfaNoticeEnum.getSfaNotice(data.getReceivingType()).getDesc()));
        sfaNoticeRespVo.setNoticeReceivingRespVos(receivingRespVos);
        return sfaNoticeRespVo;
    }

    public void saveCheck(SfaNoticeReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getNoticeTitle(), (String)"\u8bf7\u8f93\u5165\u516c\u544a\u6807\u9898");
        AssertUtils.isNotEmpty((String)reqVo.getNoticeType(), (String)"\u8bf7\u9009\u62e9\u516c\u544a\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getNoticeContent(), (String)"\u8bf7\u8f93\u5165\u516c\u544a\u5185\u5bb9");
        AssertUtils.isNotEmpty((Collection)reqVo.getNoticeReceivingReqVos(), (String)"\u8bf7\u9009\u62e9\u516c\u544a\u8303\u56f4");
        SimpleDateFormat ymd_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date beginDate = null;
        try {
            beginDate = ymd_hms.parse(reqVo.getBeginDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Date endDate = null;
        try {
            endDate = ymd_hms.parse(reqVo.getEndDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (beginDate.getTime() >= endDate.getTime()) {
            throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u7ed3\u675f\u65f6\u95f4");
        }
        AssertUtils.isNotEmpty((String)reqVo.getNoticeContent(), (String)"\u516c\u544a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaNoticeReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaNoticeEntity entity = (SfaNoticeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaNoticeEntity.class));
        String code = CodeUtil.createCode();
        entity.setNoticeCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
    }

    public void saveData(SfaNoticeReqVo reqVo, SfaNoticeEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getNoticeReceivingReqVos())) {
            List receivingEntityList = reqVo.getNoticeReceivingReqVos().stream().map(o -> {
                SfaNoticeReceivingEntity receivingEntity = new SfaNoticeReceivingEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)receivingEntity));
                receivingEntity.setNoticeCode(entity.getNoticeCode());
                return receivingEntity;
            }).collect(Collectors.toList());
            this.iSfaNoticeReceivingService.saveBatch(receivingEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getNoticeFileReqVos())) {
            List fileEntityList = reqVo.getNoticeFileReqVos().stream().map(o -> {
                SfaNoticeFileEntity fileEntity = new SfaNoticeFileEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fileEntity));
                fileEntity.setNoticeCode(entity.getNoticeCode());
                return fileEntity;
            }).collect(Collectors.toList());
            this.iSfaNoticeFileService.saveBatch(fileEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaNoticeReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaNoticeEntity entity = (SfaNoticeEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u516c\u544a\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaNoticeReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u516c\u544a\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.sfaNoticeMapper.deleteProductsByParams(reqVo);
        List noticeCodes = list.stream().map(SfaNoticeRespVo::getNoticeCode).collect(Collectors.toList());
        reqVo.setNoticeCodes(noticeCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaNoticeReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getNoticeCode()) && CollectionUtil.listEmpty((List)reqVo.getNoticeCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaNoticeFileReqVo sfaNoticeFileReqVo = new SfaNoticeFileReqVo();
        sfaNoticeFileReqVo.setNoticeCode(reqVo.getNoticeCode());
        sfaNoticeFileReqVo.setNoticeCodes(reqVo.getNoticeCodes());
        this.noticeFileMapper.deleteProductsByParams(sfaNoticeFileReqVo);
        SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo = new SfaNoticeReceivingReqVo();
        sfaNoticeReceivingReqVo.setNoticeCode(reqVo.getNoticeCode());
        sfaNoticeReceivingReqVo.setNoticeCodes(reqVo.getNoticeCodes());
        this.noticeReceivingMapper.deleteProductsByParams(sfaNoticeReceivingReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaNoticeReqVo reqVo) {
        List sfaNoticeEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaNoticeEntities = this.sfaNoticeMapper.selectBatchIds(reqVo.getIds())))) {
            sfaNoticeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaNoticeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaNoticeReqVo reqVo) {
        List sfaNoticeEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaNoticeEntities = this.sfaNoticeMapper.selectBatchIds(reqVo.getIds())))) {
            sfaNoticeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaNoticeEntities);
    }
}

