/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitTempPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRangeRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitTempPlanRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitnote.mapper.SfaVisitPlanMapper;
import com.biz.crm.visitnote.mapper.SfaVisitPlanRangeMapper;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitPlanRangeService;
import com.biz.crm.visitnote.service.ISfaVisitTempPlanService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitTempPlanServiceExpandImpl"})
public class SfaVisitTempPlanServiceImpl
extends ServiceImpl<SfaVisitPlanMapper, SfaVisitPlanEntity>
implements ISfaVisitTempPlanService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitTempPlanServiceImpl.class);
    @Resource
    private SfaVisitPlanMapper sfaVisitPlanMapper;
    @Resource
    private SfaVisitPlanRangeMapper sfaVisitPlanRangeMapper;
    @Autowired
    private ISfaVisitPlanRangeService iSfaVisitPlanRangeService;
    @Autowired
    private ISfaVisitPlanInfoService iSfaVisitPlanInfoService;

    @Override
    public PageResult<SfaVisitPlanRangeRespVo> findSfaList(SfaVisitPlanRangeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitPlanRangeRespVo> list = this.sfaVisitPlanRangeMapper.findSfaTempList((Page<SfaVisitPlanRangeRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List clientIds = list.stream().map(SfaVisitPlanRangeRespVo::getClientId).collect(Collectors.toList());
            list.forEach(data -> {
                data.setClientAddress("");
                data.setClientPhone("");
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitTempPlanRespVo> findList(SfaVisitTempPlanReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitTempPlanRespVo> list = this.sfaVisitPlanMapper.findTempList((Page<SfaVisitTempPlanRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List visitPlanCodes = list.stream().map(SfaVisitTempPlanRespVo::getVisitPlanCode).collect(Collectors.toList());
            SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
            sfaVisitPlanRangeReqVo.setVisitPlanCodes(visitPlanCodes);
            sfaVisitPlanRangeReqVo.setPageSize(Integer.valueOf(-1));
            List sfaVisitPlanRangeRespVos = this.iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
            Map<String, List<SfaVisitPlanRangeRespVo>> readRespMap = sfaVisitPlanRangeRespVos.stream().collect(Collectors.groupingBy(SfaVisitPlanRangeRespVo::getVisitPlanCode));
            for (SfaVisitTempPlanRespVo sfaVisitPlanRespVo : list) {
                List<SfaVisitPlanRangeRespVo> visitPlanRangeRespVos = readRespMap.get(sfaVisitPlanRespVo.getVisitPlanCode());
                if (visitPlanRangeRespVos == null || visitPlanRangeRespVos.size() <= 0) continue;
                StringBuffer groupNameBuffer = new StringBuffer();
                StringBuffer groupIdBuffer = new StringBuffer();
                for (SfaVisitPlanRangeRespVo visitPlanRangeRespVo : visitPlanRangeRespVos) {
                    if (groupNameBuffer.length() > 0) {
                        groupNameBuffer.append(",");
                    }
                    if (StringUtils.isNotEmpty((String)visitPlanRangeRespVo.getVisitGroupName())) {
                        groupNameBuffer.append(visitPlanRangeRespVo.getVisitGroupName());
                    }
                    if (groupIdBuffer.length() > 0) {
                        groupIdBuffer.append(",");
                    }
                    if (!StringUtils.isNotEmpty((String)visitPlanRangeRespVo.getVisitGroupId())) continue;
                    groupIdBuffer.append(visitPlanRangeRespVo.getVisitGroupId());
                }
                sfaVisitPlanRespVo.setVisitGroupIds(groupIdBuffer.toString());
                sfaVisitPlanRespVo.setVisitGroupNames(groupNameBuffer.toString());
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitTempPlanRespVo query(SfaVisitTempPlanReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaVisitTempPlanRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitTempPlanRespVo();
        }
        SfaVisitTempPlanRespVo respVo = (SfaVisitTempPlanRespVo)list.get(0);
        SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        sfaVisitPlanRangeReqVo.setVisitPlanCode(respVo.getVisitPlanCode());
        List sfaVisitPlanRangeRespVos = this.iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
        respVo.setSfaVisitPlanRangeRespVos(sfaVisitPlanRangeRespVos);
        return respVo;
    }

    public void saveCheck(SfaVisitTempPlanReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getPlanType(), (String)"\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!SfaVisitEnum.VisitType.GETMAP.containsKey(reqVo.getPlanType())) {
            throw new BusinessException("\u62dc\u8bbf\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u62dc\u8bbf\u7c7b\u578b(\u4e34\u65f6\u62dc\u8bbf\u3001\u8ba1\u5212\u62dc\u8bbf\u3001\u534f\u8bbf)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getRouteType(), (String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a(\u7ebf\u8def\u7ec4\u3001\u7f51\u70b9\u3001\u9891\u7387)");
        if (!SfaVisitEnum.routeTypeEnum.GETMAP.containsKey(reqVo.getRouteType())) {
            throw new BusinessException("\u7ef4\u5ea6\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6(\u7ebf\u8def\u7ec4\u3001\u7f51\u70b9\u3001\u9891\u7387)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserId(), (String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitRealName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosId(), (String)"\u4eba\u5458\u804c\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosName(), (String)"\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgId(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgCode(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgName(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitStartDate(), (String)"\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
        Date beginDate = null;
        try {
            beginDate = ymd.parse(reqVo.getVisitStartDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitEndDate(), (String)"\u5faa\u73af\u7ed3\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Date endDate = null;
        try {
            endDate = ymd.parse(reqVo.getVisitEndDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u5faa\u73af\u7ed3\u7b97\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        if (beginDate.getTime() > endDate.getTime()) {
            throw new BusinessException("\u4e34\u65f6\u62dc\u8bbf\u8ba1\u5212\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5faa\u73af\u7ed3\u7b97\u65e5\u671f");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPlanType()) && SfaVisitEnum.VisitType.assit_type.getVal().equals(reqVo.getPlanType())) {
            AssertUtils.isNotEmpty((String)reqVo.getCvUserId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvUserName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvRealName(), (String)"\u8bf7\u9009\u62e9\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u59d3\u540d");
            AssertUtils.isNotEmpty((String)reqVo.getCvPosId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvPosCode(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvPosName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvOrgId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvOrgCode(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvOrgName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtil.listNotEmpty((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u5236\u5b9a\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = 1;
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo : reqVo.getSfaVisitPlanRangeReqVos()) {
            if (SfaVisitEnum.routeTypeEnum.R1.getVal().equals(reqVo.getRouteType())) {
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getVisitGroupId(), (String)("\u7ebf\u8def\u7ec4" + i + ",\u7ebf\u8def\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getVisitGroupName(), (String)("\u7ebf\u8def\u7ec4" + i + ",\u7ebf\u8def\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            } else {
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientId(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientCode(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientName(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientType(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                if (SfaVisitEnum.routeTypeEnum.R3.getVal().equals(reqVo.getRouteType())) {
                    AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getFirstVisitDate(), (String)("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
                    Date firstVisitDate = null;
                    try {
                        firstVisitDate = ymd.parse(sfaVisitPlanRangeReqVo.getFirstVisitDate());
                    }
                    catch (Exception e) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                    }
                    if (beginDate.getTime() > firstVisitDate.getTime() || firstVisitDate.getTime() > endDate.getTime()) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u4e0d\u5728\u5faa\u73af\u65e5\u671f\u5185");
                    }
                    if (null == sfaVisitPlanRangeReqVo.getVisitFrequency()) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    try {
                        String regex = "^[1-9]+[0-9]*$";
                        Pattern p = Pattern.compile(regex);
                        Matcher m = p.matcher(sfaVisitPlanRangeReqVo.getVisitFrequency().toString());
                        if (!m.find()) {
                            System.out.println("falsss");
                            throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                    }
                    if (sfaVisitPlanRangeReqVo.getVisitFrequency() <= 0) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                    }
                }
            }
            ++i;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitTempPlanReqVo reqVo) {
        reqVo.setVisitStartDate(DateUtil.formatDate((Date)new Date()));
        reqVo.setVisitEndDate(DateUtil.formatDate((Date)new Date()));
        this.saveCheck(reqVo);
        SfaVisitPlanEntity entity = (SfaVisitPlanEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanEntity.class));
        String code = CodeUtil.createCode();
        entity.setVisitPlanCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
        SfaVisitPlanInfoReqVo planInfoReqVo = (SfaVisitPlanInfoReqVo)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanInfoReqVo.class);
        planInfoReqVo.setVisitDate(entity.getVisitStartDate());
        planInfoReqVo.setVisitType(entity.getPlanType());
        reqVo.getSfaVisitPlanRangeReqVos().forEach(data -> {
            planInfoReqVo.setClientId(data.getClientId());
            planInfoReqVo.setClientCode(data.getClientCode());
            planInfoReqVo.setClientName(data.getClientName());
            planInfoReqVo.setClientType(data.getClientType());
            planInfoReqVo.setClientAddress(data.getClientAddress());
            planInfoReqVo.setClientPhone(data.getClientPhone());
            planInfoReqVo.setLongitude(data.getLongitude());
            planInfoReqVo.setLatitude(data.getLatitude());
            this.iSfaVisitPlanInfoService.save(planInfoReqVo);
        });
    }

    public void saveData(SfaVisitTempPlanReqVo reqVo, SfaVisitPlanEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            List visitPlanRangeEntities = reqVo.getSfaVisitPlanRangeReqVos().stream().map(o -> {
                SfaVisitPlanRangeEntity receivingEntity = new SfaVisitPlanRangeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)receivingEntity));
                receivingEntity.setVisitPlanCode(entity.getVisitPlanCode());
                return receivingEntity;
            }).collect(Collectors.toList());
            this.iSfaVisitPlanRangeService.saveBatch(visitPlanRangeEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitTempPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanEntity entity = (SfaVisitPlanEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        reqVo.setVisitPlanCode(entity.getVisitPlanCode());
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitTempPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.sfaVisitPlanMapper.deleteProductsByParamsTemp(reqVo);
        List visitPlanCodes = list.stream().map(SfaVisitTempPlanRespVo::getVisitPlanCode).collect(Collectors.toList());
        reqVo.setVisitPlanCodes(visitPlanCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaVisitTempPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitPlanCode()) && CollectionUtil.listEmpty((List)reqVo.getVisitPlanCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanRangeReqVo visitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        visitPlanRangeReqVo.setVisitPlanCode(reqVo.getVisitPlanCode());
        visitPlanRangeReqVo.setVisitPlanCodes(reqVo.getVisitPlanCodes());
        this.sfaVisitPlanRangeMapper.deleteProductsByParams(visitPlanRangeReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitTempPlanReqVo reqVo) {
        List sfaVisitPlanEntities;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectBatchIds(reqVo.getIds())))) {
            sfaVisitPlanEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitTempPlanReqVo reqVo) {
        List sfaVisitPlanEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectBatchIds(reqVo.getIds())))) {
            sfaVisitPlanEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }
}

