/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.model.SfaLeaveEntity;
import com.biz.crm.worksign.service.ISfaLeaveService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaLeaveServiceExpandImpl"})
public class SfaLeaveServiceImpl
extends ServiceImpl<SfaLeaveMapper, SfaLeaveEntity>
implements ISfaLeaveService {
    private static final Logger log = LoggerFactory.getLogger(SfaLeaveServiceImpl.class);
    @Resource
    private SfaLeaveMapper sfaLeaveMapper;

    @Override
    public PageResult<SfaLeaveRespVo> findList(SfaLeaveReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveRespVo> list = this.sfaLeaveMapper.findList((Page<SfaLeaveRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaLeaveRespVo query(SfaLeaveReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaLeaveEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaLeaveReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaLeaveReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaLeaveReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result goApplyLeave(SfaLeaveReqVo sfaLeaveReqVo) {
        Result result = new Result();
        Date currentTime = new Date();
        String currentDateStr = DateUtil.date_sdf.format(currentTime);
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaLeaveReqVo.getLeaveType())) {
            result.error500("\u8bf7\u5047\u7c7b\u578b\u5fc5\u4f20");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaLeaveReqVo.getBeginTime())) {
            result.error500("\u5f00\u59cb\u65f6\u95f4\u5fc5\u586b");
            return result;
        }
        Date beginTime = null;
        try {
            beginTime = DateUtil.time_ymdh.parse(sfaLeaveReqVo.getBeginTime());
        }
        catch (Exception e) {
            result.error500("\u5f00\u59cb\u65f6\u95f4\u586b\u5199\u683c\u5f0f\u6709\u8bef(yyyy-MM-dd HH)");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaLeaveReqVo.getEndTime())) {
            result.error500("\u7ed3\u675f\u65f6\u95f4\u5fc5\u586b");
            return result;
        }
        Date endTime = null;
        try {
            endTime = DateUtil.time_ymdh.parse(sfaLeaveReqVo.getEndTime());
        }
        catch (Exception e) {
            result.error500("\u7ed3\u675f\u65f6\u95f4\u586b\u5199\u683c\u5f0f\u6709\u8bef(yyyy-MM-dd HH)");
            return result;
        }
        if (beginTime.getTime() >= endTime.getTime()) {
            result.error500("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaLeaveReqVo.getLeaveReason())) {
            result.error500("\u8bf7\u5047\u539f\u56e0\u5fc5\u4f20");
            return result;
        }
        sfaLeaveReqVo.setApplicationDate(currentDateStr);
        sfaLeaveReqVo.setUserName(userRedis.getUsername());
        sfaLeaveReqVo.setRealName(userRedis.getRealname());
        sfaLeaveReqVo.setPosCode(userRedis.getPoscode());
        sfaLeaveReqVo.setPosName(userRedis.getPosname());
        sfaLeaveReqVo.setOrgCode(userRedis.getOrgcode());
        sfaLeaveReqVo.setOrgName(userRedis.getOrgname());
        sfaLeaveReqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)CrmBeanUtil.copy((Object)sfaLeaveReqVo, SfaLeaveEntity.class));
        this.save((Object)entity);
        return result.ok();
    }
}

