/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.imageutil;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static void main(String[] args) {
        ImageUtils.waterPress("/Applications/tools/1.jpeg", "/Applications/tools/12.jpeg ", Color.gray, 20, "\u5929\u5e9c\u8f6f\u4ef6\u56edC2\u533a||2020-12-21 12:31:33||\u5ba2\u6237\u540d\u79f0");
    }

    public static void waterPress(String srcImgPath, String outImgPath, Color markContentColor, int fontSize, String waterMarkContent) {
        try {
            String[] waterMarkContents = waterMarkContent.split("\\|\\|");
            File srcImgFile = new File(srcImgPath);
            BufferedImage srcImg = ImageIO.read(srcImgFile);
            int srcImgWidth = ((Image)srcImg).getWidth(null);
            int srcImgHeight = ((Image)srcImg).getHeight(null);
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
            Font font = new Font("\u5b8b\u4f53", 2, fontSize);
            g.setColor(markContentColor);
            g.setFont(font);
            int contentLength = waterMarkContents.length;
            int maxLength = 0;
            for (int i = 0; i < contentLength; ++i) {
                int fontlen = ImageUtils.getWatermarkLength(waterMarkContents[i], g);
                if (maxLength >= fontlen) continue;
                maxLength = fontlen;
            }
            for (int j = 0; j < contentLength; ++j) {
                waterMarkContent = waterMarkContents[j];
                int tempX = 10;
                int tempY = fontSize;
                int tempCharLen = 0;
                int tempLineLen = 0;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < waterMarkContent.length(); ++i) {
                    char tempChar = waterMarkContent.charAt(i);
                    tempCharLen = ImageUtils.getCharLen(tempChar, g);
                    if ((tempLineLen += tempCharLen) >= srcImgWidth) {
                        g.drawString(sb.toString(), tempX, tempY);
                        sb.delete(0, sb.length());
                        tempLineLen = 0;
                    }
                    sb.append(tempChar);
                }
                g.drawString(sb.toString(), srcImgWidth - maxLength, srcImgHeight - (contentLength - j - 1) * tempY);
            }
            g.dispose();
            FileOutputStream outImgStream = new FileOutputStream(outImgPath);
            ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
            outImgStream.flush();
            outImgStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getCharLen(char c, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charWidth(c);
    }

    public static int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }
}

