/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderMapper;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepOrderServiceExpandImpl"})
public class SfaVisitStepOrderServiceImpl
extends ServiceImpl<SfaVisitStepOrderMapper, SfaVisitStepOrderEntity>
implements ISfaVisitStepOrderService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderServiceImpl.class);
    @Resource
    private SfaVisitStepOrderMapper sfaVisitStepOrderMapper;
    @Autowired
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;

    @Override
    public PageResult<SfaVisitStepOrderRespVo> findList(SfaVisitStepOrderReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepOrderRespVo> list = this.sfaVisitStepOrderMapper.findList((Page<SfaVisitStepOrderRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepOrderRespVo query(SfaVisitStepOrderReqVo reqVo) {
        SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        SfaVisitStepOrderRespVo sfaVisitStepOrderRespVo = (SfaVisitStepOrderRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepOrderEntity), SfaVisitStepOrderRespVo.class);
        List<SfaVisitStepOrderItemRespVo> sfaVisitStepOrderItemRespVos = this.sfaVisitStepOrderItemService.findList(reqVo.getId());
        sfaVisitStepOrderRespVo.setSfaVisitStepOrderItemRespVos(sfaVisitStepOrderItemRespVos);
        return sfaVisitStepOrderRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepOrderReqVo reqVo) {
        SfaVisitStepOrderEntity entity = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepOrderEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
        this.sfaVisitStepOrderItemService.batchSave(reqVo.getSfaVisitStepOrderItems());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepOrderReqVo reqVo) {
        SfaVisitStepOrderEntity entity = (SfaVisitStepOrderEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        entity = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepOrderEntity.class));
        this.updateById((Object)entity);
        this.sfaVisitStepOrderItemService.deleteByOrderId(reqVo.getId());
        this.sfaVisitStepOrderItemService.batchSave(reqVo.getSfaVisitStepOrderItems());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }
}

