/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.worksign.mapper.SfaLeaveCancelMapper;
import com.biz.crm.worksign.model.SfaLeaveCancelEntity;
import com.biz.crm.worksign.service.ISfaLeaveCancelService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaLeaveCancelServiceImpl"})
public class SfaLeaveCancelServiceImpl
extends ServiceImpl<SfaLeaveCancelMapper, SfaLeaveCancelEntity>
implements ISfaLeaveCancelService {
    private static final Logger log = LoggerFactory.getLogger(SfaLeaveCancelServiceImpl.class);
    @Resource
    private SfaLeaveCancelMapper mapper;

    @Override
    public List<SfaLeaveCancelRespVo> findList(SfaLeaveCancelReqVo reqVo) {
        List<SfaLeaveCancelRespVo> list = this.mapper.findList(reqVo);
        if (list != null) {
            list.forEach(vo -> vo.setTimeInfoList(JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class)));
        }
        return list;
    }

    @Override
    public void save(SfaLeaveCancelReqVo reqVo) {
        List<SfaLeaveCancelRespVo> list = this.findList(new SfaLeaveCancelReqVo(reqVo.getLeaveId()));
        this.verifyDateRepeat(list, reqVo.getBeginTime(), reqVo.getEndTime(), reqVo.getTimeInfoList());
        SfaLeaveCancelEntity entity = (SfaLeaveCancelEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaLeaveCancelEntity.class));
        entity.setTimeInfoListJson(JSON.toJSONString((Object)reqVo.getTimeInfoList()));
        this.save((Object)entity);
    }

    @Override
    public void verifyDateRepeat(List<SfaLeaveCancelRespVo> list, String beginTime, String endTime, List<SfaApplyTimeInfoReqVo> timeInfoList) {
        if (list != null && list.size() > 0) {
            list.forEach(vo -> SfaSignUtils.verifyDateRepeat((String)beginTime, (String)endTime, (String)vo.getBeginTime(), (String)vo.getEndTime(), (List)timeInfoList, (List)vo.getTimeInfoList()));
        }
    }
}

