/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaTravelMapper;
import com.biz.crm.worksign.model.SfaTravelEntity;
import com.biz.crm.worksign.model.SfaTravelUserEntity;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.biz.crm.worksign.service.ISfaTravelUserService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaTravelServiceExpandImpl"})
public class SfaTravelServiceImpl
extends ServiceImpl<SfaTravelMapper, SfaTravelEntity>
implements ISfaTravelService {
    private static final Logger log = LoggerFactory.getLogger(SfaTravelServiceImpl.class);
    @Resource
    private SfaTravelMapper sfaTravelMapper;
    @Autowired
    private ISfaTravelUserService sfaTravelUserService;

    @Override
    public PageResult<SfaTravelRespVo> findList(SfaTravelReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaTravelRespVo> list = this.sfaTravelMapper.findList((Page<SfaTravelRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaTravelRespVo query(SfaTravelReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaTravelReqVo reqVo) {
        SfaTravelEntity entity = (SfaTravelEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaTravelEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaTravelReqVo reqVo) {
        SfaTravelEntity entity = (SfaTravelEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaTravelReqVo reqVo) {
        List sfaTravelEntities = this.sfaTravelMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaTravelEntities)) {
            sfaTravelEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaTravelEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaTravelReqVo reqVo) {
        List sfaTravelEntities = this.sfaTravelMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaTravelEntities)) {
            sfaTravelEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaTravelEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaTravelReqVo reqVo) {
        List sfaTravelEntities = this.sfaTravelMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaTravelEntities)) {
            sfaTravelEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaTravelEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result goApplyTravel(SfaTravelReqVo sfaTravelReqVo) {
        Result result = new Result();
        Date currentTime = new Date();
        String currentDateStr = DateUtil.date_sdf.format(currentTime);
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        Date beginTime = null;
        try {
            beginTime = DateUtil.date_sdf.parse(sfaTravelReqVo.getBeginTime());
        }
        catch (Exception e) {
            result.error500("\u5f00\u59cb\u65f6\u95f4\u586b\u5199\u683c\u5f0f\u6709\u8bef(yyyy-MM-dd)");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaTravelReqVo.getEndTime())) {
            result.error500("\u7ed3\u675f\u65f6\u95f4\u5fc5\u586b");
            return result;
        }
        Date endTime = null;
        try {
            endTime = DateUtil.date_sdf.parse(sfaTravelReqVo.getEndTime());
        }
        catch (Exception e) {
            result.error500("\u7ed3\u675f\u65f6\u95f4\u586b\u5199\u683c\u5f0f\u6709\u8bef(yyyy-MM-dd)");
            return result;
        }
        if (beginTime.getTime() >= endTime.getTime()) {
            result.error500("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaTravelReqVo.getAddress())) {
            result.error500("\u51fa\u5dee\u5730\u70b9\u5fc5\u586b");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaTravelReqVo.getTravelObjective())) {
            result.error500("\u51fa\u5dee\u76ee\u7684\u5fc5\u586b");
            return result;
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)sfaTravelReqVo.getSfaTravelUserReqVos())) {
            result.error500("\u8bf7\u9009\u62e9\u51fa\u5dee\u4eba\u5458");
            return result;
        }
        sfaTravelReqVo.setApplicationDate(currentDateStr);
        sfaTravelReqVo.setApplyUserName(userRedis.getUsername());
        sfaTravelReqVo.setApplyRealName(userRedis.getRealname());
        sfaTravelReqVo.setApplyPosCode(userRedis.getPoscode());
        sfaTravelReqVo.setApplyPosName(userRedis.getPosname());
        sfaTravelReqVo.setApplyOrgCode(userRedis.getOrgcode());
        sfaTravelReqVo.setApplyOrgName(userRedis.getOrgname());
        sfaTravelReqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        SfaTravelEntity entity = (SfaTravelEntity)((Object)CrmBeanUtil.copy((Object)sfaTravelReqVo, SfaTravelEntity.class));
        this.save((Object)entity);
        List travelUserList = sfaTravelReqVo.getSfaTravelUserReqVos().stream().map(o -> {
            SfaTravelUserEntity travelUserEntity = new SfaTravelUserEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)travelUserEntity));
            travelUserEntity.setTravelId(entity.getId());
            return travelUserEntity;
        }).collect(Collectors.toList());
        this.sfaTravelUserService.saveBatch(travelUserList);
        return result.ok();
    }
}

