/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.freesignconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignTypeMapper;
import com.biz.crm.freesignconfig.model.SfaFreesignSignTypeEntity;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignTypeService;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignTypeReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignTypeRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaFreesignSignTypeServiceExpandImpl"})
public class SfaFreesignSignTypeServiceImpl
extends ServiceImpl<SfaFreesignSignTypeMapper, SfaFreesignSignTypeEntity>
implements ISfaFreesignSignTypeService {
    private static final Logger log = LoggerFactory.getLogger(SfaFreesignSignTypeServiceImpl.class);
    @Resource
    private SfaFreesignSignTypeMapper sfaFreesignSignTypeMapper;

    @Override
    @CrmLog
    public PageResult<SfaFreesignSignTypeRespVo> findList(SfaFreesignSignTypeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaFreesignSignTypeRespVo> list = this.sfaFreesignSignTypeMapper.findList((Page<SfaFreesignSignTypeRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaFreesignSignTypeRespVo query(SfaFreesignSignTypeReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaFreesignSignTypeRespVo();
        }
        SfaFreesignSignTypeRespVo sfaFreesignSignTypeRespVo = (SfaFreesignSignTypeRespVo)list.get(0);
        return sfaFreesignSignTypeRespVo;
    }

    public void saveCheck(SfaFreesignSignTypeReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getOrderNumber(), (String)"\u8bf7\u8f93\u5165\u5e8f\u53f7");
        AssertUtils.isNotEmpty((String)reqVo.getSignTypeName(), (String)"\u8bf7\u8f93\u5165\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getPhotoReq(), (String)"\u8bf7\u9009\u62e9\u62cd\u7167\u8981\u6c42");
        AssertUtils.isNotEmpty((String)reqVo.getTimeReq(), (String)"\u8bf7\u9009\u62e9\u65f6\u95f4\u8981\u6c42");
        if ("1".equals(reqVo.getTimeReq())) {
            SimpleDateFormat hms = new SimpleDateFormat("HH:mm:ss");
            AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Date beginDate = null;
            try {
                beginDate = hms.parse(reqVo.getBeginDate());
            }
            catch (Exception e) {
                throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Date endDate = null;
            try {
                endDate = hms.parse(reqVo.getEndDate());
            }
            catch (Exception e) {
                throw new BusinessException("\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            if (beginDate.getTime() >= endDate.getTime()) {
                throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
            }
        }
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(SfaFreesignSignTypeReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaFreesignSignTypeEntity::getOrderNumber, (Object)reqVo.getOrderNumber());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        SfaFreesignSignTypeEntity entity = (SfaFreesignSignTypeEntity)((Object)this.sfaFreesignSignTypeMapper.selectOne((Wrapper)wrapper));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u6253\u5361\u7c7b\u578b\u6570\u636e\u5e8f\u53f7\u91cd\u590d,\u8bf7\u68c0\u67e5");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaFreesignSignTypeReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaFreesignSignTypeEntity entity = (SfaFreesignSignTypeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaFreesignSignTypeEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaFreesignSignTypeReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaFreesignSignTypeEntity entity = (SfaFreesignSignTypeEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u6253\u5361\u7c7b\u578b\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaFreesignSignTypeReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sfaFreesignSignTypeMapper.deleteProductsByParams(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaFreesignSignTypeReqVo reqVo) {
        List sfaFreesignSignTypeEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaFreesignSignTypeEntities = this.sfaFreesignSignTypeMapper.selectBatchIds(reqVo.getIds())))) {
            sfaFreesignSignTypeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaFreesignSignTypeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaFreesignSignTypeReqVo reqVo) {
        List sfaFreesignSignTypeEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaFreesignSignTypeEntities = this.sfaFreesignSignTypeMapper.selectBatchIds(reqVo.getIds())))) {
            sfaFreesignSignTypeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaFreesignSignTypeEntities);
    }
}

