/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStoreCheckReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStoreCheckRespVo;
import com.biz.crm.picture.mapper.SfaVisitPictureMapper;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import com.biz.crm.visitstep.mapper.SfaVisitStepStoreCheckMapper;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepStoreCheckServiceExpandImpl"})
public class SfaVisitStepStoreCheckServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepStoreCheckMapper, SfaVisitStepStoreCheckEntity>
implements ISfaVisitStepStoreCheckService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStoreCheckServiceImpl.class);
    @Resource
    private SfaVisitStepStoreCheckMapper sfaVisitStepStoreCheckMapper;
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    private SfaVisitPictureMapper sfaVisitPictureMapper;
    @Resource
    private ISfaVisitPictureService sfaVisitPictureService;

    @Override
    public PageResult<SfaVisitStepStoreCheckRespVo> findList(SfaVisitStepStoreCheckReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepStoreCheckRespVo> list = this.sfaVisitStepStoreCheckMapper.findList((Page<SfaVisitStepStoreCheckRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitStepStoreCheckRespVo> findStoreCheckReportList(SfaVisitStepStoreCheckReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepStoreCheckRespVo> list = this.sfaVisitStepStoreCheckMapper.findList((Page<SfaVisitStepStoreCheckRespVo>)page, reqVo);
        Map cusType = DictUtil.getDictValueMapsByCodes((String)"sfacusType");
        list.forEach(data -> data.setClientTypeName((String)cusType.get(data.getClientType())));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitStepStoreCheckRespVo> findWorkDailyStoreCheckList(SfaVisitStepStoreCheckReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        if (StringUtils.isEmpty((String)reqVo.getUserName())) {
            reqVo.setUserName(UserUtils.getUser().getUsername());
        }
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepStoreCheckRespVo> list = this.sfaVisitStepStoreCheckMapper.findList((Page<SfaVisitStepStoreCheckRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepStoreCheckRespVo queryWorkStoreCheckDetail(String id) {
        SfaVisitStepStoreCheckEntity sfaVisitStepStoreCheckEntity = (SfaVisitStepStoreCheckEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).isNull(SfaVisitStepStoreCheckEntity::getVisitId)).one());
        if (sfaVisitStepStoreCheckEntity == null) {
            throw new BusinessException("\u67e5\u8be2\u5e97\u9762\u68c0\u67e5\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
        }
        SfaVisitStepStoreCheckRespVo sfaVisitStepStoreCheckRespVo = (SfaVisitStepStoreCheckRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepStoreCheckEntity), SfaVisitStepStoreCheckRespVo.class);
        String[] checkTypeList = sfaVisitStepStoreCheckRespVo.getCheckType().split(",");
        String businessId = sfaVisitStepStoreCheckRespVo.getId();
        for (int i = 0; i < checkTypeList.length; ++i) {
            String checkType = checkTypeList[i];
            List sfaVisitPictureEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getPicType, (Object)checkType)).eq(SfaVisitPictureEntity::getBusinessId, (Object)businessId)).list();
            List sfaVisitPictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntities, SfaVisitPictureRespVo.class);
            if (checkType.equals(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getVal())) {
                sfaVisitStepStoreCheckRespVo.setRegularShelfDisplayList(sfaVisitPictureRespVos);
            }
            if (checkType.equals(SfaVisitEnum.checkStoreType.PRICE.getVal())) {
                sfaVisitStepStoreCheckRespVo.setPriceList(sfaVisitPictureRespVos);
            }
            if (!checkType.equals(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getVal())) continue;
            sfaVisitStepStoreCheckRespVo.setMaterialDisplayList(sfaVisitPictureRespVos);
        }
        Map cusType = DictUtil.getDictValueMapsByCodes((String)"sfacusType");
        sfaVisitStepStoreCheckRespVo.setClientTypeName((String)cusType.get(sfaVisitStepStoreCheckRespVo.getClientType()));
        return sfaVisitStepStoreCheckRespVo;
    }

    @Override
    public SfaVisitStepStoreCheckRespVo query(SfaVisitStepStoreCheckReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepStoreCheckReqVo reqVo) {
        this.checkParam(reqVo);
        StringBuilder checkType = new StringBuilder();
        StringBuilder checkTypeDesc = new StringBuilder();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRegularShelfDisplayList())) {
            checkType.append(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getVal());
            checkTypeDesc.append(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getDesc());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getMaterialDisplayList())) {
            if (checkType.length() > 0 && checkTypeDesc.length() > 0) {
                checkType.append(",");
                checkTypeDesc.append(",");
            }
            checkType.append(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getVal());
            checkTypeDesc.append(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getDesc());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPriceList())) {
            if (checkType.length() > 0 && checkTypeDesc.length() > 0) {
                checkType.append(",");
                checkTypeDesc.append(",");
            }
            checkType.append(SfaVisitEnum.checkStoreType.PRICE.getVal());
            checkTypeDesc.append(SfaVisitEnum.checkStoreType.PRICE.getDesc());
        }
        if (checkType.length() > 0 && checkType != null && checkTypeDesc.length() > 0 && checkTypeDesc != null) {
            reqVo.setCheckType(checkType.toString());
            reqVo.setCheckTypeDesc(checkTypeDesc.toString());
        }
        SfaVisitStepStoreCheckEntity storeCheckEntity = (SfaVisitStepStoreCheckEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepStoreCheckEntity.class));
        this.save((Object)storeCheckEntity);
        String id = storeCheckEntity.getId();
        ArrayList sfaVisitPictureEntities = new ArrayList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRegularShelfDisplayList())) {
            reqVo.getRegularShelfDisplayList().forEach(data -> {
                SfaVisitPictureEntity sfaVisitPictureEntity = (SfaVisitPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaVisitPictureEntity.class)));
                if (StringUtils.isNotEmpty((String)reqVo.getVisitId())) {
                    sfaVisitPictureEntity.setVisitId(reqVo.getVisitId());
                }
                sfaVisitPictureEntity.setPicType(SfaVisitEnum.visitPicType.REGULAR_SHELF_DISPLAY.getVal());
                sfaVisitPictureEntity.setBusinessId(id);
                sfaVisitPictureEntities.add(sfaVisitPictureEntity);
            });
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getMaterialDisplayList())) {
            reqVo.getMaterialDisplayList().forEach(data -> {
                SfaVisitPictureEntity sfaVisitPictureEntity = (SfaVisitPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaVisitPictureEntity.class)));
                if (StringUtils.isNotEmpty((String)reqVo.getVisitId())) {
                    sfaVisitPictureEntity.setVisitId(reqVo.getVisitId());
                }
                sfaVisitPictureEntity.setPicType(SfaVisitEnum.visitPicType.MATERIAL_DISPLAY.getVal());
                sfaVisitPictureEntity.setBusinessId(id);
                sfaVisitPictureEntities.add(sfaVisitPictureEntity);
            });
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPriceList())) {
            reqVo.getPriceList().forEach(data -> {
                SfaVisitPictureEntity sfaVisitPictureEntity = (SfaVisitPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaVisitPictureEntity.class)));
                if (StringUtils.isNotEmpty((String)reqVo.getVisitId())) {
                    sfaVisitPictureEntity.setVisitId(reqVo.getVisitId());
                }
                sfaVisitPictureEntity.setPicType(SfaVisitEnum.visitPicType.PRICE.getVal());
                sfaVisitPictureEntity.setBusinessId(id);
                sfaVisitPictureEntities.add(sfaVisitPictureEntity);
            });
        }
        this.sfaVisitPictureService.saveBatch(sfaVisitPictureEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveVisitStepStoreCheck(SfaVisitStepStoreCheckReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitId(), (String)"\u62dc\u8bbfid\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseIdEntity::getId, (Object)reqVo.getVisitId());
        SfaVisitDealerDetailEntity dealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)this.sfaVisitDealerDetailMapper.selectOne((Wrapper)queryWrapper));
        if (dealerDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u660e\u7ec6\u6570\u636e\u4fe1\u606f");
        }
        reqVo.setClientId(dealerDetailEntity.getClientId());
        reqVo.setClientType(dealerDetailEntity.getClientType());
        reqVo.setClientName(dealerDetailEntity.getClientName());
        reqVo.setClientCode(dealerDetailEntity.getClientCode());
        SfaVisitStepStoreCheckEntity storeCheckEntity = (SfaVisitStepStoreCheckEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStoreCheckEntity::getVisitId, (Object)reqVo.getVisitId())).one());
        if (storeCheckEntity != null) {
            this.removeById((Serializable)((Object)storeCheckEntity.getId()));
            LambdaQueryWrapper picQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaVisitPictureEntity::getBusinessId, (Object)storeCheckEntity.getId());
            this.sfaVisitPictureMapper.delete((Wrapper)picQueryWrapper);
        }
        this.save(reqVo);
    }

    @Override
    public SfaVisitStepStoreCheckRespVo findVisitStoreCheckByVisitId(String visitId) {
        AssertUtils.isNotEmpty((String)visitId, (String)"\u62dc\u8bbfid\u4e3a\u7a7a");
        SfaVisitStepStoreCheckEntity stepStoreCheckEntity = (SfaVisitStepStoreCheckEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStoreCheckEntity::getVisitId, (Object)visitId)).one());
        if (null == stepStoreCheckEntity) {
            SfaVisitStepStoreCheckRespVo storeCheckRespVo = new SfaVisitStepStoreCheckRespVo();
            ArrayList tempList = Lists.newArrayList();
            storeCheckRespVo.setRegularShelfDisplayList((List)tempList);
            storeCheckRespVo.setMaterialDisplayList((List)tempList);
            storeCheckRespVo.setPriceList((List)tempList);
            return storeCheckRespVo;
        }
        SfaVisitStepStoreCheckRespVo storeCheckRespVo = (SfaVisitStepStoreCheckRespVo)CrmBeanUtil.copy((Object)((Object)stepStoreCheckEntity), SfaVisitStepStoreCheckRespVo.class);
        Map<String, List<SfaVisitPictureRespVo>> sfaVisitPictureRespVoMap = CrmBeanUtil.copyList((List)((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)stepStoreCheckEntity.getId())).list(), SfaVisitPictureRespVo.class).stream().collect(Collectors.groupingBy(SfaVisitPictureRespVo::getPicType));
        ArrayList emptyList = Lists.newArrayList();
        String visitPicTypeVal = SfaVisitEnum.visitPicType.REGULAR_SHELF_DISPLAY.getVal();
        ArrayList pictureRespVos = sfaVisitPictureRespVoMap.containsKey(visitPicTypeVal) ? sfaVisitPictureRespVoMap.get(visitPicTypeVal) : emptyList;
        storeCheckRespVo.setRegularShelfDisplayList((List)pictureRespVos);
        visitPicTypeVal = SfaVisitEnum.visitPicType.MATERIAL_DISPLAY.getVal();
        pictureRespVos = sfaVisitPictureRespVoMap.containsKey(visitPicTypeVal) ? sfaVisitPictureRespVoMap.get(visitPicTypeVal) : emptyList;
        storeCheckRespVo.setMaterialDisplayList((List)pictureRespVos);
        visitPicTypeVal = SfaVisitEnum.visitPicType.PRICE.getVal();
        pictureRespVos = sfaVisitPictureRespVoMap.containsKey(visitPicTypeVal) ? sfaVisitPictureRespVoMap.get(visitPicTypeVal) : emptyList;
        storeCheckRespVo.setPriceList((List)pictureRespVos);
        return storeCheckRespVo;
    }

    private void checkParam(SfaVisitStepStoreCheckReqVo reqVo) {
        String now = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        UserRedis userRedis = UserUtils.getUser();
        AssertUtils.isNotEmpty((String)reqVo.getLongitude(), (String)"\u7eac\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLatitude(), (String)"\u7ecf\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientName(), (String)"\u7f51\u70b9\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientId(), (String)"\u7f51\u70b9id\u4e3a\u7a7a");
        if (!(CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getMaterialDisplayList()) || CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRegularShelfDisplayList()) || CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPriceList()))) {
            throw new BusinessException("\u56fe\u7247\u5217\u8868\u4e3a\u7a7a");
        }
        reqVo.setUserName(userRedis.getUsername());
        reqVo.setRealName(userRedis.getRealname());
        reqVo.setPosCode(userRedis.getPoscode());
        reqVo.setPosName(userRedis.getPosname());
        reqVo.setOrgCode(userRedis.getOrgcode());
        reqVo.setOrgName(userRedis.getOrgname());
        reqVo.setCheckTime(now);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepStoreCheckReqVo reqVo) {
        SfaVisitStepStoreCheckEntity entity = (SfaVisitStepStoreCheckEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepStoreCheckReqVo reqVo) {
        List sfaVisitStepStoreCheckEntities = this.sfaVisitStepStoreCheckMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStoreCheckEntities)) {
            sfaVisitStepStoreCheckEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStoreCheckEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepStoreCheckReqVo reqVo) {
        List sfaVisitStepStoreCheckEntities = this.sfaVisitStepStoreCheckMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStoreCheckEntities)) {
            sfaVisitStepStoreCheckEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStoreCheckEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepStoreCheckReqVo reqVo) {
        List sfaVisitStepStoreCheckEntities = this.sfaVisitStepStoreCheckMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStoreCheckEntities)) {
            sfaVisitStepStoreCheckEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStoreCheckEntities);
    }
}

