/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignTimeRespVo;
import com.biz.crm.util.AssertDateTimeUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksignrule.mapper.SfaWorkSignTimeMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSignTimeServiceExpandImpl"})
public class SfaWorkSignTimeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSignTimeMapper, SfaWorkSignTimeEntity>
implements ISfaWorkSignTimeService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignTimeServiceImpl.class);
    @Resource
    private SfaWorkSignTimeMapper sfaWorkSignTimeMapper;

    @Override
    @CrmLog
    public PageResult<SfaWorkSignTimeRespVo> findList(SfaWorkSignTimeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignTimeRespVo> list = this.sfaWorkSignTimeMapper.findList((Page<SfaWorkSignTimeRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public Map<String, List<SfaWorkSignTimeEntity>> selectMappingByRuleCodes(Set<String> ruleCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(ruleCodes)) {
            return Maps.newHashMap();
        }
        return this.sfaWorkSignTimeMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaWorkSignTimeEntity.class).in(SfaWorkSignTimeEntity::getRuleCode, ruleCodes)).stream().collect(Collectors.groupingBy(SfaWorkSignTimeEntity::getRuleCode));
    }

    @Override
    @CrmLog
    public SfaWorkSignTimeRespVo query(SfaWorkSignTimeReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaWorkSignTimeRespVo();
        }
        SfaWorkSignTimeRespVo sfaWorkSignTimeRespVo = (SfaWorkSignTimeRespVo)list.get(0);
        return sfaWorkSignTimeRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaWorkSignTimeReqVo reqVo) {
        SfaWorkSignTimeEntity entity = (SfaWorkSignTimeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignTimeEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaWorkSignTimeReqVo reqVo) {
        SfaWorkSignTimeEntity entity = (SfaWorkSignTimeEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaWorkSignTimeReqVo reqVo) {
        List sfaWorkSignTimeEntities = this.sfaWorkSignTimeMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignTimeEntities)) {
            sfaWorkSignTimeEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignTimeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaWorkSignTimeReqVo reqVo) {
        List sfaWorkSignTimeEntities = this.sfaWorkSignTimeMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignTimeEntities)) {
            sfaWorkSignTimeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignTimeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaWorkSignTimeReqVo reqVo) {
        List sfaWorkSignTimeEntities = this.sfaWorkSignTimeMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignTimeEntities)) {
            sfaWorkSignTimeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignTimeEntities);
    }

    @Override
    @CrmLog
    public void saveCheck(SfaWorkSignTimeReqVo timeReqVo) {
        AssertDateTimeUtils.checkTime((String)timeReqVo.getGotoTime(), (String)"\u4e0a\u73ed\u6253\u5361\u65f6\u95f4\u9519\u8bef");
        AssertDateTimeUtils.checkTime((String)timeReqVo.getGooffTime(), (String)"\u4e0b\u73ed\u6253\u5361\u65f6\u95f4\u9519\u8bef");
        AssertDateTimeUtils.checkTime((String)timeReqVo.getGotoStartTime(), (String)"\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0a\u73ed\u5361\u5f00\u59cb\u65f6\u95f4\u9519\u8bef");
        AssertDateTimeUtils.checkTime((String)timeReqVo.getGotoEndTime(), (String)"\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0a\u73ed\u5361\u7ed3\u675f\u65f6\u95f4\u9519\u8bef");
        AssertDateTimeUtils.checkTime((String)timeReqVo.getGooffStartTime(), (String)"\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u9519\u8bef");
        AssertDateTimeUtils.checkTime((String)timeReqVo.getGooffEndTime(), (String)"\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0b\u73ed\u5361\u7ed3\u675f\u65f6\u95f4\u9519\u8bef");
        AssertDateTimeUtils.notAfterTime((String)timeReqVo.getGotoStartTime(), (String)timeReqVo.getGotoEndTime(), (String)"\u4e0a\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u4e0a\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4");
        AssertDateTimeUtils.notAfterTime((String)timeReqVo.getGooffStartTime(), (String)timeReqVo.getGooffEndTime(), (String)"\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u4e0b\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4");
    }
}

