/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.repositories.SfaVisitStepStoreCheckEsDataRepositories;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEsData;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckRedisData;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="storeCheckVisitStepExecutor")
public class StoreCheckVisitStepExecutor
extends AbstractVisitStepRedisExecutor<StoreCheckStepExecuteData, StoreCheckStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(StoreCheckVisitStepExecutor.class);
    @Resource
    private SfaVisitStepStoreCheckEsDataRepositories sfaVisitStepStoreCheckEsDataRepositories;

    @Override
    public void execute(VisitStepExecuteReq<StoreCheckStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        StoreCheckStepExecuteData storeCheckStepExecuteData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)((Object)CrmBeanUtil.copy((Object)((Object)storeCheckStepExecuteData), SfaVisitStepStoreCheckRedisData.class));
        redisData.setFormId(visitStepExecuteReq.getFormId());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setRegularShelfDisplayList(storeCheckStepExecuteData.getRegularShelfDisplayList());
        redisData.setMaterialDisplayList(storeCheckStepExecuteData.getMaterialDisplayList());
        redisData.setPriceList(storeCheckStepExecuteData.getPriceList());
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "storeCheck");
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey()).toString(), redisData.buildRedisDataForWrite(), 691200L);
    }

    @Override
    protected StoreCheckStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey());
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)((Object)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepStoreCheckRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setRegularShelfDisplayList(list);
                    this.setMaterialDisplayList(list);
                    this.setPriceList(list);
                }
            };
        }
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), StoreCheckStepExecuteDataResp.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        return dataResp;
    }

    protected void buildEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitStepStoreCheckRedisData storeCheckRedisData) {
        storeCheckRedisData.setId(sfaVisitPlanInfoEntity.getId());
        StringJoiner checkType = new StringJoiner(",");
        StringJoiner checkTypeDesc = new StringJoiner(",");
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getRegularShelfDisplayList())) {
            checkType.add(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getMaterialDisplayList())) {
            checkType.add(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getPriceList())) {
            checkType.add(SfaVisitEnum.checkStoreType.PRICE.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.PRICE.getDesc());
        }
        storeCheckRedisData.setCheckType(checkType.toString());
        storeCheckRedisData.setCheckTypeDesc(checkTypeDesc.toString());
        storeCheckRedisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        storeCheckRedisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        storeCheckRedisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        storeCheckRedisData.setCheckTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        UserRedis userRedis = UserUtils.getUser();
        storeCheckRedisData.setUserName(userRedis.getUsername());
        storeCheckRedisData.setRealName(userRedis.getUsername());
        storeCheckRedisData.setPosCode(userRedis.getPoscode());
        storeCheckRedisData.setPosName(userRedis.getPosname());
        storeCheckRedisData.setOrgCode(userRedis.getOrgcode());
        storeCheckRedisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<StoreCheckStepExecuteData> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        StoreCheckStepExecuteData storeCheckStepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getCheckAddress())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5730\u5740\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getLongitude())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u7ecf\u5ea6");
        }
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getLatitude())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u7ef4\u5ea6");
        }
        if (CollectionUtils.isEmpty(storeCheckStepExecuteData.getRegularShelfDisplayList())) {
            throw new BusinessException("\u5e38\u89c4\u8d27\u67b6\u9648\u5217\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(storeCheckStepExecuteData.getMaterialDisplayList())) {
            throw new BusinessException("\u7269\u6599\u9648\u5217\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(storeCheckStepExecuteData.getPriceList())) {
            throw new BusinessException("\u4ef7\u683c\u7b7e\u4e3a\u7a7a");
        }
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)((Object)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey()).toString(), (Object)executorLoadReq.getRedisHashKey()));
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        SfaVisitStepStoreCheckEsData dataResp = (SfaVisitStepStoreCheckEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepStoreCheckEsData.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        this.loadFormData(executorLoadReq, dataResp);
        this.sfaVisitStepStoreCheckEsDataRepositories.save(dataResp);
    }
}

