/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.service.impl.SfaCustomerServiceImpl;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitTempPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRangeRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitTempPlanRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitnote.mapper.SfaVisitPlanMapper;
import com.biz.crm.visitnote.mapper.SfaVisitPlanRangeMapper;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitPlanRangeService;
import com.biz.crm.visitnote.service.ISfaVisitTempPlanService;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitTempPlanServiceExpandImpl"})
public class SfaVisitTempPlanServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitPlanMapper, SfaVisitPlanEntity>
implements ISfaVisitTempPlanService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitTempPlanServiceImpl.class);
    @Resource
    private SfaVisitPlanMapper sfaVisitPlanMapper;
    @Resource
    private SfaVisitPlanRangeMapper sfaVisitPlanRangeMapper;
    @Resource
    private ISfaVisitPlanInfoService iSfaVisitPlanInfoService;
    @Resource
    private RedisService redisService;
    @Resource
    private ISfaVisitPlanRangeService iSfaVisitPlanRangeService;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    private static String ONE = "1";
    private static String TWO = "2";
    private static String THREE = "3";

    @Override
    public PageResult<SfaVisitTempPlanRespVo> findList(SfaVisitTempPlanReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitTempPlanRespVo> list = this.sfaVisitPlanMapper.findTempList((Page<SfaVisitTempPlanRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List visitPlanCodes = list.stream().map(SfaVisitTempPlanRespVo::getVisitPlanCode).collect(Collectors.toList());
            SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
            sfaVisitPlanRangeReqVo.setVisitPlanCodes(visitPlanCodes);
            sfaVisitPlanRangeReqVo.setPageSize(Integer.valueOf(-1));
            List sfaVisitPlanRangeRespVos = this.iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
            Map<String, List<SfaVisitPlanRangeRespVo>> readRespMap = sfaVisitPlanRangeRespVos.stream().collect(Collectors.groupingBy(SfaVisitPlanRangeRespVo::getVisitPlanCode));
            for (SfaVisitTempPlanRespVo sfaVisitPlanRespVo : list) {
                List<SfaVisitPlanRangeRespVo> visitPlanRangeRespVos = readRespMap.get(sfaVisitPlanRespVo.getVisitPlanCode());
                if (visitPlanRangeRespVos == null || visitPlanRangeRespVos.size() <= 0) continue;
                StringBuffer groupNameBuffer = new StringBuffer();
                StringBuffer groupIdBuffer = new StringBuffer();
                for (SfaVisitPlanRangeRespVo visitPlanRangeRespVo : visitPlanRangeRespVos) {
                    if (groupNameBuffer.length() > 0) {
                        groupNameBuffer.append(",");
                    }
                    if (StringUtils.isNotEmpty((String)visitPlanRangeRespVo.getVisitGroupName())) {
                        groupNameBuffer.append(visitPlanRangeRespVo.getVisitGroupName());
                    }
                    if (groupIdBuffer.length() > 0) {
                        groupIdBuffer.append(",");
                    }
                    if (!StringUtils.isNotEmpty((String)visitPlanRangeRespVo.getVisitGroupId())) continue;
                    groupIdBuffer.append(visitPlanRangeRespVo.getVisitGroupId());
                }
                sfaVisitPlanRespVo.setVisitGroupIds(groupIdBuffer.toString());
                sfaVisitPlanRespVo.setVisitGroupNames(groupNameBuffer.toString());
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitTempPlanRespVo query(SfaVisitTempPlanReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaVisitTempPlanRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitTempPlanRespVo();
        }
        SfaVisitTempPlanRespVo respVo = (SfaVisitTempPlanRespVo)list.get(0);
        SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        sfaVisitPlanRangeReqVo.setVisitPlanCode(respVo.getVisitPlanCode());
        List sfaVisitPlanRangeRespVos = this.iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
        respVo.setSfaVisitPlanRangeRespVos(sfaVisitPlanRangeRespVos);
        return respVo;
    }

    public void saveCheck(SfaVisitTempPlanReqVo reqVo) {
        LocalDate beginDate;
        AssertUtils.isNotEmpty((String)reqVo.getPlanType(), (String)"\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!SfaVisitEnum.visitType.GETMAP.containsKey(reqVo.getPlanType())) {
            throw new BusinessException("\u62dc\u8bbf\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u62dc\u8bbf\u7c7b\u578b(\u4e34\u65f6\u62dc\u8bbf\u3001\u8ba1\u5212\u62dc\u8bbf\u3001\u534f\u8bbf)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getRouteType(), (String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a(\u7ebf\u8def\u7ec4\u3001\u7f51\u70b9\u3001\u9891\u7387)");
        if (!SfaVisitEnum.routeTypeEnum.GETMAP.containsKey(reqVo.getRouteType())) {
            throw new BusinessException("\u7ef4\u5ea6\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6(\u7ebf\u8def\u7ec4\u3001\u7f51\u70b9\u3001\u9891\u7387)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitRealName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosName(), (String)"\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgCode(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgName(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitStartDate(), (String)"\u4e34\u65f6\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            beginDate = LocalDate.parse(reqVo.getVisitStartDate(), CrmDateUtils.yyyyMMdd);
            SfaVisitPlanResolver.futureDaysCheck(beginDate);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException("\u4e34\u65f6\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        reqVo.setVisitEndDate(reqVo.getVisitStartDate());
        if (StringUtils.isNotEmpty((String)reqVo.getPlanType()) && SfaVisitEnum.visitType.ASSIT_TYPE.getVal().equals(reqVo.getPlanType())) {
            AssertUtils.isNotEmpty((String)reqVo.getCvUserId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvUserName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvRealName(), (String)"\u8bf7\u9009\u62e9\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u59d3\u540d");
            AssertUtils.isNotEmpty((String)reqVo.getCvPosId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvPosCode(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvPosName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvOrgId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvOrgCode(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getCvOrgName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtil.listNotEmpty((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u5236\u5b9a\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = 1;
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo : reqVo.getSfaVisitPlanRangeReqVos()) {
            if (SfaVisitEnum.routeTypeEnum.R1.getVal().equals(reqVo.getRouteType())) {
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getVisitGroupId(), (String)("\u7ebf\u8def\u7ec4" + i + ",\u7ebf\u8def\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getVisitGroupName(), (String)("\u7ebf\u8def\u7ec4" + i + ",\u7ebf\u8def\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            } else {
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientCode(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientName(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientType(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                if (SfaVisitEnum.routeTypeEnum.R3.getVal().equals(reqVo.getRouteType())) {
                    AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getFirstVisitDate(), (String)("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
                    LocalDate firstVisitDate = null;
                    try {
                        firstVisitDate = LocalDate.parse(sfaVisitPlanRangeReqVo.getFirstVisitDate(), CrmDateUtils.yyyyMMdd);
                    }
                    catch (Exception e) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (Throwable)e);
                    }
                    if (beginDate.isAfter(firstVisitDate) || firstVisitDate.isAfter(beginDate)) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u4e0d\u5728\u5faa\u73af\u65e5\u671f\u5185");
                    }
                    if (null == sfaVisitPlanRangeReqVo.getVisitFrequency()) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    try {
                        String regex = "^[1-9]+[0-9]*$";
                        Pattern p = Pattern.compile(regex);
                        Matcher m = p.matcher(sfaVisitPlanRangeReqVo.getVisitFrequency().toString());
                        if (!m.find()) {
                            System.out.println("falsss");
                            throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570", (Throwable)e);
                    }
                    if (sfaVisitPlanRangeReqVo.getVisitFrequency() <= 0) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                    }
                }
            }
            ++i;
        }
    }

    @Override
    @Transactional
    public void save(SfaVisitTempPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitRealName(userRedis.getRealname());
            reqVo.setVisitPosCode(userRedis.getPoscode());
            reqVo.setVisitPosName(userRedis.getPosname());
            reqVo.setVisitOrgCode(userRedis.getOrgcode());
            reqVo.setVisitOrgName(userRedis.getOrgname());
        }
        this.saveCheck(reqVo);
        SfaVisitPlanEntity entity = (SfaVisitPlanEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanEntity.class));
        String code = CodeUtil.getCodeDefault();
        entity.setVisitPlanCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
        this.addPlanInfoForTempPlan(reqVo, entity);
    }

    private void addPlanInfoForTempPlan(SfaVisitTempPlanReqVo reqVo, SfaVisitPlanEntity entity) {
        List<Object> planInfoEntities = Lists.newArrayList();
        List sfaVisitPlanRangeReqVos = reqVo.getSfaVisitPlanRangeReqVos();
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo : sfaVisitPlanRangeReqVos) {
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanInfoEntity.class));
            sfaVisitPlanInfoEntity.setVisitDate(entity.getVisitStartDate());
            sfaVisitPlanInfoEntity.setVisitType(entity.getPlanType());
            sfaVisitPlanInfoEntity.setVisitPlanCode(entity.getVisitPlanCode());
            sfaVisitPlanInfoEntity.setClientCode(sfaVisitPlanRangeReqVo.getClientCode());
            sfaVisitPlanInfoEntity.setClientName(sfaVisitPlanRangeReqVo.getClientName());
            sfaVisitPlanInfoEntity.setClientType(sfaVisitPlanRangeReqVo.getClientType());
            sfaVisitPlanInfoEntity.setClientAddress(sfaVisitPlanRangeReqVo.getClientAddress());
            sfaVisitPlanInfoEntity.setClientPhone(sfaVisitPlanRangeReqVo.getClientPhone());
            sfaVisitPlanInfoEntity.setLongitude(sfaVisitPlanRangeReqVo.getLongitude());
            sfaVisitPlanInfoEntity.setLatitude(sfaVisitPlanRangeReqVo.getLatitude());
            sfaVisitPlanInfoEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            sfaVisitPlanInfoEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            SfaVisitPlanInfoEntity.buildPlanEntity(sfaVisitPlanInfoEntity);
            planInfoEntities.add((Object)sfaVisitPlanInfoEntity);
        }
        String redisHash = this.iSfaVisitPlanInfoService.checkAddForTempPlan((List<SfaVisitPlanInfoEntity>)planInfoEntities);
        this.sfaVisitPlanInfoServiceEsImpl.saveAll((Collection<SfaVisitPlanInfoEntity>)planInfoEntities);
        SfaVisitPlanInfoEntity temp = (SfaVisitPlanInfoEntity)((Object)planInfoEntities.get(0));
        planInfoEntities = this.sfaVisitPlanInfoServiceEsImpl.findByVisitUserNameAndVisitPosCodeAndAndVisitDate(temp.getVisitUserName(), temp.getVisitPosCode(), temp.getVisitDate());
        Map<String, SfaVisitPlanInfoEntity> map = planInfoEntities.stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getRedisHashKey, v -> v, (t, t2) -> t2));
        this.redisService.hmset(redisHash, map, 691200L);
    }

    public void saveData(SfaVisitTempPlanReqVo reqVo, SfaVisitPlanEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            List visitPlanRangeEntities = reqVo.getSfaVisitPlanRangeReqVos().stream().map(o -> {
                SfaVisitPlanRangeEntity receivingEntity = new SfaVisitPlanRangeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)receivingEntity));
                receivingEntity.setVisitPlanCode(entity.getVisitPlanCode());
                return receivingEntity;
            }).collect(Collectors.toList());
            this.iSfaVisitPlanRangeService.saveBatch(visitPlanRangeEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public void update(SfaVisitTempPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanEntity entity = (SfaVisitPlanEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        reqVo.setVisitPlanCode(entity.getVisitPlanCode());
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        this.iSfaVisitPlanInfoService.deleteBatch(ids);
    }

    public void deleteBatchDate(SfaVisitTempPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitPlanCode()) && CollectionUtil.listEmpty((List)reqVo.getVisitPlanCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanRangeReqVo visitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        visitPlanRangeReqVo.setVisitPlanCode(reqVo.getVisitPlanCode());
        visitPlanRangeReqVo.setVisitPlanCodes(reqVo.getVisitPlanCodes());
        this.sfaVisitPlanRangeMapper.deleteProductsByParams(visitPlanRangeReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(final List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitTempPlanReqVo reqVo = new SfaVisitTempPlanReqVo(){
            {
                this.setPlanType(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
                this.setIds(ids);
            }
        };
        List sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanEntities)) {
            sfaVisitPlanEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(final List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitTempPlanReqVo reqVo = new SfaVisitTempPlanReqVo(){
            {
                this.setIds(ids);
                this.setPlanType(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
            }
        };
        List sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanEntities)) {
            sfaVisitPlanEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }

    @Override
    public Integer getVisitNum(String dateFlag) {
        List<SfaVisitPlanRespVo> visitNum;
        String lastDay;
        String firstDay;
        Integer num = 0;
        String userCode = UserUtils.getUser().getUsername();
        SfaCustomerServiceImpl customerService = new SfaCustomerServiceImpl();
        if (ONE.equals(dateFlag)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"create_date", (Object)DateUtil.getYYYYMMDD());
            wrapper.eq((Object)"create_code", (Object)userCode);
            List sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectList((Wrapper)wrapper);
            if (CollectionUtil.listEmpty((List)sfaVisitPlanEntities)) {
                return num;
            }
            num = sfaVisitPlanEntities.size();
        }
        if (TWO.equals(dateFlag)) {
            firstDay = customerService.getMondayOfThisWeek(ONE);
            visitNum = this.sfaVisitPlanMapper.getVisitNum(firstDay, lastDay = customerService.getMondayOfThisWeek(TWO), userCode);
            if (CollectionUtil.listEmpty(visitNum)) {
                return num;
            }
            num = visitNum.size();
        }
        if (THREE.equals(dateFlag)) {
            firstDay = customerService.getMonthDay(ONE);
            visitNum = this.sfaVisitPlanMapper.getVisitNum(firstDay, lastDay = customerService.getMonthDay(TWO), userCode);
            if (CollectionUtil.listEmpty(visitNum)) {
                return num;
            }
            num = visitNum.size();
        }
        return num;
    }
}

