/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitDisplayConfigReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitDisplayConfigRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.mapper.SfaVisitDisplayConfigMapper;
import com.biz.crm.visitstep.model.SfaVisitDisplayConfigEntity;
import com.biz.crm.visitstep.service.ISfaVisitDisplayConfigService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaVisitDisplayConfigServiceExpandImpl"})
public class SfaVisitDisplayConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitDisplayConfigMapper, SfaVisitDisplayConfigEntity>
implements ISfaVisitDisplayConfigService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitDisplayConfigServiceImpl.class);
    @Resource
    private SfaVisitDisplayConfigMapper sfaVisitDisplayConfigMapper;

    @Override
    public PageResult<SfaVisitDisplayConfigRespVo> findList(SfaVisitDisplayConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitDisplayConfigRespVo> list = this.sfaVisitDisplayConfigMapper.findList((Page<SfaVisitDisplayConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaVisitDisplayConfigRespVo> getConfig(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.ne((Object)"del_flag", (Object)CrmDelFlagEnum.DELETE.getCode());
        List sfaVisitDisplayConfigEntities = this.list((Wrapper)queryWrapper);
        return CrmBeanUtil.copyList((List)sfaVisitDisplayConfigEntities, SfaVisitDisplayConfigRespVo.class);
    }

    @Override
    public SfaVisitDisplayConfigRespVo query(SfaVisitDisplayConfigReqVo reqVo) {
        SfaVisitDisplayConfigEntity sfaVisitDisplayConfigEntity = (SfaVisitDisplayConfigEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        return (SfaVisitDisplayConfigRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDisplayConfigEntity), SfaVisitDisplayConfigRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitDisplayConfigReqVo reqVo) {
        SfaVisitDisplayConfigEntity entity = (SfaVisitDisplayConfigEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitDisplayConfigEntity.class));
        this.validate(reqVo);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
    }

    private void validate(SfaVisitDisplayConfigReqVo reqVo) {
        int row;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"label_name", (Object)reqVo.getLabelName());
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            queryWrapper.ne((Object)"id", (Object)reqVo.getId());
        }
        if ((row = this.count((Wrapper)queryWrapper)) > 0) {
            throw new BusinessException("\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitDisplayConfigReqVo reqVo) {
        SfaVisitDisplayConfigEntity entity = (SfaVisitDisplayConfigEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.validate(reqVo);
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitDisplayConfigReqVo reqVo) {
        List sfaVisitDisplayConfigEntities = this.sfaVisitDisplayConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDisplayConfigEntities)) {
            sfaVisitDisplayConfigEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitDisplayConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitDisplayConfigReqVo reqVo) {
        List sfaVisitDisplayConfigEntities = this.sfaVisitDisplayConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDisplayConfigEntities)) {
            sfaVisitDisplayConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitDisplayConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitDisplayConfigReqVo reqVo) {
        List sfaVisitDisplayConfigEntities = this.sfaVisitDisplayConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDisplayConfigEntities)) {
            sfaVisitDisplayConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitDisplayConfigEntities);
    }
}

