/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.asexecution.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.asexecution.service.ISfaAsCashingService;
import com.biz.crm.asexecution.service.ISfaAsExecutionService;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsCashingReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecutionDetailReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecutionReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsStopReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsTreatyReqVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionDetailRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsTreatyRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaAsExecutionController"})
@Api(tags={"\u65b9\u6848\u6d3b\u52a8\u6267\u884c;"})
public class SfaAsExecutionController {
    private static final Logger log = LoggerFactory.getLogger(SfaAsExecutionController.class);
    @Autowired
    private ISfaAsExecutionService sfaAsExecutionService;
    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;
    @Autowired
    private ISfaAsCashingService sfaAsCashingService;

    @ApiOperation(value="\u6d3b\u52a8\u534f\u8bae\u4fdd\u5b58")
    @PostMapping(value={"/saveSfaAsTreaty"})
    @CrmLog
    public Result saveSfaAsTreaty(@RequestBody SfaAsTreatyReqVo sfaAsTreatyReqVo) {
        this.sfaAsExecutionService.saveSfaAsTreaty(sfaAsTreatyReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6d3b\u52a8\u534f\u8bae\u62a5\u8868")
    @PostMapping(value={"/treatyReport"})
    @CrmLog
    public Result<PageResult<SfaAsTreatyRespVo>> list(@RequestBody SfaAsTreatyReqVo params) {
        PageResult<SfaAsTreatyRespVo> result = this.sfaAsTreatyService.report(params);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6d3b\u52a8\u5bf9\u4ed8\u62a5\u8868")
    @PostMapping(value={"/cashReport"})
    @CrmLog
    public Result<PageResult<SfaAsCashingRespVo>> list(@RequestBody SfaAsCashingReqVo params) {
        PageResult<SfaAsCashingRespVo> result = this.sfaAsCashingService.report(params);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6839\u636e\u5151\u4ed8ID\u67e5\u8be2\u5151\u4ed8\u8be6\u60c5")
    @GetMapping(value={"/findByCashId/{cashId}"})
    @CrmLog
    public Result<SfaAsCashingRespVo> findByCashId(@PathVariable(value="cashId") String cashId) {
        SfaAsCashingRespVo result = this.sfaAsCashingService.findById(cashId);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u6d3b\u52a8\u6267\u884c\u4fdd\u5b58")
    @PostMapping(value={"/saveSfaAsExecution"})
    @CrmLog
    public Result saveSfaAsExecution(@RequestBody SfaAsExecutionReqVo sfaAsTreatyReqVo) {
        this.sfaAsExecutionService.saveSfaAsExecution(sfaAsTreatyReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6d3b\u52a8\u5151\u4ed8\u4fdd\u5b58")
    @PostMapping(value={"/saveSfaAsCashing"})
    @CrmLog
    public Result saveSfaAsCashing(@RequestBody SfaAsCashingReqVo sfaAsTreatyReqVo) {
        this.sfaAsExecutionService.saveSfaAsCashing(sfaAsTreatyReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6d3b\u52a8\u7ec8\u6b62\u4fdd\u5b58")
    @PostMapping(value={"/saveAsStop"})
    @CrmLog
    public Result saveAsStop(@RequestBody SfaAsStopReqVo sfaAsTreatyReqVo) {
        sfaAsTreatyReqVo.setStopState(YesNoEnum.yesNoEnum.ONE.getValue());
        this.sfaAsExecutionService.saveAsStop(sfaAsTreatyReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7\u6d3b\u52a8\u7f16\u7801\u548c\u7ec8\u7aef\u7f16\u7801\u67e5\u8be2\u6267\u884c\u8be6\u60c5")
    @PostMapping(value={"/queryExecutionDetailByActivityCodeAndTerminalCode"})
    @CrmLog
    public Result<SfaAsExecutionDetailRespVo> queryExecutionDetailByActivityCodeAndTerminalCode(@RequestBody SfaAsExecutionDetailReqVo reqVo) {
        SfaAsExecutionDetailRespVo respVo = this.sfaAsExecutionService.queryExecutionDetailByActivityCodeAndTerminalCode(reqVo);
        return Result.ok((Object)respVo);
    }
}

