/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksummary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaWorkSummaryEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryCommentReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryAtLogRespVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryCommentRespVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryLikeRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryAtLogMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryCommentMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryLikeMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryPrimaryMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryScopeMapper;
import com.biz.crm.worksummary.model.SfaWorkSummaryAtLogEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryCommentEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryLikeEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryPrimaryEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryScopeEntity;
import com.biz.crm.worksummary.service.ISfaWorkSummaryCommentService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSummaryCommentServiceExpandImpl"})
public class SfaWorkSummaryCommentServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSummaryCommentMapper, SfaWorkSummaryCommentEntity>
implements ISfaWorkSummaryCommentService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSummaryCommentServiceImpl.class);
    @Resource
    private SfaWorkSummaryCommentMapper sfaWorkSummaryCommentMapper;
    @Autowired
    private SfaWorkSummaryAtLogMapper sfaWorkSummaryAtLogMapper;
    @Autowired
    private SfaWorkSummaryScopeMapper sfaWorkSummaryScopeMapper;
    @Autowired
    private SfaWorkSummaryLikeMapper sfaWorkSummaryLikeMapper;
    @Autowired
    private SfaWorkSummaryPrimaryMapper sfaWorkSummaryPrimaryMapper;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<SfaWorkSummaryCommentRespVo> findList(SfaWorkSummaryCommentReqVo reqVo) {
        UserRedis currUser = UserUtils.getUser();
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaWorkSummaryCommentRespVo> list = this.sfaWorkSummaryCommentMapper.findList((Page<SfaWorkSummaryCommentRespVo>)page, reqVo);
        if (!CollectionUtils.isEmpty(list)) {
            HashSet createCodes = Sets.newHashSet();
            ArrayList ids = Lists.newArrayList();
            list.forEach(o -> {
                createCodes.add(o.getCreateCode());
                ids.add(o.getId());
            });
            List<SfaWorkSummaryAtLogRespVo> atLogRespVos = this.sfaWorkSummaryAtLogMapper.findListByBusinessIds(ids);
            Map<String, List<SfaWorkSummaryAtLogRespVo>> atLogRespVoMap = atLogRespVos.stream().collect(Collectors.groupingBy(SfaWorkSummaryAtLogRespVo::getBusinessId));
            atLogRespVoMap.forEach((k, v) -> v.forEach(o -> createCodes.add(o.getAtUserCode())));
            MdmPositionUserOrgReqVo userQueryVo = new MdmPositionUserOrgReqVo();
            userQueryVo.setPrimaryFlag("1");
            userQueryVo.setUserNameList(createCodes.stream().collect(Collectors.toList()));
            List userOrgRespVos = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(userQueryVo));
            Map userOrgRespVoMap = userOrgRespVos.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, Function.identity()));
            List<SfaWorkSummaryLikeRespVo> likeRespVos = this.sfaWorkSummaryLikeMapper.findCountByBusinessIds(ids);
            Map likeRespVoMap = likeRespVos.stream().collect(Collectors.toMap(SfaWorkSummaryLikeRespVo::getBusinessId, Function.identity()));
            LambdaQueryWrapper buildLikeQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmBaseEntity::getCreateCode, (Object)currUser.getUsername())).in(SfaWorkSummaryLikeEntity::getBusinessId, (Collection)ids);
            List summaryLikeEntities = this.sfaWorkSummaryLikeMapper.selectList((Wrapper)buildLikeQuery);
            Map likedMap = summaryLikeEntities.stream().collect(Collectors.toMap(SfaWorkSummaryLikeEntity::getBusinessId, Function.identity()));
            List<SfaWorkSummaryCommentRespVo> commentRespVos = this.sfaWorkSummaryCommentMapper.findCountByBusinessIds(ids);
            Map commentRespVoMap = commentRespVos.stream().collect(Collectors.toMap(SfaWorkSummaryCommentRespVo::getBusinessId, Function.identity()));
            list.forEach(o -> {
                SfaWorkSummaryLikeEntity summaryLikeEntity;
                List atLogArray;
                SfaWorkSummaryCommentRespVo sfaWorkSummaryCommentRespVo;
                o.setComment(o.getCommentDesc());
                String businessId = o.getId();
                String id = o.getId();
                MdmPositionUserOrgRespVo userOrgRespVo = (MdmPositionUserOrgRespVo)userOrgRespVoMap.get(o.getCreateCode());
                o.setPhoto(userOrgRespVo.getUserHeadUrl());
                SfaWorkSummaryLikeRespVo likeRespVo = (SfaWorkSummaryLikeRespVo)likeRespVoMap.get(businessId);
                if (!ObjectUtils.isEmpty((Object)likeRespVo)) {
                    o.setLikeSumCount(likeRespVo.getSumCount());
                }
                if (!ObjectUtils.isEmpty((Object)(sfaWorkSummaryCommentRespVo = (SfaWorkSummaryCommentRespVo)commentRespVoMap.get(businessId)))) {
                    o.setCommentSumCount(sfaWorkSummaryCommentRespVo.getCommentSumCount());
                }
                if (!CollectionUtils.isEmpty((Collection)(atLogArray = (List)atLogRespVoMap.get(o.getId())))) {
                    atLogArray.forEach(e -> {
                        MdmPositionUserOrgRespVo userRespVo = (MdmPositionUserOrgRespVo)userOrgRespVoMap.get(e.getAtUserCode());
                        if (!ObjectUtils.isEmpty((Object)userRespVo)) {
                            e.setAtUserName(userRespVo.getFullName());
                        }
                    });
                    o.setAtLogRespVos(atLogArray);
                }
                if (!ObjectUtils.isEmpty((Object)((Object)(summaryLikeEntity = (SfaWorkSummaryLikeEntity)((Object)((Object)likedMap.get(id))))))) {
                    o.setLiked("Y");
                } else {
                    o.setLiked("N");
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSummaryCommentRespVo query(SfaWorkSummaryCommentReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSummaryCommentReqVo reqVo) {
        ValidateUtils.validate((Object)reqVo.getBusinessId(), (String)"\u5f85\u8bc4\u8bba\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        SfaWorkSummaryPrimaryEntity summaryPrimaryEntity = (SfaWorkSummaryPrimaryEntity)((Object)this.sfaWorkSummaryPrimaryMapper.selectById((Serializable)((Object)reqVo.getBusinessId())));
        if (!ObjectUtils.isEmpty((Object)((Object)summaryPrimaryEntity))) {
            reqVo.setSummaryId(summaryPrimaryEntity.getId());
        } else {
            SfaWorkSummaryCommentEntity summaryCommentEntity = (SfaWorkSummaryCommentEntity)((Object)this.sfaWorkSummaryCommentMapper.selectById((Serializable)((Object)reqVo.getBusinessId())));
            if (!ObjectUtils.isEmpty((Object)((Object)summaryCommentEntity))) {
                reqVo.setSummaryId(summaryCommentEntity.getSummaryId());
            } else {
                throw new BusinessException("businessId\u6570\u636e\u5f02\u5e38");
            }
        }
        SfaWorkSummaryCommentEntity entity = (SfaWorkSummaryCommentEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSummaryCommentEntity.class));
        entity.setCommentDesc(reqVo.getComment());
        this.save((Object)entity);
        String summaryId = reqVo.getSummaryId();
        String businessId = reqVo.getBusinessId();
        if (!CollectionUtils.isEmpty((Collection)reqVo.getAtColleagueCode())) {
            LambdaQueryWrapper build = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSummaryScopeEntity::getBusinessId, (Object)businessId)).in(SfaWorkSummaryScopeEntity::getScopeCode, (Collection)reqVo.getAtColleagueCode())).eq(SfaWorkSummaryScopeEntity::getScopeType, (Object)SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal());
            List scopeEntities = this.sfaWorkSummaryScopeMapper.selectList((Wrapper)build);
            Map scopeEntityMap = scopeEntities.stream().collect(Collectors.toMap(SfaWorkSummaryScopeEntity::getScopeCode, Function.identity()));
            reqVo.getAtColleagueCode().forEach(o -> {
                SfaWorkSummaryAtLogEntity atLogEntity = new SfaWorkSummaryAtLogEntity();
                atLogEntity.setAtUserCode((String)o);
                atLogEntity.setSummaryId(summaryId);
                atLogEntity.setBusinessId(businessId);
                this.sfaWorkSummaryAtLogMapper.insert((Object)atLogEntity);
                SfaWorkSummaryScopeEntity scopeEntity = (SfaWorkSummaryScopeEntity)((Object)((Object)scopeEntityMap.get(o)));
                if (!ObjectUtils.isEmpty((Object)((Object)scopeEntity))) {
                    scopeEntity.setScopeCount(scopeEntity.getScopeCount() + 1);
                    this.sfaWorkSummaryScopeMapper.updateById((Object)scopeEntity);
                } else {
                    scopeEntity = new SfaWorkSummaryScopeEntity();
                    scopeEntity.setBusinessId(businessId);
                    scopeEntity.setScopeCode((String)o);
                    scopeEntity.setScopeCount(1);
                    scopeEntity.setScopeType(SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal());
                    this.sfaWorkSummaryScopeMapper.insert((Object)scopeEntity);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSummaryCommentReqVo reqVo) {
        SfaWorkSummaryCommentEntity entity = (SfaWorkSummaryCommentEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSummaryCommentReqVo reqVo) {
        List sfaWorkSummaryCommentEntities = this.sfaWorkSummaryCommentMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryCommentEntities)) {
            sfaWorkSummaryCommentEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryCommentEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSummaryCommentReqVo reqVo) {
        List sfaWorkSummaryCommentEntities = this.sfaWorkSummaryCommentMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryCommentEntities)) {
            sfaWorkSummaryCommentEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryCommentEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSummaryCommentReqVo reqVo) {
        List sfaWorkSummaryCommentEntities = this.sfaWorkSummaryCommentMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryCommentEntities)) {
            sfaWorkSummaryCommentEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryCommentEntities);
    }
}

