/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.achievement.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaIndexMapper;
import com.biz.crm.achievement.model.SfaIndexEntity;
import com.biz.crm.achievement.service.ISfaIndexService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.achievement.req.SfaIndexReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaIndexRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SfaIndexServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaIndexMapper, SfaIndexEntity>
implements ISfaIndexService {
    private static final Logger log = LoggerFactory.getLogger(SfaIndexServiceImpl.class);
    @Autowired
    private SfaIndexMapper sfaIndexMapper;

    @Override
    public PageResult<SfaIndexRespVo> findList(SfaIndexReqVo sfaIndexReqVo) {
        Page page = new Page((long)sfaIndexReqVo.getPageNum().intValue(), (long)sfaIndexReqVo.getPageSize().intValue());
        List<SfaIndexRespVo> list = this.sfaIndexMapper.findList((Page<SfaIndexRespVo>)page, sfaIndexReqVo);
        for (SfaIndexRespVo respVo : list) {
            respVo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)respVo.getEnableStatus()));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaIndexReqVo sfaIndexReqVo) {
        this.checkParam(sfaIndexReqVo);
        SfaIndexEntity entity = (SfaIndexEntity)((Object)CrmBeanUtil.copy((Object)sfaIndexReqVo, SfaIndexEntity.class));
        entity.setIndexCode(sfaIndexReqVo.getIndexCode());
        entity.setIndexName(sfaIndexReqVo.getIndexName());
        this.save((Object)entity);
    }

    public void checkParam(SfaIndexReqVo sfaIndexReqVo) {
        AssertUtils.isNotEmpty((String)sfaIndexReqVo.getIndexCode(), (String)"\u6307\u6807\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)sfaIndexReqVo.getIndexName(), (String)"\u6307\u6807\u540d\u79f0\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaIndexReqVo sfaIndexReqVo) {
        AssertUtils.isNotEmpty((String)sfaIndexReqVo.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkParam(sfaIndexReqVo);
        AssertUtils.isNotNull((Object)this.getById((Serializable)((Object)sfaIndexReqVo.getId())), (String)"\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728");
        SfaIndexEntity entity = (SfaIndexEntity)((Object)CrmBeanUtil.copy((Object)sfaIndexReqVo, SfaIndexEntity.class));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List sfaIndexEntities = this.sfaIndexMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaIndexEntities)) {
            sfaIndexEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaIndexEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List sfaIndexEntities = this.sfaIndexMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaIndexEntities)) {
            sfaIndexEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaIndexEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List sfaIndexEntities = this.sfaIndexMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaIndexEntities)) {
            sfaIndexEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaIndexEntities);
    }
}

