/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u5e97\u9762\u68c0\u67e5\u5206\u9875-\u53c2\u6570")
public class GetOrderPageReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u5f00\u59cb\u65f6\u95f4")
    private String startOrderTime;
    @ApiModelProperty(value="\u7ed3\u675f\u65f6\u95f4")
    private String endOrderTime;
    @ApiModelProperty(value="\u5ba1\u6279\u72b6\u6001")
    private String approvalStatus;
    @ApiModelProperty(value="\u7f51\u70b9\u540d\u79f0\uff08\u5ba2\u6237\u540d\u79f0)")
    private String clientName;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((String)this.getApprovalStatus())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"approvalStatus.keyword", (String)this.getApprovalStatus()));
        }
        if (StringUtils.isNotEmpty((String)this.getClientName())) {
            builder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"clientName", (String)("*" + this.getClientName() + "*")));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getStartOrderTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"orderTime").from((Object)this.getStartOrderTime()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getEndOrderTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"orderTime").to((Object)this.getEndOrderTime()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"orderTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getStartOrderTime() {
        return this.startOrderTime;
    }

    public String getEndOrderTime() {
        return this.endOrderTime;
    }

    public String getApprovalStatus() {
        return this.approvalStatus;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setStartOrderTime(String startOrderTime) {
        this.startOrderTime = startOrderTime;
    }

    public void setEndOrderTime(String endOrderTime) {
        this.endOrderTime = endOrderTime;
    }

    public void setApprovalStatus(String approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetOrderPageReq)) {
            return false;
        }
        GetOrderPageReq other = (GetOrderPageReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$startOrderTime = this.getStartOrderTime();
        String other$startOrderTime = other.getStartOrderTime();
        if (this$startOrderTime == null ? other$startOrderTime != null : !this$startOrderTime.equals(other$startOrderTime)) {
            return false;
        }
        String this$endOrderTime = this.getEndOrderTime();
        String other$endOrderTime = other.getEndOrderTime();
        if (this$endOrderTime == null ? other$endOrderTime != null : !this$endOrderTime.equals(other$endOrderTime)) {
            return false;
        }
        String this$approvalStatus = this.getApprovalStatus();
        String other$approvalStatus = other.getApprovalStatus();
        if (this$approvalStatus == null ? other$approvalStatus != null : !this$approvalStatus.equals(other$approvalStatus)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        return !(this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetOrderPageReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $startOrderTime = this.getStartOrderTime();
        result = result * 59 + ($startOrderTime == null ? 43 : $startOrderTime.hashCode());
        String $endOrderTime = this.getEndOrderTime();
        result = result * 59 + ($endOrderTime == null ? 43 : $endOrderTime.hashCode());
        String $approvalStatus = this.getApprovalStatus();
        result = result * 59 + ($approvalStatus == null ? 43 : $approvalStatus.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetOrderPageReq(startOrderTime=" + this.getStartOrderTime() + ", endOrderTime=" + this.getEndOrderTime() + ", approvalStatus=" + this.getApprovalStatus() + ", clientName=" + this.getClientName() + ")";
    }
}

