/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.acttask.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.acttask.mapper.SfaActFileMapper;
import com.biz.crm.acttask.mapper.SfaActProductMapper;
import com.biz.crm.acttask.mapper.SfaActRangeMapper;
import com.biz.crm.acttask.mapper.SfaActTaskMapper;
import com.biz.crm.acttask.model.SfaActFileEntity;
import com.biz.crm.acttask.model.SfaActProductEntity;
import com.biz.crm.acttask.model.SfaActRangeEntity;
import com.biz.crm.acttask.model.SfaActTaskEntity;
import com.biz.crm.acttask.service.ISfaActFileService;
import com.biz.crm.acttask.service.ISfaActProductService;
import com.biz.crm.acttask.service.ISfaActRangeService;
import com.biz.crm.acttask.service.ISfaActTaskService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaActTaskEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.sfa.acttask.req.SfaActFileReqVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActProductReqVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActRangeReqVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActTaskReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActRangeRespVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActTaskRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaActTaskServiceExpandImpl"})
public class SfaActTaskServiceImpl
extends ServiceImpl<SfaActTaskMapper, SfaActTaskEntity>
implements ISfaActTaskService {
    private static final Logger log = LoggerFactory.getLogger(SfaActTaskServiceImpl.class);
    @Resource
    private SfaActTaskMapper sfaActTaskMapper;
    @Resource
    private SfaActFileMapper sfaActFileMapper;
    @Resource
    private SfaActProductMapper sfaActProductMapper;
    @Resource
    private SfaActRangeMapper sfaActRangeMapper;
    @Autowired
    private ISfaActProductService iSfaActProductService;
    @Autowired
    private ISfaActRangeService iSfaActRangeService;
    @Autowired
    private ISfaActFileService iSfaActFileService;

    @Override
    public PageResult<SfaActTaskRespVo> findList(SfaActTaskReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaActTaskRespVo> list = this.sfaActTaskMapper.findList((Page<SfaActTaskRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaActTaskRespVo query(SfaActTaskReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaActTaskRespVo();
        }
        SfaActTaskRespVo sfaActTaskRespVo = (SfaActTaskRespVo)list.get(0);
        SfaActRangeReqVo rangeReqVo = new SfaActRangeReqVo();
        rangeReqVo.setActCode(sfaActTaskRespVo.getActCode());
        rangeReqVo.setPageSize(Integer.valueOf(-1));
        List sfaActRangeRespVos = this.iSfaActRangeService.findList(rangeReqVo).getData();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaActRangeRespVos)) {
            ArrayList<SfaActRangeRespVo> sfaActRangeRespContainVos = new ArrayList<SfaActRangeRespVo>();
            ArrayList<SfaActRangeRespVo> sfaActRangeRespNotContainVos = new ArrayList<SfaActRangeRespVo>();
            for (SfaActRangeRespVo rangeRespVo : sfaActRangeRespVos) {
                if (SfaCommonEnum.rangeTypeEnum.One.getVal().equals(rangeRespVo.getRangeType())) {
                    sfaActRangeRespContainVos.add(rangeRespVo);
                    continue;
                }
                sfaActRangeRespNotContainVos.add(rangeRespVo);
            }
            sfaActTaskRespVo.setSfaActRangeRespContainVos(sfaActRangeRespContainVos);
            sfaActTaskRespVo.setSfaActRangeRespNotContainVos(sfaActRangeRespNotContainVos);
        }
        SfaActProductReqVo productReqVo = new SfaActProductReqVo();
        productReqVo.setActCode(sfaActTaskRespVo.getActCode());
        productReqVo.setPageSize(Integer.valueOf(-1));
        List sfaActProductRespVos = this.iSfaActProductService.findList(productReqVo).getData();
        sfaActTaskRespVo.setSfaActProductRespVos(sfaActProductRespVos);
        SfaActFileReqVo fileReqVo = new SfaActFileReqVo();
        fileReqVo.setActCode(sfaActTaskRespVo.getActCode());
        fileReqVo.setPageSize(Integer.valueOf(-1));
        List sfaActFileRespVos = this.iSfaActFileService.findList(fileReqVo).getData();
        sfaActTaskRespVo.setSfaActFileRespVos(sfaActFileRespVos);
        return sfaActTaskRespVo;
    }

    public void saveCheck(SfaActTaskReqVo reqVo) {
        Pattern pattern;
        String text;
        AssertUtils.isNotEmpty((String)reqVo.getActName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getActType(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
        Date beginDate = null;
        try {
            beginDate = ymd.parse(reqVo.getBeginDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        Date endDate = null;
        try {
            endDate = ymd.parse(reqVo.getEndDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (beginDate.getTime() >= endDate.getTime()) {
            throw new BusinessException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        }
        if (SfaActTaskEnum.actTypeEnum.cost.getVal().equals(reqVo.getActType())) {
            text = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$";
            pattern = Pattern.compile(text);
            if (null == reqVo.getForecastSalesAmount()) {
                throw new BusinessException("\u8bf7\u586b\u5199\u9884\u4f30\u9500\u552e\u989d");
            }
            if (!pattern.matcher(reqVo.getForecastSalesAmount().toString()).matches()) {
                throw new BusinessException("\u9884\u4f30\u9500\u552e\u989d\u586b\u5199\u683c\u5f0f\u6709\u8bef,\u53ea\u80fd\u586b\u5199\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u5b57,\u5e76\u4e14\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
            }
            if (null == reqVo.getApplyAmount()) {
                throw new BusinessException("\u8bf7\u586b\u5199\u8d39\u7528\u7533\u8bf7\u91d1\u989d");
            }
            if (!pattern.matcher(reqVo.getApplyAmount().toString()).matches()) {
                throw new BusinessException("\u8d39\u7528\u7533\u8bf7\u91d1\u989d\u586b\u5199\u683c\u5f0f\u6709\u8bef,\u53ea\u80fd\u586b\u5199\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u5b57,\u5e76\u4e14\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
            }
        } else if (SfaActTaskEnum.actTypeEnum.display.getVal().equals(reqVo.getActType())) {
            text = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,1})?$";
            pattern = Pattern.compile(text);
            if (null == reqVo.getActFrequency()) {
                throw new BusinessException("\u8bf7\u586b\u5199\u4efb\u52a1\u6267\u884c\u9891\u7387(\u5355\u4f4d:\u5929/1\u6b21)");
            }
            if (!pattern.matcher(reqVo.getActFrequency().toString()).matches()) {
                throw new BusinessException("\u4efb\u52a1\u6267\u884c\u9891\u7387\u5199\u683c\u5f0f\u6709\u8bef,\u53ea\u80fd\u586b\u5199\u5927\u4e8e0\u7684\u6570\u5b57,\u5e76\u4e14\u6700\u591a\u4fdd\u7559\u4e00\u4f4d\u5c0f\u6570");
            }
            if (reqVo.getActFrequency().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException("\u4efb\u52a1\u6267\u884c\u9891\u7387\u5199\u683c\u5f0f\u6709\u8bef,\u53ea\u80fd\u586b\u5199\u5927\u4e8e0\u7684\u6570\u5b57,\u5e76\u4e14\u6700\u591a\u4fdd\u7559\u4e00\u4f4d\u5c0f\u6570");
            }
        } else {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u6709\u8bef,\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u6d3b\u52a8\u7c7b\u578b");
        }
        if (CollectionUtil.listEmpty((List)reqVo.getSfaActRangeReqContainVos()) && CollectionUtil.listEmpty((List)reqVo.getSfaActRangeReqNotContainVos())) {
            throw new BusinessException("\u6d3b\u52a8\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (SfaActTaskEnum.actTypeEnum.display.getVal().equals(reqVo.getActType())) {
            if (CollectionUtil.listEmpty((List)reqVo.getSfaActProductReqVos())) {
                throw new BusinessException("\u9648\u5217\u6d3b\u52a8,\u9648\u5217\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
            }
            int i = 1;
            for (SfaActProductReqVo productReqVo : reqVo.getSfaActProductReqVos()) {
                if (StringUtil.isEmpty((String)productReqVo.getProductCode())) {
                    throw new BusinessException("\u9648\u5217\u6d3b\u52a8,\u7b2c" + i + "\u884c\u9648\u5217\u8981\u6c42,\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtil.isEmpty((String)productReqVo.getProductName())) {
                    throw new BusinessException("\u9648\u5217\u6d3b\u52a8,\u7b2c" + i + "\u884c\u9648\u5217\u8981\u6c42,\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == productReqVo.getMinNumber()) {
                    throw new BusinessException("\u9648\u5217\u6d3b\u52a8,\u7b2c" + i + "\u884c\u9648\u5217\u8981\u6c42,\u6700\u4f4e\u9648\u5217\u9762\u6570\u4e0d\u80fd\u4e3a\u7a7a(\u53ea\u80fd\u586b\u5199\u5927\u4e8e0\u7684\u6b63\u6574\u6570)");
                }
                String regex = "^[1-9]+[0-9]*$";
                Pattern pattern2 = Pattern.compile(regex);
                if (pattern2.matcher(productReqVo.getMinNumber().toString()).matches()) continue;
                throw new BusinessException("\u9648\u5217\u6d3b\u52a8,\u7b2c" + i + "\u884c\u9648\u5217\u8981\u6c42\u683c\u5f0f\u6709\u8bef(\u53ea\u80fd\u586b\u5199\u5927\u4e8e0\u7684\u6b63\u6574\u6570)");
            }
            if (CollectionUtil.listEmpty((List)reqVo.getSfaActFileReqVos())) {
                throw new BusinessException("\u9648\u5217\u6d3b\u52a8,\u8bf7\u4e0a\u4f20\u5bf9\u5e94\u793a\u4f8b\u56fe\u7247");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaActTaskReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaActTaskEntity entity = (SfaActTaskEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaActTaskEntity.class));
        String code = CodeUtil.createCode();
        entity.setActCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
    }

    public void saveData(SfaActTaskReqVo reqVo, SfaActTaskEntity entity) {
        List sfaActRangeContainList;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaActRangeReqContainVos())) {
            sfaActRangeContainList = reqVo.getSfaActRangeReqContainVos().stream().map(o -> {
                SfaActRangeEntity actRangeEntity = new SfaActRangeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actRangeEntity));
                actRangeEntity.setActCode(entity.getActCode());
                actRangeEntity.setRangeType(SfaCommonEnum.rangeTypeEnum.One.getVal());
                return actRangeEntity;
            }).collect(Collectors.toList());
            this.iSfaActRangeService.saveBatch(sfaActRangeContainList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaActRangeReqNotContainVos())) {
            sfaActRangeContainList = reqVo.getSfaActRangeReqNotContainVos().stream().map(o -> {
                SfaActRangeEntity actRangeEntity = new SfaActRangeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)actRangeEntity));
                actRangeEntity.setActCode(entity.getActCode());
                actRangeEntity.setRangeType(SfaCommonEnum.rangeTypeEnum.Two.getVal());
                return actRangeEntity;
            }).collect(Collectors.toList());
            this.iSfaActRangeService.saveBatch(sfaActRangeContainList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaActProductReqVos())) {
            List productEntityList = reqVo.getSfaActProductReqVos().stream().map(o -> {
                SfaActProductEntity productEntity = new SfaActProductEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)productEntity));
                productEntity.setActCode(entity.getActCode());
                return productEntity;
            }).collect(Collectors.toList());
            this.iSfaActProductService.saveBatch(productEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaActFileReqVos())) {
            List fileEntityList = reqVo.getSfaActFileReqVos().stream().map(o -> {
                SfaActFileEntity fileEntity = new SfaActFileEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fileEntity));
                fileEntity.setActCode(entity.getActCode());
                return fileEntity;
            }).collect(Collectors.toList());
            this.iSfaActFileService.saveBatch(fileEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaActTaskReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaActTaskEntity entity = (SfaActTaskEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaActTaskReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.sfaActTaskMapper.deleteProductsByParams(reqVo);
        List actCodes = list.stream().map(SfaActTaskRespVo::getActCode).collect(Collectors.toList());
        reqVo.setActCodes(actCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaActTaskReqVo reqVo) {
        if (null != reqVo && (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getActCodes()) || StringUtil.isNotEmpty((String)reqVo.getActCode()))) {
            SfaActRangeReqVo rangeReqVo = new SfaActRangeReqVo();
            rangeReqVo.setActCode(reqVo.getActCode());
            rangeReqVo.setActCodes(reqVo.getActCodes());
            this.sfaActRangeMapper.deleteProductsByParams(rangeReqVo);
            SfaActProductReqVo productReqVo = new SfaActProductReqVo();
            productReqVo.setActCode(reqVo.getActCode());
            productReqVo.setActCodes(reqVo.getActCodes());
            this.sfaActProductMapper.deleteProductsByParams(productReqVo);
            SfaActFileReqVo fileReqVo = new SfaActFileReqVo();
            fileReqVo.setActCode(reqVo.getActCode());
            fileReqVo.setActCodes(reqVo.getActCodes());
            this.sfaActFileMapper.deleteProductsByParams(fileReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaActTaskReqVo reqVo) {
        List sfaActTaskEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaActTaskEntities = this.sfaActTaskMapper.selectBatchIds(reqVo.getIds())))) {
            sfaActTaskEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaActTaskEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaActTaskReqVo reqVo) {
        List sfaActTaskEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaActTaskEntities = this.sfaActTaskMapper.selectBatchIds(reqVo.getIds())))) {
            sfaActTaskEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaActTaskEntities);
    }
}

