/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.checkin.mapper.SfaCheckInGroupMapper;
import com.biz.crm.checkin.model.SfaCheckInDateEntity;
import com.biz.crm.checkin.model.SfaCheckInGroupEntity;
import com.biz.crm.checkin.model.SfaCheckInGroupTypeEntity;
import com.biz.crm.checkin.model.SfaCheckInOrgEntity;
import com.biz.crm.checkin.model.SfaCheckInPlaceEntity;
import com.biz.crm.checkin.model.SfaCheckInUserEntity;
import com.biz.crm.checkin.service.ISfaCheckInDateService;
import com.biz.crm.checkin.service.ISfaCheckInGroupService;
import com.biz.crm.checkin.service.ISfaCheckInGroupTypeService;
import com.biz.crm.checkin.service.ISfaCheckInOrgService;
import com.biz.crm.checkin.service.ISfaCheckInPlaceService;
import com.biz.crm.checkin.service.ISfaCheckInSignGroupReportService;
import com.biz.crm.checkin.service.ISfaCheckInTypeService;
import com.biz.crm.checkin.service.ISfaCheckInUserService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.VisitStepFromEnum;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInDateReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupSaveReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupTypeReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInOrgReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInTypeReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInUserReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInPlaceRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaCheckInGroupServiceExpandImpl"})
public class SfaCheckInGroupServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCheckInGroupMapper, SfaCheckInGroupEntity>
implements ISfaCheckInGroupService {
    private static final Logger log = LoggerFactory.getLogger(SfaCheckInGroupServiceImpl.class);
    @Resource
    private SfaCheckInGroupMapper sfaCheckInGroupMapper;
    @Autowired
    private ISfaCheckInDateService iSfaCheckInDateService;
    @Autowired
    private ISfaCheckInGroupTypeService iSfaCheckInGroupTypeService;
    @Autowired
    private ISfaCheckInTypeService iSfaCheckInTypeService;
    @Autowired
    private ISfaCheckInOrgService iSfaCheckInOrgService;
    @Autowired
    private ISfaCheckInUserService iSfaCheckInUserService;
    @Autowired
    private ISfaCheckInSignGroupReportService iSfaCheckInSignGroupReportService;
    @Resource
    private ISfaCheckInPlaceService iSfaCheckInPlaceService;

    @Override
    public PageResult<SfaCheckInGroupRespVo> findList(SfaCheckInGroupReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaCheckInGroupRespVo> list = this.sfaCheckInGroupMapper.findList((Page<SfaCheckInGroupRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)vo.getEnableStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaCheckInGroupRespVo> myCheckInGroup(SfaCheckInGroupReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaCheckInGroupRespVo> list = this.sfaCheckInGroupMapper.findList((Page<SfaCheckInGroupRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> {
                this.loadingGroupTypeInfo((SfaCheckInGroupRespVo)vo);
                vo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)vo.getEnableStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaCheckInGroupRespVo query(String id) {
        SfaCheckInGroupEntity entity = (SfaCheckInGroupEntity)((Object)this.sfaCheckInGroupMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SfaCheckInGroupEntity.class).eq(BaseIdEntity::getId, (Object)id)));
        if (entity == null) {
            throw new BusinessException("id\u9519\u8bef");
        }
        SfaCheckInGroupRespVo respVo = (SfaCheckInGroupRespVo)CrmBeanUtil.copy((Object)((Object)entity), SfaCheckInGroupRespVo.class);
        this.loadingInfo(respVo);
        return respVo;
    }

    @Override
    public SfaCheckInGroupRespVo getByGroupCode(String groupCode) {
        SfaCheckInGroupEntity entity = (SfaCheckInGroupEntity)((Object)this.sfaCheckInGroupMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SfaCheckInGroupEntity.class).eq(SfaCheckInGroupEntity::getGroupCode, (Object)groupCode)));
        if (entity == null) {
            throw new BusinessException("\u7f16\u7801\u9519\u8bef");
        }
        SfaCheckInGroupRespVo respVo = (SfaCheckInGroupRespVo)CrmBeanUtil.copy((Object)((Object)entity), SfaCheckInGroupRespVo.class);
        this.loadingInfo(respVo);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaCheckInGroupSaveReqVo reqVo) {
        SfaCheckInGroupEntity entity = (SfaCheckInGroupEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaCheckInGroupEntity.class));
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            SfaCheckInGroupEntity old = (SfaCheckInGroupEntity)((Object)this.sfaCheckInGroupMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SfaCheckInGroupEntity.class).eq(BaseIdEntity::getId, (Object)reqVo.getId())));
            if (old == null) {
                throw new BusinessException("\u7b7e\u5230\u7ec4id\u9519\u8bef");
            }
            entity.setGroupCode(old.getGroupCode());
        } else {
            entity.setGroupCode(CodeUtil.getCodeDefault());
        }
        this.infoCheck(reqVo);
        this.deleteInfo(entity.getGroupCode());
        this.saveOrUpdate((Object)entity);
        this.saveInfo(entity.getGroupCode(), reqVo);
        this.iSfaCheckInSignGroupReportService.refreshReport(entity.getGroupCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaCheckInGroupReqVo reqVo) {
        List sfaCheckInGroupEntities = this.sfaCheckInGroupMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaCheckInGroupEntities)) {
            sfaCheckInGroupEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                o.setEnableStatus(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInGroupEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaCheckInGroupReqVo reqVo) {
        List sfaCheckInGroupEntities = this.sfaCheckInGroupMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaCheckInGroupEntities)) {
            sfaCheckInGroupEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaCheckInGroupEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaCheckInGroupReqVo reqVo) {
        List sfaCheckInGroupEntities = this.sfaCheckInGroupMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaCheckInGroupEntities)) {
            sfaCheckInGroupEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaCheckInGroupEntities);
    }

    private void loadingGroupTypeInfo(SfaCheckInGroupRespVo vo) {
        SfaCheckInGroupTypeReqVo groupTypeReqVo = new SfaCheckInGroupTypeReqVo();
        groupTypeReqVo.setGroupCode(vo.getGroupCode());
        List groupTypeList = this.iSfaCheckInGroupTypeService.findList(groupTypeReqVo).getData();
        if (groupTypeList != null && groupTypeList.size() > 0) {
            SfaCheckInTypeReqVo typeReqVo = new SfaCheckInTypeReqVo();
            typeReqVo.setIds(groupTypeList.stream().map(o -> o.getSfaCheckInTypeId()).collect(Collectors.toList()));
            vo.setTypeRespVos(this.iSfaCheckInTypeService.findList(typeReqVo).getData());
            if (CollectionUtils.isNotEmpty((Collection)vo.getTypeRespVos())) {
                String typeNames = vo.getTypeRespVos().stream().map(o -> o.getTypeName()).collect(Collectors.joining(","));
                vo.setTypeNames(typeNames);
            }
        }
    }

    private void loadingInfo(SfaCheckInGroupRespVo vo) {
        SfaCheckInDateReqVo dateReqVo = new SfaCheckInDateReqVo();
        dateReqVo.setGroupCode(vo.getGroupCode());
        vo.setDateRespVos(this.iSfaCheckInDateService.findList(dateReqVo).getData());
        this.loadingGroupTypeInfo(vo);
        SfaCheckInOrgReqVo orgReqVo = new SfaCheckInOrgReqVo();
        orgReqVo.setGroupCode(vo.getGroupCode());
        vo.setOrgRespVos(this.iSfaCheckInOrgService.findList(orgReqVo).getData());
        SfaCheckInUserReqVo userReqVo = new SfaCheckInUserReqVo();
        userReqVo.setGroupCode(vo.getGroupCode());
        vo.setUserRespVos(this.iSfaCheckInUserService.findList(userReqVo).getData());
        List entityList = this.iSfaCheckInPlaceService.list((Wrapper)Wrappers.lambdaQuery(SfaCheckInPlaceEntity.class).eq(SfaCheckInPlaceEntity::getGroupCode, (Object)vo.getGroupCode()));
        List placeRespVos = CrmBeanUtil.copyList((List)entityList, SfaCheckInPlaceRespVo.class);
        vo.setPlaceRespVos(placeRespVos);
    }

    private void infoCheck(SfaCheckInGroupSaveReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getGroupName(), (String)"\u7b7e\u5230\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTimeType(), (String)"\u65f6\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getGroupTypeReqVos(), (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)reqVo.getOrgReqVos()) && CollectionUtils.isEmpty((Collection)reqVo.getUserReqVos())) {
            throw new BusinessException("\u8bf7\u6dfb\u52a0\u6253\u5361\u7ec4\u7ec7\u6216\u8005\u6253\u5361\u4eba\u5458");
        }
        if (VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(reqVo.getTimeType())) {
            List dateReqVos = reqVo.getDateReqVos();
            AssertUtils.isNotEmpty((Collection)dateReqVos, (String)"\u65f6\u95f4\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            dateReqVos.forEach(data -> {
                int compareTo = LocalDate.parse(data.getStartTime()).compareTo(LocalDate.parse(data.getEndTime()));
                if (0 < compareTo) {
                    throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
                }
            });
        }
        reqVo.getGroupTypeReqVos().forEach(vo -> {
            AssertUtils.isNotEmpty((String)vo.getSfaCheckInTypeId(), (String)"\u6253\u5361\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a");
            this.iSfaCheckInTypeService.query(vo.getSfaCheckInTypeId());
        });
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getOrgReqVos())) {
            reqVo.getOrgReqVos().forEach(vo -> {
                AssertUtils.isNotEmpty((String)vo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)vo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getUserReqVos())) {
            reqVo.getUserReqVos().forEach(vo -> {
                AssertUtils.isNotEmpty((String)vo.getRealName(), (String)"\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)vo.getUserName(), (String)"\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getPlaceReqVos())) {
            reqVo.getPlaceReqVos().forEach(vo -> {
                AssertUtils.isNotEmpty((String)vo.getPlaceLatin(), (String)"\u5730\u70b9\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)vo.getPlaceLngin(), (String)"\u5730\u70b9\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)vo.getAddress(), (String)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)vo.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
    }

    private void deleteInfo(String groupCode) {
        this.iSfaCheckInDateService.deleteByGroupCode(groupCode);
        this.iSfaCheckInGroupTypeService.deleteByGroupCode(groupCode);
        this.iSfaCheckInOrgService.deleteByGroupCode(groupCode);
        this.iSfaCheckInUserService.deleteByGroupCode(groupCode);
        this.iSfaCheckInPlaceService.remove((Wrapper)Wrappers.lambdaQuery(SfaCheckInPlaceEntity.class).eq(SfaCheckInPlaceEntity::getGroupCode, (Object)groupCode));
    }

    private void saveInfo(String groupCode, SfaCheckInGroupSaveReqVo reqVo) {
        List list;
        List<Object> listDate = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getDateReqVos()) && VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(reqVo.getTimeType())) {
            listDate = reqVo.getDateReqVos().stream().map(o -> {
                SfaCheckInDateEntity entity = (SfaCheckInDateEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, SfaCheckInDateEntity.class)));
                entity.setGroupCode(groupCode);
                entity.setTimeType(VisitStepFromEnum.timeType.DIY_TIME.getValue());
                return entity;
            }).collect(Collectors.toList());
        } else if (VisitStepFromEnum.timeType.LONG_TIME.getValue().equals(reqVo.getTimeType())) {
            SfaCheckInDateEntity sfaCheckInDateEntity = new SfaCheckInDateEntity();
            sfaCheckInDateEntity.setGroupCode(groupCode);
            sfaCheckInDateEntity.setStartTime(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
            sfaCheckInDateEntity.setTimeType(VisitStepFromEnum.timeType.LONG_TIME.getValue());
            listDate.add((Object)sfaCheckInDateEntity);
        }
        this.iSfaCheckInDateService.saveOrUpdateBatch(listDate);
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getGroupTypeReqVos())) {
            list = reqVo.getGroupTypeReqVos().stream().map(o -> {
                SfaCheckInGroupTypeEntity entity = (SfaCheckInGroupTypeEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, SfaCheckInGroupTypeEntity.class)));
                entity.setGroupCode(groupCode);
                return entity;
            }).collect(Collectors.toList());
            this.iSfaCheckInGroupTypeService.saveOrUpdateBatch(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getOrgReqVos())) {
            list = reqVo.getOrgReqVos().stream().map(o -> {
                SfaCheckInOrgEntity entity = (SfaCheckInOrgEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, SfaCheckInOrgEntity.class)));
                entity.setGroupCode(groupCode);
                entity.setId(null);
                return entity;
            }).collect(Collectors.toList());
            this.iSfaCheckInOrgService.saveOrUpdateBatch(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getUserReqVos())) {
            list = reqVo.getUserReqVos().stream().map(o -> {
                SfaCheckInUserEntity entity = (SfaCheckInUserEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, SfaCheckInUserEntity.class)));
                entity.setGroupCode(groupCode);
                return entity;
            }).collect(Collectors.toList());
            this.iSfaCheckInUserService.saveOrUpdateBatch(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getPlaceReqVos())) {
            list = reqVo.getPlaceReqVos().stream().map(o -> {
                SfaCheckInPlaceEntity entity = (SfaCheckInPlaceEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, SfaCheckInPlaceEntity.class)));
                entity.setGroupCode(groupCode);
                return entity;
            }).collect(Collectors.toList());
            this.iSfaCheckInPlaceService.saveOrUpdateBatch(list);
        }
    }
}

