/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.SfaCustomerBusinessDetailMapper;
import com.biz.crm.customer.model.SfaCustomerBusinessDetailEntity;
import com.biz.crm.customer.service.SfaCustomerBusinessDetailService;
import com.biz.crm.nebular.sfa.customer.req.SfaCustomerBusinessDetailReqVo;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerBusinessDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SfaCustomerBusinessDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCustomerBusinessDetailMapper, SfaCustomerBusinessDetailEntity>
implements SfaCustomerBusinessDetailService {
    private static final Logger log = LoggerFactory.getLogger(SfaCustomerBusinessDetailServiceImpl.class);
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private SfaCustomerBusinessDetailMapper sfaCustomerBusinessDetailMapper;

    @Override
    public PageResult<SfaCustomerBusinessDetailRespVo> findList(SfaCustomerBusinessDetailReqVo reqVo) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((String)reqVo.getClientCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)reqVo.getClientCode()));
        }
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"sfa_visit_step_activity_display_execution_es_data", "sfa_visit_step_activity_cost_execution_es_data", "sfa_visit_step_collet_es_data", "sfa_visit_step_order_es_data", "sfa_visit_step_store_check_es_data"}).withQuery((QueryBuilder)boolQueryBuilder).withSort(SortBuilders.fieldSort((String)"createDate").unmappedType("keyword").order(SortOrder.DESC)).withSort(SortBuilders.fieldSort((String)"createDateSecond").unmappedType("keyword").order(SortOrder.DESC)).withPageable((Pageable)PageRequest.of((int)reqVo.getPageNum(), (int)reqVo.getPageSize())).build();
        ArrayList result = new ArrayList();
        this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> {
            SearchHit[] searchHits = response.getHits().getHits();
            if (null == searchHits) {
                return result;
            }
            Arrays.stream(searchHits).forEach(h -> {
                Map source = h.getSourceAsMap();
                if (null != source) {
                    HashMap sfaVisitStepFrom;
                    SfaCustomerBusinessDetailRespVo user = (SfaCustomerBusinessDetailRespVo)JSON.parseObject((String)JSON.toJSONString((Object)source), SfaCustomerBusinessDetailRespVo.class);
                    if (!ObjectUtils.isEmpty(source.get("id"))) {
                        user.setBusinessCode(source.get("id").toString());
                    }
                    if (!ObjectUtils.isEmpty(source.get("sfaVisitStepFrom")) && !ObjectUtils.isEmpty((sfaVisitStepFrom = (HashMap)source.get("sfaVisitStepFrom")).get("fromName"))) {
                        String fromName = (String)sfaVisitStepFrom.get("fromName");
                        String[] split = fromName.split("-");
                        user.setBusinessType(split[0]);
                    }
                    result.add(user);
                }
            });
            return result;
        });
        return PageResult.builder().data(result).count(Long.valueOf(0L)).build();
    }

    @Override
    public void save(SfaCustomerBusinessDetailReqVo reqVo) {
        this.deCheck(reqVo);
        SfaCustomerBusinessDetailEntity entity = (SfaCustomerBusinessDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaCustomerBusinessDetailEntity.class));
        this.save((Object)entity);
    }

    public void deCheck(SfaCustomerBusinessDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBusinessType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBusinessCode(), (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

