/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u5e97\u9762\u68c0\u67e5\u5206\u9875-\u53c2\u6570")
public class GetStoreCheckReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u5ba2\u6237\u7f16\u7801")
    private String clientCode;
    @ApiModelProperty(value="\u5ba2\u6237\u540d\u79f0")
    private String clientName;
    @ApiModelProperty(value="\u4eba\u5458\u59d3\u540d")
    private String realName;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isBlank((CharSequence)this.getStepCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode.keyword", (String)this.getStepCode()));
        if (StringUtils.isNotBlank((CharSequence)this.getClientCode())) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"clientCode.keyword", (Object)this.getClientCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getClientName())) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"clientName", (Object)this.getClientName()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getRealName())) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"realName", (Object)this.getRealName()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"checkTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetStoreCheckReq)) {
            return false;
        }
        GetStoreCheckReq other = (GetStoreCheckReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        return !(this$realName == null ? other$realName != null : !this$realName.equals(other$realName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetStoreCheckReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetStoreCheckReq(clientCode=" + this.getClientCode() + ", clientName=" + this.getClientName() + ", realName=" + this.getRealName() + ")";
    }
}

