/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.mapper.SfaActivityBgProductMapper;
import com.biz.crm.activity.mapper.SfaActivityBgSetmealMapper;
import com.biz.crm.activity.mapper.SfaActivityExecutionMapper;
import com.biz.crm.activity.mapper.SfaActivityProductMapper;
import com.biz.crm.activity.mapper.SfaActivityRangeMapper;
import com.biz.crm.activity.model.SfaActivityBgProductEntity;
import com.biz.crm.activity.model.SfaActivityBgSetmealEntity;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.activity.model.SfaActivityProductEntity;
import com.biz.crm.activity.model.SfaActivityRangeEntity;
import com.biz.crm.activity.req.ActivityExecutionResolveContext;
import com.biz.crm.activity.req.ActivityExecutionResolveData;
import com.biz.crm.activity.service.ISfaActivityBgProductService;
import com.biz.crm.activity.service.ISfaActivityBgSetmealService;
import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.activity.service.ISfaActivityProductService;
import com.biz.crm.activity.service.ISfaActivityRangeService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityBgSetmealReqVo;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityBgProductRespVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityBgSetmealRespVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityProductRespVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityRangeRespVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.picture.mapper.SfaVisitPictureMapper;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JobHelper;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaActivityExecutionServiceExpandImpl"})
@Transactional
public class SfaActivityExecutionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaActivityExecutionMapper, SfaActivityExecutionEntity>
implements ISfaActivityExecutionService,
JobHelper.JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(SfaActivityExecutionServiceImpl.class);
    @Resource
    private SfaActivityExecutionMapper sfaActivityExecutionMapper;
    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private SfaActivityRangeMapper sfaActivityRangeMapper;
    @Resource
    private ISfaActivityRangeService sfaActivityRangeService;
    @Resource
    private SfaActivityProductMapper sfaActivityProductMapper;
    @Resource
    private ISfaActivityProductService sfaActivityProductService;
    @Resource
    private SfaActivityBgSetmealMapper sfaActivityBgSetmealMapper;
    @Resource
    private ISfaActivityBgSetmealService sfaActivityBgSetmealService;
    @Resource
    private SfaActivityBgProductMapper sfaActivityBgProductMapper;
    @Resource
    private ISfaActivityBgProductService sfaActivityBgProductService;
    @Resource
    private SfaVisitPictureMapper sfaVisitPictureMapper;
    @Resource
    private ISfaVisitPictureService sfaVisitPictureService;
    @Resource
    private JobHelper jobHelper;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    @Override
    @CrmDictMethod
    public PageResult<SfaActivityExecutionRespVo> findList(SfaActivityExecutionReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaActivityExecutionRespVo> list = this.sfaActivityExecutionMapper.findList((Page<SfaActivityExecutionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public SfaActivityExecutionRespVo queryDetailById(String id) {
        List setmealEntitieList;
        List pictureEntities;
        List productEntityList;
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        SfaActivityExecutionEntity sfaActivityExecutionEntity = (SfaActivityExecutionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaActivityExecutionEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u660e\u7ec6");
        }
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = (SfaActivityExecutionRespVo)CrmBeanUtil.copy((Object)((Object)sfaActivityExecutionEntity), SfaActivityExecutionRespVo.class);
        StringBuilder stringBuilder = new StringBuilder();
        String[] activityRequireList = sfaActivityExecutionRespVo.getActivityRequire().split(",");
        for (int i = 0; i < activityRequireList.length; ++i) {
            if (stringBuilder != null && stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append((String)SfaActivityEnum.activityRequire.GETMAP.get(activityRequireList[i]));
        }
        sfaActivityExecutionRespVo.setActivityRequireDesc(stringBuilder.toString());
        List rangeEntityList = ((LambdaQueryChainWrapper)this.sfaActivityRangeService.lambdaQuery().eq(SfaActivityRangeEntity::getActivityExecutionId, (Object)sfaActivityExecutionEntity.getId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)rangeEntityList)) {
            List rangeRespVos = CrmBeanUtil.copyList((List)rangeEntityList, SfaActivityRangeRespVo.class);
            Map<String, List<SfaActivityRangeRespVo>> mapRange = rangeRespVos.stream().collect(Collectors.groupingBy(SfaActivityRangeRespVo::getRangeType));
            for (Map.Entry<String, List<SfaActivityRangeRespVo>> map : mapRange.entrySet()) {
                if (map.getKey().equals(SfaActivityEnum.rangeType.CHANNEL.getVal())) {
                    sfaActivityExecutionRespVo.setChannelRangeList(map.getValue());
                }
                if (map.getKey().equals(SfaActivityEnum.rangeType.ORG.getVal())) {
                    sfaActivityExecutionRespVo.setOrgRangeList(map.getValue());
                }
                if (!map.getKey().equals(SfaActivityEnum.rangeType.CUSTOMER.getVal())) continue;
                sfaActivityExecutionRespVo.setCustomerRangeList(map.getValue());
            }
            sfaActivityExecutionRespVo.setActivityRangeList(rangeRespVos);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(productEntityList = ((LambdaQueryChainWrapper)this.sfaActivityProductService.lambdaQuery().eq(SfaActivityProductEntity::getActivityExecutionId, (Object)sfaActivityExecutionEntity.getId())).list()))) {
            List productRespVos = CrmBeanUtil.copyList((List)productEntityList, SfaActivityProductRespVo.class);
            sfaActivityExecutionRespVo.setActivityProductList(productRespVos);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(pictureEntities = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)sfaActivityExecutionEntity.getId())).list()))) {
            List pictureRespVos = CrmBeanUtil.copyList((List)pictureEntities, SfaVisitPictureRespVo.class);
            sfaActivityExecutionRespVo.setVisitPictureList(pictureRespVos);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(setmealEntitieList = ((LambdaQueryChainWrapper)this.sfaActivityBgSetmealService.lambdaQuery().eq(SfaActivityBgSetmealEntity::getActivityExecutionId, (Object)sfaActivityExecutionEntity.getId())).list()))) {
            List activityBgSetmealList = CrmBeanUtil.copyList((List)setmealEntitieList, SfaActivityBgSetmealRespVo.class);
            List productBgEntityList = ((LambdaQueryChainWrapper)this.sfaActivityBgProductService.lambdaQuery().eq(SfaActivityBgProductEntity::getActivityExecutionId, (Object)sfaActivityExecutionEntity.getId())).list();
            List bgProductRespVos = CrmBeanUtil.copyList((List)productBgEntityList, SfaActivityBgProductRespVo.class);
            Map<String, List<SfaActivityBgProductRespVo>> mapRange = bgProductRespVos.stream().collect(Collectors.groupingBy(SfaActivityBgProductRespVo::getSetmealId));
            for (SfaActivityBgSetmealRespVo activityBgSetmeal : activityBgSetmealList) {
                if (!mapRange.containsKey(activityBgSetmeal.getId())) continue;
                List<SfaActivityBgProductRespVo> productRespVoList = mapRange.get(activityBgSetmeal.getId());
                Map<String, List<SfaActivityBgProductRespVo>> mapProductRange = productRespVoList.stream().collect(Collectors.groupingBy(SfaActivityBgProductRespVo::getItmeType));
                if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.bp.getVal())) {
                    activityBgSetmeal.setBpBgProductList(mapProductRange.get(SfaActivityEnum.bpItemType.bp.getVal()));
                }
                if (!mapProductRange.containsKey(SfaActivityEnum.bpItemType.zp.getVal())) continue;
                activityBgSetmeal.setZpBgProductList(mapProductRange.get(SfaActivityEnum.bpItemType.zp.getVal()));
            }
            sfaActivityExecutionRespVo.setActivityBgSetmealList(activityBgSetmealList);
        }
        return sfaActivityExecutionRespVo;
    }

    @Override
    public SfaActivityExecutionRespVo query(SfaActivityExecutionReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaActivityExecutionReqVo reqVo) {
        this.checkParam(reqVo);
        SfaActivityExecutionEntity entity = (SfaActivityExecutionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaActivityExecutionEntity.class));
        entity.setActivityCode(CodeUtil.getCodeDefault());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
        String activityExecutionId = entity.getId();
        reqVo.getActivityRangeList().forEach(data -> data.setActivityExecutionId(activityExecutionId));
        List activityRangeEntityList = reqVo.getActivityRangeList().stream().map(v -> {
            SfaActivityRangeEntity rangeEntity = (SfaActivityRangeEntity)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaActivityRangeEntity.class)));
            rangeEntity.setId(null);
            return rangeEntity;
        }).collect(Collectors.toList());
        this.sfaActivityRangeService.saveBatch(activityRangeEntityList);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getVisitPictureList())) {
            List sfaVisitPictureEntities = CrmBeanUtil.copyList((List)reqVo.getVisitPictureList(), SfaVisitPictureEntity.class);
            sfaVisitPictureEntities.forEach(data -> data.setBusinessId(activityExecutionId));
            this.sfaVisitPictureService.saveBatch(sfaVisitPictureEntities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getActivityProductList())) {
            List activityProductEntities = CrmBeanUtil.copyList((List)reqVo.getActivityProductList(), SfaActivityProductEntity.class);
            activityProductEntities.forEach(data -> data.setActivityExecutionId(activityExecutionId));
            this.sfaActivityProductService.saveBatch(activityProductEntities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getActivityBgSetmealList())) {
            for (SfaActivityBgSetmealReqVo setmealReqVo : reqVo.getActivityBgSetmealList()) {
                SfaActivityBgSetmealEntity setmealEntity = (SfaActivityBgSetmealEntity)((Object)CrmBeanUtil.copy((Object)setmealReqVo, SfaActivityBgSetmealEntity.class));
                setmealEntity.setActivityExecutionId(activityExecutionId);
                this.sfaActivityBgSetmealService.save((Object)setmealEntity);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)setmealReqVo.getActivityBgProductList())) continue;
                List activityBgProductEntities = CrmBeanUtil.copyList((List)setmealReqVo.getActivityBgProductList(), SfaActivityBgProductEntity.class);
                activityBgProductEntities.forEach(data -> {
                    data.setActivityExecutionId(activityExecutionId);
                    data.setSetmealId(setmealEntity.getId());
                });
                this.sfaActivityBgProductService.saveBatch(activityBgProductEntities);
            }
        }
    }

    private void checkParam(SfaActivityExecutionReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotEmpty((String)reqVo.getActivityType(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
        if (!SfaActivityEnum.activityType.GETMAP.containsKey(reqVo.getActivityType())) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef:" + reqVo.getActivityType());
        }
        AssertUtils.isNotEmpty((String)reqVo.getActivityStartTime(), (String)"\u6d3b\u52a8\u6267\u884c\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActivityEndTime(), (String)"\u6d3b\u52a8\u6267\u884c\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActivityRequire(), (String)"\u6d3b\u52a8\u8981\u6c42\u4e3a\u7a7a\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActivityName(), (String)"\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getActivityRangeList(), (String)"\u6d3b\u52a8\u8303\u56f4\u4e3a\u7a7a");
        LocalDate activityStartTime = null;
        LocalDate activityEndTime = null;
        LocalDate now = LocalDate.now();
        try {
            activityStartTime = LocalDate.parse(reqVo.getActivityStartTime());
            activityEndTime = LocalDate.parse(reqVo.getActivityEndTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u65f6\u95f4\u9519\u8bef");
        }
        if (!activityStartTime.isBefore(activityEndTime)) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6d3b\u52a8\u6267\u884c\u7ed3\u675f\u65f6\u95f4");
        }
        if (now.isAfter(activityEndTime)) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (now.isBefore(activityStartTime)) {
            reqVo.setActivityStatus(SfaActivityEnum.activityStatus.NOT_START.getVal());
        } else {
            reqVo.setActivityStatus(SfaActivityEnum.activityStatus.ALREADY_START.getVal());
        }
        reqVo.getActivityRangeList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getRangeType(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            if (!SfaActivityEnum.rangeType.GETMAP.containsKey(data.getRangeType())) {
                throw new BusinessException("\u6d3b\u52a8\u8303\u56f4\u7c7b\u578b\u9519\u8bef");
            }
            AssertUtils.isNotEmpty((String)data.getCode(), (String)"\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getName(), (String)"\u540d\u79f0\u4e3a\u7a7a");
        });
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(reqVo.getActivityType())) {
            AssertUtils.isNotEmpty((String)reqVo.getSalesVolume(), (String)"\u6d3b\u52a8\u9884\u4f30\u9500\u552e\u989d\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getApplyAmount(), (String)"\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7\u91d1\u989d\u4e3a\u7a7a");
        } else if (reqVo.getActivityFrequency() == null) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaActivityExecutionReqVo reqVo) {
        this.checkParam(reqVo);
        SfaActivityExecutionEntity entity = (SfaActivityExecutionEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        String activityType2 = entity.getActivityType();
        String id = entity.getId();
        entity = (SfaActivityExecutionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaActivityExecutionEntity.class));
        entity.setId(id);
        entity.setActChanged(YesNoEnum.yesNoEnum.YES.getValue());
        entity.setActivityType(activityType2);
        this.updateById((Object)entity);
        LambdaQueryWrapper productQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaActivityProductEntity::getActivityExecutionId, (Object)id);
        LambdaQueryWrapper rangeQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaActivityRangeEntity::getActivityExecutionId, (Object)id);
        LambdaQueryWrapper picQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaVisitPictureEntity::getBusinessId, (Object)id);
        LambdaQueryWrapper bgSetmealQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaActivityBgSetmealEntity::getActivityExecutionId, (Object)id);
        LambdaQueryWrapper bgProductQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaActivityBgProductEntity::getActivityExecutionId, (Object)id);
        this.sfaActivityProductMapper.delete((Wrapper)productQueryWrapper);
        this.sfaActivityRangeMapper.delete((Wrapper)rangeQueryWrapper);
        this.sfaVisitPictureMapper.delete((Wrapper)picQueryWrapper);
        this.sfaActivityBgSetmealMapper.delete((Wrapper)bgSetmealQueryWrapper);
        this.sfaActivityBgProductMapper.delete((Wrapper)bgProductQueryWrapper);
        reqVo.getActivityRangeList().forEach(data -> data.setActivityExecutionId(id));
        List activityRangeEntityList = CrmBeanUtil.copyList((List)reqVo.getActivityRangeList(), SfaActivityRangeEntity.class);
        this.sfaActivityRangeService.saveBatch(activityRangeEntityList);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getVisitPictureList())) {
            List sfaVisitPictureEntities = CrmBeanUtil.copyList((List)reqVo.getVisitPictureList(), SfaVisitPictureEntity.class);
            sfaVisitPictureEntities.forEach(data -> data.setBusinessId(id));
            this.sfaVisitPictureService.saveBatch(sfaVisitPictureEntities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getActivityProductList())) {
            List activityProductEntities = CrmBeanUtil.copyList((List)reqVo.getActivityProductList(), SfaActivityProductEntity.class);
            activityProductEntities.forEach(data -> data.setActivityExecutionId(id));
            this.sfaActivityProductService.saveBatch(activityProductEntities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getActivityBgSetmealList())) {
            for (SfaActivityBgSetmealReqVo setmealReqVo : reqVo.getActivityBgSetmealList()) {
                SfaActivityBgSetmealEntity setmealEntity = (SfaActivityBgSetmealEntity)((Object)CrmBeanUtil.copy((Object)setmealReqVo, SfaActivityBgSetmealEntity.class));
                setmealEntity.setActivityExecutionId(id);
                this.sfaActivityBgSetmealService.save((Object)setmealEntity);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)setmealReqVo.getActivityBgProductList())) continue;
                List activityBgProductEntities = CrmBeanUtil.copyList((List)setmealReqVo.getActivityBgProductList(), SfaActivityBgProductEntity.class);
                activityBgProductEntities.forEach(data -> {
                    data.setActivityExecutionId(id);
                    data.setSetmealId(setmealEntity.getId());
                });
                this.sfaActivityBgProductService.saveBatch(activityBgProductEntities);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaActivityExecutionEntities = this.sfaActivityExecutionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaActivityExecutionEntities)) {
            sfaActivityExecutionEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                this.sfaVisitStepActivityExecutionService.cleanExecutionData((SfaActivityExecutionEntity)((Object)o));
            });
        }
        this.updateBatchById(sfaActivityExecutionEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaActivityExecutionEntities = this.sfaActivityExecutionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaActivityExecutionEntities)) {
            sfaActivityExecutionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaActivityExecutionEntities);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaActivityExecutionEntities = this.sfaActivityExecutionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaActivityExecutionEntities)) {
            sfaActivityExecutionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                this.sfaVisitStepActivityExecutionService.cleanExecutionData((SfaActivityExecutionEntity)((Object)o));
            });
        }
        this.updateBatchById(sfaActivityExecutionEntities);
    }

    @Transactional
    public void executeJob(Object jobParam) {
        this.resolveSfaVisitStepActivityExecution((Boolean)jobParam);
    }

    @Override
    @Transactional
    public void resolveSfaVisitStepActivityExecutionJob(Boolean compensation) {
        JobHelper.JobContext context = new JobHelper.JobContext();
        context.setJob(JobHelper.Job.RESOLVE_SFA_VISIT_STEP_ACTIVITY_EXECUTION_JOB);
        context.setExecutorBeanClass(SfaActivityExecutionServiceImpl.class);
        context.setJobParam((Object)compensation);
        this.jobHelper.executeJobSaveContext(context);
    }

    @Override
    @Transactional
    public void resolveSfaVisitStepActivityExecution(Boolean compensation) {
        LocalDate localDateNow = LocalDate.now();
        String now = localDateNow.format(CrmDateUtils.yyyyMMdd);
        List activityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).le(SfaActivityExecutionEntity::getActivityStartTime, (Object)now)).ge(SfaActivityExecutionEntity::getActivityEndTime, (Object)now)).list();
        for (SfaActivityExecutionEntity sfaActivityExecutionEntity : activityList) {
            this.sfaVisitStepActivityExecutionService.cleanExecutionData(sfaActivityExecutionEntity);
            long resolvedDays = 0L;
            log.warn("\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u89e3\u6790:\u5f00\u59cb\u89e3\u6790\u6d3b\u52a8 resolvedDays={},futureDays={},activityCode={}", new Object[]{resolvedDays, 2, sfaActivityExecutionEntity.getActivityCode()});
            this.doResolveSfaVisitStepActivityExecution(sfaActivityExecutionEntity, now, resolvedDays, localDateNow);
        }
    }

    private void doResolveSfaVisitStepActivityExecution(SfaActivityExecutionEntity sfaActivityExecutionEntity, String now, long resolvedDays, LocalDate localDateNow) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)sfaActivityExecutionEntity.getId())).set(SfaActivityExecutionEntity::getLastResolveEndDate, (Object)localDateNow.plusDays(1L).format(CrmDateUtils.yyyyMMdd))).set(SfaActivityExecutionEntity::getActChanged, (Object)YesNoEnum.yesNoEnum.NO.getValue())).update();
        ActivityExecutionResolveContext context = new ActivityExecutionResolveContext();
        while (!(resolvedDays >= 2L || SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(sfaActivityExecutionEntity.getActivityType()) && context.costActResolved(sfaActivityExecutionEntity.getActivityCode()))) {
            LocalDate resolveLocalDate = localDateNow.plusDays(resolvedDays);
            String resolveLocalDateStr = resolveLocalDate.format(CrmDateUtils.yyyyMMdd);
            if (resolveLocalDate.compareTo(LocalDate.parse(sfaActivityExecutionEntity.getActivityEndTime())) > 0) {
                log.warn("\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u89e3\u6790:\u5df2\u8d85\u51fa\u6d3b\u52a8\u7ed3\u675f\u65e5\u671f\uff0c\u7ed3\u675f\u8be5\u6d3b\u52a8\u7684\u89e3\u6790! resolveDate={},activityEndTime={},activityCode={}", new Object[]{resolveLocalDateStr, sfaActivityExecutionEntity.getActivityEndTime(), sfaActivityExecutionEntity.getActivityCode()});
                break;
            }
            if (this.checkFrequency(sfaActivityExecutionEntity, resolveLocalDate)) {
                ActivityExecutionResolveContext.DayContext dayContext = new ActivityExecutionResolveContext.DayContext();
                ActivityExecutionResolveData resolveData = new ActivityExecutionResolveData();
                resolveData.setResolveDate(resolveLocalDateStr);
                resolveData.setActivityExecutionEntity(sfaActivityExecutionEntity);
                dayContext.setResolveData(resolveData);
                context.setDayContext(dayContext);
                this.resolveClientActList(context);
            } else {
                log.warn("\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u89e3\u6790:\u5f53\u524d\u65e5\u671f\u4e0d\u6ee1\u8db3\u6d3b\u52a8\u6267\u884c\u9891\u7387\uff0c\u5ffd\u7565\u8be5\u65e5\u671f\u7684\u89e3\u6790! resolveDate={},activityFrequency={},activityCode={}", new Object[]{resolveLocalDateStr, sfaActivityExecutionEntity.getActivityFrequency(), sfaActivityExecutionEntity.getActivityCode()});
            }
            ++resolvedDays;
        }
    }

    private boolean checkFrequency(SfaActivityExecutionEntity sfaActivityExecutionEntity, LocalDate resolveDate) {
        if (SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal().equals(sfaActivityExecutionEntity.getActivityType())) {
            if (StringUtils.isBlank((CharSequence)sfaActivityExecutionEntity.getActivityFrequency())) {
                return false;
            }
            Integer frequency = Integer.valueOf(sfaActivityExecutionEntity.getActivityFrequency());
            LocalDate startDate = LocalDate.parse(sfaActivityExecutionEntity.getActivityStartTime());
            long days = resolveDate.toEpochDay() - startDate.toEpochDay();
            return days % (long)frequency.intValue() == 0L;
        }
        return true;
    }

    private void resolveClientActList(ActivityExecutionResolveContext context) {
        ActivityExecutionResolveContext.DayContext dayContext = context.getDayContext();
        ActivityExecutionResolveData resolveData = dayContext.getResolveData();
        SfaActivityExecutionEntity sfaActivityExecutionEntity = resolveData.getActivityExecutionEntity();
        List ranges = ((LambdaQueryChainWrapper)this.sfaActivityRangeService.lambdaQuery().eq(SfaActivityRangeEntity::getActivityExecutionId, (Object)sfaActivityExecutionEntity.getId())).list();
        Map<String, List<SfaActivityRangeEntity>> rangeTypeMapping = ranges.stream().collect(Collectors.groupingBy(SfaActivityRangeEntity::getRangeType));
        rangeTypeMapping.forEach((rangeType2, sfaActivityRangeEntities) -> {
            List<String> codes = sfaActivityRangeEntities.stream().map(SfaActivityRangeEntity::getCode).collect(Collectors.toList());
            if (SfaActivityEnum.rangeType.CUSTOMER.getVal().equals(rangeType2)) {
                List<SfaClientData> clientDataList = SfaClientHelper.loadClientDataList(null, codes);
                this.sendMq(clientDataList, context);
                return;
            }
            this.sendOrgAndChannelMq(context, (String)rangeType2, codes);
        });
    }

    private void sendOrgAndChannelMq(ActivityExecutionResolveContext context, String rangeType2, List<String> codes) {
        PageDataAdviser pageDataAdviser = new PageDataAdviser(this.jobHelper.getJobBizDataPageSize());
        long total = this.jobHelper.getJobBizDataPageSize();
        while (pageDataAdviser.hasNext(Long.valueOf(total))) {
            PageResult<SfaClientData> pageResult = SfaActivityEnum.rangeType.CHANNEL.getVal().equals(rangeType2) ? SfaClientHelper.loadTerminalClientDataByChannelCodes(codes, pageDataAdviser.nextPage(), pageDataAdviser.getPageSize()) : SfaClientHelper.loadTerminalClientDataByOrgCodes(codes, pageDataAdviser.nextPage(), pageDataAdviser.getPageSize());
            List clientDataList = pageResult.getData();
            this.sendMq(clientDataList, context);
            total = pageResult.getCount();
        }
    }

    private void sendMq(List<SfaClientData> clientDataList, ActivityExecutionResolveContext context) {
        ActivityExecutionResolveContext.DayContext dayContext = context.getDayContext();
        ArrayList resolveDataList = new ArrayList();
        ActivityExecutionResolveData resolveData = dayContext.getResolveData();
        clientDataList.forEach(data -> {
            if (dayContext.needSend(data.getClientCode())) {
                ActivityExecutionResolveData temp = new ActivityExecutionResolveData();
                temp.setClientData((SfaClientData)data);
                temp.setActivityExecutionEntity(resolveData.getActivityExecutionEntity());
                temp.setResolveDate(resolveData.getResolveDate());
                resolveDataList.add(temp);
            }
        });
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        List list = Lists.partition(resolveDataList, (int)100);
        for (List data2 : list) {
            mqMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal((Object)data2));
            mqMessageBody.setTag("SFA_ACTIVITY_EXECUTION_RESOLVE");
            this.rocketMQProducer.convertAndSend(mqMessageBody);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getResolvedDays(String lastResolveEndDate, LocalDate localDateNow, boolean compensation) {
        LocalDate localDateLastResolveEnd = StringUtils.isBlank((CharSequence)lastResolveEndDate) ? LocalDate.now() : LocalDate.parse(lastResolveEndDate, CrmDateUtils.yyyyMMdd);
        long days = localDateNow.toEpochDay() - localDateLastResolveEnd.toEpochDay();
        if (days > 0L) {
            if (!compensation) return 0L;
            return -days;
        }
        if (days >= 0L) return days;
        return Math.abs(days) + 1L;
    }
}

