/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.impl.ActivityCostVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.component.impl.ActivityDisplayVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.component.impl.CompetitorVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.component.impl.OrderVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.component.impl.StockInventoryVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.component.impl.StoreCheckVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.component.impl.SummaryVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.req.SfaVisitExceptionReq;
import com.biz.crm.moblie.controller.visit.req.SfaVisitInOutReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.SummaryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExceptionResp;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExecuteResp;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.SummaryStepExecuteDataResp;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoRedisDataServiceEsImpl;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaVisitController"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u65e5\u7a0b\u9875\u9762-\u62dc\u8bbf\u6267\u884c"})
public class SfaVisitController {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitController.class);
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private ISfaVisitDealerDetailService sfaVisitDealerDetailService;
    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private ActivityCostVisitStepExecutor activityCostVisitStepExecutor;
    @Resource
    private ActivityDisplayVisitStepExecutor activityDisplayVisitStepExecutor;
    @Resource
    private CompetitorVisitStepExecutor competitorVisitStepExecutor;
    @Resource
    private OrderVisitStepExecutor orderVisitStepExecutor;
    @Resource
    private StockInventoryVisitStepExecutor stockInventoryVisitStepExecutor;
    @Resource
    private StoreCheckVisitStepExecutor storeCheckVisitStepExecutor;
    @Resource
    private SummaryVisitStepExecutor summaryVisitStepExecutor;
    @Resource
    private SfaVisitPlanInfoRedisDataServiceEsImpl sfaVisitPlanInfoRedisDataServiceEsImpl;
    @Autowired
    private ISfaVisitStepFromService sfaVisitStepFromService;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6307\u5b9a\u65e5\u671f\u7684\u62dc\u8bbf\u5217\u8868")
    @PostMapping(value={"/getVisitInfoList"})
    @CrmLog
    public Result<SfaVisitResp> getVisitInfoList(@RequestBody GetVisitListReq req) {
        if (StringUtils.isEmpty((String)req.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            req.setVisitUserName(userRedis.getUsername());
            req.setVisitPositionCode(userRedis.getPoscode());
        }
        return Result.ok((Object)this.sfaVisitPlanInfoService.getVisitInfoList(req));
    }

    @ApiOperation(value="\u62dc\u8bbf-\u67e5\u8be2\u62dc\u8bbf\u5ba2\u6237\u4fe1\u606f\u3001\u6b65\u9aa4\u5217\u8868")
    @PostMapping(value={"/getVisitSteps"})
    @CrmLog
    public Result<SfaVisitExecuteResp> getVisitSteps(@RequestBody CrmRedisHashKeyVo redisHashKeyVo) {
        return Result.ok((Object)((Object)this.sfaVisitDealerDetailService.getVisitSteps(redisHashKeyVo)));
    }

    @ApiOperation(value="\u62dc\u8bbf-\u67e5\u8be2\u62dc\u8bbf\u5ba2\u6237\u4fe1\u606f\u3001\u6b65\u9aa4\u5217\u8868-\u62dc\u8bbf\u5b8c\u6210\u540e")
    @PostMapping(value={"/getVisitExecuteInfoById"})
    @CrmLog
    public Result<SfaVisitExecuteResp> getVisitStepsOfComplete(String visitInfoId) {
        return Result.ok((Object)((Object)this.sfaVisitPlanInfoRedisDataServiceEsImpl.getVisitStepsOfComplete(visitInfoId)));
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u4fe1\u606f")
    @PostMapping(value={"/queryVisitInfo"})
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result<SfaVisitDealerDetailRespVo> queryVisitInfo(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        SfaVisitDealerDetailRespVo respVo = this.sfaVisitDealerDetailService.query(sfaVisitDealerDetailReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u62dc\u8bbf\u8fdb\u5e97\u6253\u5361")
    @PostMapping(value={"/visitInStore"})
    @CrmLog
    public Result visitInStore(@RequestBody SfaVisitInOutReq inOutReq) {
        this.sfaVisitDealerDetailService.visitInStore(inOutReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u79bb\u5e97\u6253\u5361")
    @PostMapping(value={"/visitOutStore"})
    @CrmLog
    public Result visitOutStore(@RequestBody SfaVisitInOutReq inOutReq) {
        this.sfaVisitDealerDetailService.visitOutStore(inOutReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u5f02\u5e38\u63d0\u62a5")
    @PostMapping(value={"/visitException"})
    @CrmLog
    public Result<SfaVisitExceptionResp> visitException(@RequestBody SfaVisitExceptionReq exceptionReq) {
        return Result.ok((Object)((Object)this.sfaVisitDealerDetailService.visitException(exceptionReq)));
    }

    @ApiOperation(value="\u62dc\u8bbf-\u67e5\u8be2\u62dc\u8bbf\u5f02\u5e38\u4fe1\u606f")
    @PostMapping(value={"/getVisitExceptionInfoById"})
    @CrmLog
    public Result<SfaVisitExceptionResp> getVisitExceptionInfoById(String visitInfoId) {
        SfaVisitExceptionResp resp = new SfaVisitExceptionResp();
        SfaVisitPlanInfoExecuteRedisData redisData = this.sfaVisitPlanInfoRedisDataServiceEsImpl.getVisitExcuteInfo(visitInfoId);
        resp.setVisitExceptionPics(redisData.getVisitExceptionPics());
        resp.setExceptionDetail(redisData.getExceptionDetail());
        return Result.ok((Object)((Object)resp));
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u62dc\u8bbf\u603b\u7ed3")
    @PostMapping(value={"/saveVisitStepSummary"})
    @CrmLog
    public Result saveVisitStepSummary(@RequestBody VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        this.summaryVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u62dc\u8bbf\u603b\u7ed3-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepSummary"})
    @CrmLog
    public Result<SummaryStepExecuteDataResp> loadVisitStepSummary(@RequestBody ExecutorLoadReq redisHashKey) {
        SummaryStepExecuteDataResp dataResp = (SummaryStepExecuteDataResp)this.summaryVisitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="(\u5c0f\u5730\u56fe)\u67e5\u8be2\u62dc\u8bbf\u5b8c\u6210\u7684\u6570\u636e\u4fe1\u606f")
    @PostMapping(value={"/findSfaVisitDealerVisitComplete"})
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findSfaVisitDealerVisitComplete(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        List<SfaVisitPlanInfoRespVo> sfaVisitDealerDetailRespVos = this.sfaVisitDealerDetailService.findSfaVisitMapComplete(reqVo);
        return Result.ok(sfaVisitDealerDetailRespVos);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e93\u5b58\u76d8\u70b9")
    @PostMapping(value={"/saveVisitStepStockInventory"})
    @CrmLog
    public Result saveVisitStepStockInventory(@RequestBody VisitStepExecuteReq<StockInventoryStepExecuteData> visitStepExecuteReq) {
        this.stockInventoryVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e93\u5b58\u76d8\u70b9-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepStockInventory"})
    @CrmLog
    public Result<StockInventoryStepExecuteDataResp> loadVisitStepStockInventory(@RequestBody ExecutorLoadReq redisHashKey) {
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp)this.stockInventoryVisitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u7ade\u54c1\u91c7\u96c6")
    @PostMapping(value={"/saveVisitStepCompetitor"})
    @CrmLog
    public Result saveVisitStepCompetitor(@RequestBody VisitStepExecuteReq<CompetitorStepExecuteData> visitStepExecuteReq) {
        this.competitorVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u7ade\u54c1\u91c7\u96c6-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepCompetitor"})
    @CrmLog
    public Result<CompetitorStepExecuteDataResp> loadVisitStepCompetitor(@RequestBody ExecutorLoadReq redisHashKey) {
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)this.competitorVisitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u8ba2\u5355\u91c7\u96c6")
    @PostMapping(value={"/saveVisitStepOrders"})
    @CrmLog
    public Result saveVisitStepOrder(@RequestBody VisitStepExecuteReq<OrderStepExecuteData> visitStepExecuteReq) {
        this.orderVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u8ba2\u5355\u91c7\u96c6-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepOrders"})
    @CrmLog
    public Result<OrderStepExecuteDataResp> loadVisitStepOrder(@RequestBody ExecutorLoadReq redisHashKey) {
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)this.orderVisitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e97\u9762\u68c0\u67e5")
    @PostMapping(value={"/saveVisitStepStoreCheck"})
    @CrmLog
    public Result saveVisitStepStoreCheck(@RequestBody VisitStepExecuteReq<StoreCheckStepExecuteData> visitStepExecuteReq) {
        this.storeCheckVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e97\u9762\u68c0\u67e5-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepStoreCheck"})
    @CrmLog
    public Result<StoreCheckStepExecuteDataResp> loadVisitStepStoreCheck(@RequestBody ExecutorLoadReq redisHashKey) {
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)this.storeCheckVisitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @CrmLog
    @ApiOperation(value="\u62dc\u8bbf\u6d3b\u52a8\u6267\u884c\u5217\u8868")
    @PostMapping(value={"findVisitActivityExecutionList"})
    public Result<List<SfaActivityExecutionEntityResp>> findVisitActivityExecutionList(@RequestBody LoadVisitActivityListReq reqVo) {
        List<SfaActivityExecutionEntityResp> pageResult = this.sfaVisitStepActivityExecutionService.loadVisitActivityList(reqVo);
        return Result.ok(pageResult);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u6d3b\u52a8\u6267\u884c")
    @PostMapping(value={"/saveVisitStepActivity"})
    @CrmLog
    public Result saveVisitStepActivity(@RequestBody VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq) {
        ActivityStepExecuteData dataReq = visitStepExecuteReq.getStepExecuteData();
        if (null == dataReq) {
            throw new BusinessException("\u8bf7\u6c42\u53c2\u6570\u6267\u884c\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dataReq.getId())) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u660e\u7ec6ID\u4e3a\u7a7a");
        }
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)this.sfaVisitStepActivityExecutionService.getById((Serializable)((Object)visitStepExecuteReq.getStepExecuteData().getId()));
        if (null == executionEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u660e\u7ec6");
        }
        this.checkDistance(visitStepExecuteReq, executionEntity);
        if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(executionEntity.getActivityType())) {
            this.activityDisplayVisitStepExecutor.execute(visitStepExecuteReq);
        } else {
            this.activityCostVisitStepExecutor.execute(visitStepExecuteReq);
        }
        return Result.ok();
    }

    private void checkDistance(VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq, SfaVisitStepActivityExecutionEntity entity) {
        SfaVisitStepFromEntity stepFromEntity;
        ActivityStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getLongitude())) {
            throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getLatitude())) {
            throw new BusinessException("\u7eac\u5ea6\u4e3a\u7a7a");
        }
        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null && (stepFromEntity = (SfaVisitStepFromEntity)((Object)((LambdaQueryChainWrapper)this.sfaVisitStepFromService.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitStepExecuteReq.getFormId())).one())) != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue()) && StringUtils.isNotEmpty((String)stepFromEntity.getDistance())) {
            BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, 5);
            log.info("\u5f53\u524d\u6b65\u9aa4\u914d\u7f6e\u7684\u8ddd\u79bb:{}", (Object)distance);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{},\u62dc\u8bbf\u5ba2\u6237\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{}", new Object[]{stepExecuteData.getLongitude(), stepExecuteData.getLatitude(), entity.getLongitude(), entity.getLatitude()});
            double data = LocationUtils.getDistance(new BigDecimal(stepExecuteData.getLongitude()), new BigDecimal(stepExecuteData.getLatitude()), new BigDecimal(entity.getLongitude()), new BigDecimal(entity.getLatitude()));
            BigDecimal nowDistance = new BigDecimal(data).setScale(2, 5);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u8ddd\u79bb\u62dc\u8bbf\u5ba2\u6237\u7684\u8ddd\u79bb:{}", (Object)nowDistance);
            if (distance.compareTo(nowDistance) == -1) {
                throw new BusinessException("\u60a8\u672a\u5728\u5ba2\u6237\u8ddd\u79bb" + distance + "M\u5185\uff0c\u8bf7\u524d\u5f80\u5ba2\u6237\u5730\u5740\u8fdb\u884c\u64cd\u4f5c\uff01");
            }
        }
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u6d3b\u52a8\u6267\u884c-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepActivity"})
    @CrmLog
    public Result<ActivityStepExecuteDataResp> loadVisitStepActivity(@RequestBody ActivityExecutorLoadReq redisHashKey) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)redisHashKey.getId())) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u660e\u7ec6ID\u4e3a\u7a7a");
        }
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)this.sfaVisitStepActivityExecutionService.getById((Serializable)((Object)redisHashKey.getId()));
        if (null == executionEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u660e\u7ec6");
        }
        ActivityStepExecuteDataResp dataResp = SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(executionEntity.getActivityType()) ? (ActivityStepExecuteDataResp)this.activityDisplayVisitStepExecutor.load(redisHashKey) : (ActivityStepExecuteDataResp)this.activityCostVisitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }
}

