/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.enums.SfaWorkSummaryEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.req.SfaUnfamiliarTempPlanInfoReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitTempPlanReqVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitnote.req.SfaVisitTempPlanReq;
import com.biz.crm.visitnote.service.ISfaVisitTempPlanService;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitTempPlanServiceExpandImpl"})
public class SfaVisitTempPlanServiceImpl
implements ISfaVisitTempPlanService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitTempPlanServiceImpl.class);
    @Resource
    private ISfaVisitPlanInfoService iSfaVisitPlanInfoService;
    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;

    @Override
    @Transactional
    public void addTempPlanInfoForWorkbench(SfaVisitTempPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitRealName(userRedis.getRealname());
            reqVo.setVisitPosCode(userRedis.getPoscode());
            reqVo.setVisitPosName(userRedis.getPosname());
            reqVo.setVisitOrgCode(userRedis.getOrgcode());
            reqVo.setVisitOrgName(userRedis.getOrgname());
        }
        this.saveCheck(reqVo);
        this.addPlanInfoForTempPlan(reqVo);
    }

    private void addPlanInfoForTempPlan(SfaVisitTempPlanReqVo reqVo) {
        ArrayList planInfoEntities = Lists.newArrayList();
        List sfaVisitPlanRangeReqVos = reqVo.getSfaVisitPlanRangeReqVos();
        List<String> customerCodes = sfaVisitPlanRangeReqVos.stream().filter(v -> SfaVisitEnum.ClientType.DEALER.getVal().equals(v.getClientType())).map(SfaVisitPlanRangeReqVo::getClientCode).collect(Collectors.toList());
        List<String> terminalCodes = sfaVisitPlanRangeReqVos.stream().filter(v -> SfaVisitEnum.ClientType.TERMINAL.getVal().equals(v.getClientType())).map(SfaVisitPlanRangeReqVo::getClientCode).collect(Collectors.toList());
        Map<String, SfaClientData> clientDataMap = SfaClientHelper.loadClientDataMap(customerCodes, terminalCodes);
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo : sfaVisitPlanRangeReqVos) {
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanInfoEntity.class);
            SfaClientData clientData = clientDataMap.get(sfaVisitPlanRangeReqVo.getClientType() + sfaVisitPlanRangeReqVo.getClientCode());
            if (null == clientData) {
                throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5ba2\u6237\u6570\u636e[" + sfaVisitPlanRangeReqVo.getClientCode() + "]");
            }
            SfaVisitPlanInfoEntity.copyClientData(sfaVisitPlanInfoEntity, clientData);
            sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
            sfaVisitPlanInfoEntity.setVisitDate(reqVo.getVisitStartDate());
            LocalDate date = LocalDate.parse(reqVo.getVisitStartDate(), CrmDateUtils.yyyyMMdd);
            sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(date.format(CrmDateUtils.yyyyMM));
            sfaVisitPlanInfoEntity.setVisitDateOfYear(date.format(CrmDateUtils.yyyy));
            sfaVisitPlanInfoEntity.setVisitType(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
            sfaVisitPlanInfoEntity.setVisitTypeName(SfaVisitEnum.visitType.TEMP_VISIT.getDesc());
            sfaVisitPlanInfoEntity.setVisitPlanCode(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
            sfaVisitPlanInfoEntity.setRouteType(SfaVisitEnum.routeTypeEnum.R2.getVal());
            sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
            sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());
            sfaVisitPlanInfoEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            sfaVisitPlanInfoEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
            CrmBaseEntity.buildDefEntityData((CrmBaseEntity)sfaVisitPlanInfoEntity);
            planInfoEntities.add(sfaVisitPlanInfoEntity);
        }
        this.doAddPlanInfoForTempPlan(planInfoEntities);
    }

    @Override
    public SfaVisitResp.SfaVisitPlanInfoResp addTempPlanInfoForUnfamiliar(SfaUnfamiliarTempPlanInfoReq sfaUnfamiliarTempPlanInfoReq) {
        if (StringUtils.isEmpty((String)sfaUnfamiliarTempPlanInfoReq.getAmapId())) {
            throw new BusinessException("\u5730\u56feID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)sfaUnfamiliarTempPlanInfoReq.getClientName())) {
            throw new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)sfaUnfamiliarTempPlanInfoReq.getClientAddress())) {
            throw new BusinessException("\u5730\u5740\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)sfaUnfamiliarTempPlanInfoReq.getLongitude())) {
            throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)sfaUnfamiliarTempPlanInfoReq.getLatitude())) {
            throw new BusinessException("\u7eac\u5ea6\u4e3a\u7a7a");
        }
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)CrmBeanUtil.copy((Object)sfaUnfamiliarTempPlanInfoReq, SfaVisitPlanInfoEntity.class);
        sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getDesc());
        sfaVisitPlanInfoEntity.setClientCode(sfaUnfamiliarTempPlanInfoReq.getAmapId());
        sfaVisitPlanInfoEntity.setClientName(sfaUnfamiliarTempPlanInfoReq.getClientName());
        sfaVisitPlanInfoEntity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        sfaVisitPlanInfoEntity.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
        this.doAddTempPlanInfoForNearby(sfaVisitPlanInfoEntity);
        SfaVisitResp.SfaVisitPlanInfoResp SfaVisitPlanInfoResp2 = (SfaVisitResp.SfaVisitPlanInfoResp)((Object)CrmBeanUtil.copy((Object)sfaVisitPlanInfoEntity, SfaVisitResp.SfaVisitPlanInfoResp.class));
        this.sfaVisitRoleDirectoryService.buildSfaVisitPlanInfoFormId(SfaVisitPlanInfoResp2, sfaVisitPlanInfoEntity.getVisitPosCode());
        return SfaVisitPlanInfoResp2;
    }

    @Override
    public Integer getVisitNum(String dateFlag2) {
        AssertUtils.isNotEmpty((String)dateFlag2, (String)"\u8bf7\u4f20\u5165\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u7c7b\u578b\u2014\u2014\u672c\u65e5\u3001\u672c\u5468\u3001\u672c\u6708");
        UserRedis user = UserUtils.getUser();
        LocalDate nowTime = LocalDate.now();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(SfaAchievementAccomplishRecordEntity::getIndexCode, (Object)SfaVisitEnum.indexType.WDBF.getCode())).eq(SfaAchievementAccomplishRecordEntity::getUsername, (Object)user.getUsername());
        if (SfaWorkSummaryEnum.dateFlag.TODAY.getCode().equals(dateFlag2)) {
            String dayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.eq(CrmBaseEntity::getCreateDate, (Object)dayTime);
        }
        if (SfaWorkSummaryEnum.dateFlag.WEEK.getCode().equals(dateFlag2)) {
            String weekTime = nowTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).format(CrmDateUtils.yyyyMMdd);
            String nowDayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.between(CrmBaseEntity::getCreateDate, (Object)weekTime, (Object)nowDayTime);
        }
        if (SfaWorkSummaryEnum.dateFlag.MONTH.getCode().equals(dateFlag2)) {
            String monthTime = nowTime.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            queryWrapper.like(CrmBaseEntity::getCreateDate, (Object)monthTime);
        }
        int count = this.sfaAchievementAccomplishRecordService.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public SfaVisitResp.SfaVisitPlanInfoResp addTempPlanInfoForNearby(SfaVisitTempPlanReq sfaVisitTempPlanReq) {
        if (StringUtils.isEmpty((String)sfaVisitTempPlanReq.getClientCode())) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)sfaVisitTempPlanReq.getClientType())) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        SfaClientData clientData = SfaClientHelper.loadClientData(sfaVisitTempPlanReq.getClientType(), sfaVisitTempPlanReq.getClientCode());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)CrmBeanUtil.copy((Object)clientData, SfaVisitPlanInfoEntity.class);
        sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());
        this.doAddTempPlanInfoForNearby(sfaVisitPlanInfoEntity);
        SfaVisitResp.SfaVisitPlanInfoResp SfaVisitPlanInfoResp2 = (SfaVisitResp.SfaVisitPlanInfoResp)((Object)CrmBeanUtil.copy((Object)sfaVisitPlanInfoEntity, SfaVisitResp.SfaVisitPlanInfoResp.class));
        this.sfaVisitRoleDirectoryService.buildSfaVisitPlanInfoFormId(SfaVisitPlanInfoResp2, sfaVisitPlanInfoEntity.getVisitPosCode());
        return SfaVisitPlanInfoResp2;
    }

    private SfaVisitPlanInfoEntity doAddTempPlanInfoForNearby(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        UserRedis userRedis = UserUtils.getUser();
        sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
        sfaVisitPlanInfoEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        sfaVisitPlanInfoEntity.setVisitUserName(userRedis.getUsername());
        sfaVisitPlanInfoEntity.setVisitRealName(userRedis.getRealname());
        sfaVisitPlanInfoEntity.setVisitPosCode(userRedis.getPoscode());
        sfaVisitPlanInfoEntity.setVisitPosName(userRedis.getPosname());
        sfaVisitPlanInfoEntity.setVisitOrgCode(userRedis.getOrgcode());
        sfaVisitPlanInfoEntity.setVisitOrgName(userRedis.getOrgname());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)userRedis.getOrgcode());
        if (null != mdmOrgRespVo) {
            sfaVisitPlanInfoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
            sfaVisitPlanInfoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
        }
        sfaVisitPlanInfoEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        sfaVisitPlanInfoEntity.setVisitPlanCode(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
        sfaVisitPlanInfoEntity.setRouteType(SfaVisitEnum.routeTypeEnum.R2.getVal());
        sfaVisitPlanInfoEntity.setVisitType(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitTypeName(SfaVisitEnum.visitType.TEMP_VISIT.getDesc());
        sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
        LocalDate date = LocalDate.now();
        sfaVisitPlanInfoEntity.setVisitDate(date.format(CrmDateUtils.yyyyMMdd));
        sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(date.format(CrmDateUtils.yyyyMM));
        sfaVisitPlanInfoEntity.setVisitDateOfYear(date.format(CrmDateUtils.yyyy));
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)sfaVisitPlanInfoEntity);
        this.doAddPlanInfoForTempPlan(Lists.newArrayList((Object[])new SfaVisitPlanInfoEntity[]{sfaVisitPlanInfoEntity}));
        return sfaVisitPlanInfoEntity;
    }

    private void doAddPlanInfoForTempPlan(List<SfaVisitPlanInfoEntity> planInfoEntities) {
        String redisHash = this.iSfaVisitPlanInfoService.checkAddForTempPlan(planInfoEntities);
        this.sfaVisitPlanInfoServiceEsImpl.saveAll(planInfoEntities);
        Map<String, SfaVisitPlanInfoEntity> map = planInfoEntities.stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getRedisHashKey, v -> v, (t, t2) -> t2));
        this.redisService.hmset(redisHash, map, 1296000L);
    }

    public void saveCheck(SfaVisitTempPlanReqVo reqVo) {
        LocalDate beginDate;
        AssertUtils.isNotEmpty((String)reqVo.getPlanType(), (String)"\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!SfaVisitEnum.visitType.GETMAP.containsKey(reqVo.getPlanType())) {
            throw new BusinessException("\u62dc\u8bbf\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u62dc\u8bbf\u7c7b\u578b(\u4e34\u65f6\u62dc\u8bbf\u3001\u8ba1\u5212\u62dc\u8bbf\u3001\u534f\u8bbf)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getRouteType(), (String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a(\u7ebf\u8def\u7ec4\u3001\u7f51\u70b9\u3001\u9891\u7387)");
        if (!SfaVisitEnum.routeTypeEnum.GETMAP.containsKey(reqVo.getRouteType())) {
            throw new BusinessException("\u7ef4\u5ea6\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6(\u7ebf\u8def\u7ec4\u3001\u7f51\u70b9\u3001\u9891\u7387)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitRealName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosName(), (String)"\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgCode(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgName(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitStartDate(), (String)"\u4e34\u65f6\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            beginDate = LocalDate.parse(reqVo.getVisitStartDate(), CrmDateUtils.yyyyMMdd);
            SfaVisitPlanResolver.futureDaysCheck(beginDate);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException("\u4e34\u65f6\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        reqVo.setVisitEndDate(reqVo.getVisitStartDate());
        if (!CollectionUtil.listNotEmpty((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u5236\u5b9a\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = 1;
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo : reqVo.getSfaVisitPlanRangeReqVos()) {
            if (SfaVisitEnum.routeTypeEnum.R1.getVal().equals(reqVo.getRouteType())) {
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getVisitGroupId(), (String)("\u7ebf\u8def\u7ec4" + i + ",\u7ebf\u8def\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getVisitGroupName(), (String)("\u7ebf\u8def\u7ec4" + i + ",\u7ebf\u8def\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            } else {
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientCode(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientName(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientType(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                if (SfaVisitEnum.routeTypeEnum.R3.getVal().equals(reqVo.getRouteType())) {
                    AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getFirstVisitDate(), (String)("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
                    LocalDate firstVisitDate = null;
                    try {
                        firstVisitDate = LocalDate.parse(sfaVisitPlanRangeReqVo.getFirstVisitDate(), CrmDateUtils.yyyyMMdd);
                    }
                    catch (Exception e) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (Throwable)e);
                    }
                    if (beginDate.isAfter(firstVisitDate) || firstVisitDate.isAfter(beginDate)) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u4e0d\u5728\u5faa\u73af\u65e5\u671f\u5185");
                    }
                    if (null == sfaVisitPlanRangeReqVo.getVisitFrequency()) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    try {
                        String regex = "^[1-9]+[0-9]*$";
                        Pattern p = Pattern.compile(regex);
                        Matcher m = p.matcher(sfaVisitPlanRangeReqVo.getVisitFrequency().toString());
                        if (!m.find()) {
                            System.out.println("falsss");
                            throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570", (Throwable)e);
                    }
                    if (sfaVisitPlanRangeReqVo.getVisitFrequency() <= 0) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                    }
                }
            }
            ++i;
        }
    }
}

